package model.etagerecreator;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.ArrayList;
import java.util.List;

import dressing.controller.Piece2DCreator;
import dressing.model.Caisson;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.EtagereDistances;
import dressing.model.Materiaux;
import dressing.model.Separator;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.CaissonMontageType;
import dressing.model.types.CaissonType;
import dressing.model.types.DosType;
import dressing.model.types.PieceType;
import dressing.model.types.PortType;
import dressing.model.types.PositionReferenceType;
import dressing.model.types.SeprationAxe;
import utils.ParametersUtils;

public class EtagereCreator extends CommonEtagereParent{
DesignObject3D parent;
String typeCalcul="";
Separator sepTransversale=new Separator();
Separator sepNormale=new Separator();
public Caisson caisson =null;
List<EtagereDistances> listDistance = new ArrayList<EtagereDistances>();
	{
	EtagereDistances etgdist=new EtagereDistances();
	etgdist.setEtagereDistance(200.0);
	etgdist.setEtagereNom("etg");
	listDistance.add(etgdist);
	
	etgdist=new EtagereDistances();
	etgdist.setEtagereDistance(200.0);
	etgdist.setEtagereNom("etg");
	listDistance.add(etgdist);
	
	etgdist=new EtagereDistances();
	etgdist.setEtagereDistance(200.0);
	etgdist.setEtagereNom("etg");
	listDistance.add(etgdist);
	
	}
	
	private void CreateCaisson() throws DesignException, GeometricEngineException {
		 caisson = new Caisson();
		    caisson.setName("caisson");
			caisson.setBackmaterial(mdf5);
			caisson.setBasematerial(mdf18);
			caisson.setLongeurext(LONGEUR);
			caisson.setHauteurext(HAUTEUR);
			caisson.setProfondeurext(PROFONDEUR);
			caisson.setParentdesign(dressing);
			caisson.setCuissontype(CaissonType.MONO_CAISSON);
			caisson.setPorttype(PortType.FRANCAISE);
			caisson.setDostype(DosType.DOSINTERIEUR);
			caisson.setCaissonMontageType(CaissonMontageType.CAISSON_MONTAGE_I);
			caisson.constructDebitage();
			caisson.evaluate();	
			
			dressing.addElement(caisson);
			assertNotNull(caisson);
			assertNotNull(dressing);
	}
	private void CreateSeparateurTransversale() throws DesignException, GeometricEngineException {
		CreateCaisson();
		piece2dCreator=new Piece2DCreator();
		piece2dCreator.setBackmaterial(mdf5);
		piece2dCreator.setBasematerial(mdf18);
		piece2dCreator.setParent(caisson);
		PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		
		piece2dCreator.create();
		sepTransversale=(Separator)piece2dCreator.getPiece2DInstance();
	}
	private void CreateSeparateurNoramle() throws DesignException, GeometricEngineException {
		CreateCaisson();
		piece2dCreator=new Piece2DCreator();
		piece2dCreator.setBackmaterial(mdf5);
		piece2dCreator.setBasematerial(mdf18);
		piece2dCreator.setParent(caisson);
		PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		
		piece2dCreator.create();
		sepNormale=(Separator)piece2dCreator.getPiece2DInstance();
	}
	public Separator getSepTransversale() throws DesignException, GeometricEngineException {
		CreateSeparateurTransversale();
		return sepTransversale;
	}
	public void setSepTransversale(Separator sepTransversale) {
		this.sepTransversale = sepTransversale;
	}
	public Separator getSepNormale() throws DesignException, GeometricEngineException {
		CreateSeparateurNoramle();
		return sepNormale;
	}
	public void setSepNormale(Separator sepNormale) {
		this.sepNormale = sepNormale;
	}
	public List<EtagereDistances> getListDistance() {
		return listDistance;
	}
	public void setListDistance(List<EtagereDistances> listDistance) {
		this.listDistance = listDistance;
	}
	public Caisson getCaisson() {
		return caisson;
	}
	public void setCaisson(Caisson caisson) {
		this.caisson = caisson;
	}
	
	
}
