package geometry;

import java.util.ArrayList;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;


public interface IDrawer<T extends Shape> {
	 void begin(boolean closed); //begin the creation of a new shape
	 void edit(T shape);    //edit an ewisting shape
	 T end();         
	 void draw(Matrix4 projection);
	 ArrayList<Vector2> getVertices();
}
