package gdxapp.ui;



import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.Input.Keys;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextArea;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.ui.TextField.TextFieldStyle;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener.ChangeEvent;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Align;
import com.badlogic.gdx.utils.Array;

import gdxapp.assets.AssetsTextures;
import gdxapp.assets.DrawingHelper;

public class UIComponentCreator {
	
	private UIComponentCreator componentCreator = new UIComponentCreator();
	
	private UIComponentCreator() {
		
	}
	
	public static Window createColorPaletteWindow(ColorPalette colorPalette) {		
		Window winPalette = new Window("palette de couleur", AssetsTextures.getInstance().getSkin());
		colorPalette.construct();
		Table winButtons = new Table();
		TextButton btnOk = new TextButton("Ok", AssetsTextures.getInstance().getSkin());
		btnOk.addListener(new ChangeListener() {

			@Override
			public void changed(ChangeEvent event, Actor actor) {
				winPalette.setVisible(false);
			}
			
		});
		winButtons.add(btnOk);
		winPalette.add(colorPalette).row();
		winPalette.add(winButtons);
		winPalette.setColor(1, 1, 1, .8f);
		winPalette.setVisible(false);
		winPalette.pack();
		return winPalette;
	}
	public static Window createAnchorWindow() {		
		Window winPalette = new Window("palette de couleur", AssetsTextures.getInstance().getSkin());
		Table content = new Table();
		TextField tField = new TextField("",AssetsTextures.getInstance().getSkin());
		content.add(tField);
		Table winButtons = new Table();
		TextButton btnOk = new TextButton("Ok", AssetsTextures.getInstance().getSkin());
		btnOk.addListener(new ChangeListener() {

			@Override
			public void changed(ChangeEvent event, Actor actor) {
				winPalette.setVisible(false);
			}
			
		});
		winButtons.add(btnOk);
		winPalette.add(content).row();
		winPalette.add(winButtons);
		winPalette.setColor(1, 1, 1, .8f);
		winPalette.setVisible(false);
		winPalette.pack();
		return winPalette;
	}
	
	
	public UIComponentCreator getComponentCreator() {
		return componentCreator;
	}
	public void setComponentCreator(UIComponentCreator componentCreator) {
		this.componentCreator = componentCreator;
	}
}
