package gdxapp.Commun;

import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;

public class TintedPolySpriteBatch extends PolygonSpriteBatch {

	private static final String vertexSrc = """
												attribute vec4 a_position;
												attribute vec4 a_color;
												attribute vec2 a_texCoord0;
												uniform mat4 u_projTrans;
												varying vec4 v_color;
												varying vec2 v_texCoords;

												void main()
												{
												   v_color = a_color;
												   v_color.a = v_color.a * (255.0/254.0);
												   v_texCoords = a_texCoord0;
												   gl_Position =  u_projTrans * a_position;
												}
											""";

	private static final String fragSrc = """
											  #ifdef GL_ES
											  #define LOWP lowp
											  precision mediump float;
											  #else
											  #define LOWP 
											  #endif
											  varying LOWP vec4 v_color;
											  varying vec2 v_texCoords;
											  uniform sampler2D u_texture;
											  uniform vec4 u_color;
											  void main()
											 {
											   gl_FragColor = u_color * texture2D(u_texture, v_texCoords);
											 }
										""";

	public TintedPolySpriteBatch() {
		super();
		ShaderProgram shader = new ShaderProgram(vertexSrc, fragSrc);
		
		setShader(shader);
	}

	@Override
	public void flush() {
		getShader().setUniformf("u_color", getColor());
		super.flush();
	}

}
