package dressing.ui.util;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

import dressing.events.Event;
import dressing.events.EventDriver;
import dressing.events.EventHandler;
import dressing.model.ModelProvider;
import dressing.model.ProjectManager;
import org.frs.debitage.engine.core.evalutor.GeomtericEngine;
import dressing.ui.engine3d.SceneTexture;
import dressing.ui.engine3d.SceneTexture.CATEGORY;
import dressing.ui.parts.GdxPart;
import dressing.ui.project.GeometricObjectSettingComposite;
import gdxapp.Commun.AbstractScreen;
import gdxapp.object3d.GeometryObject;
import gdxapp.object3d.Object2D;
import gdxapp.object3d.WorldObject;
import gdxapp.scenes.Scene;
import gdxapp.scenes.SceneEvent;
import gdxapp.shaders.PbrMaterial;
import geometry.CompoundObject;
import param.impl.MaterialTypeImpl;

import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.wb.swt.SWTResourceManager;

import org.eclipse.swt.widgets.Combo;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class GeometricObjectConfigWindow extends org.eclipse.jface.window.Window {
		
	
	private PbrMaterial oldMtl;
	private float oldHeight;
	private float oldThickness;
	private GeometryObject geometryObject;
	private GeometryObjectSettingWindowComposite composite;



	public GeometricObjectConfigWindow(Shell parentShell, GeometryObject geometry) {
		super(parentShell);
		setBlockOnOpen(true);
		setGeometryObject(geometry);
	}

	@Override
	protected Control createContents(Composite parent) {
		getShell().setLayout(new GridLayout());
		composite = new GeometryObjectSettingWindowComposite(getShell(), this, geometryObject);
		composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		composite.getCmbVierwerCategory().addSelectionChangedListener(new ISelectionChangedListener() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				if(event.getStructuredSelection()!=null && event.getStructuredSelection().getFirstElement()!=null && event.getStructuredSelection().getFirstElement() instanceof CATEGORY cat) {
					GeometricObjectConfigWindow.this.getShell().setText("Editeur : "+cat.getDisplayName());
				}
	
			}
		});
		ControlAdapter adaptor=new ControlAdapter() {

			@Override
			public void controlResized(ControlEvent e) {
				 Rectangle area2= GeometricObjectConfigWindow.this.getShell().getClientArea();
			     composite.setBounds(area2);
			}
			
		};
		parent.addControlListener(adaptor);
		composite.addControlListener(adaptor);
		getShell().addControlListener(adaptor);		
		composite.pack();
		return composite;
	}

	@Override
	protected boolean canHandleShellCloseEvent() {
		return true;
	}

	@Override
	protected void handleShellCloseEvent() {
		setReturnCode(CANCEL);
		hide();
	}

	private void hide() {
		if (!getShell().isDisposed()) {
			getShell().setVisible(false);
			
		}
	}

	public GeometryObject getGeometryObject() {
		return geometryObject;
	}

	public void setGeometryObject(GeometryObject geometryObject) {
		this.geometryObject = geometryObject;
		this.oldMtl = geometryObject.getGeometry().getBorder().getMaterial().cpy();
		this.oldHeight = geometryObject.getRealWorldPosition().y;
		this.oldThickness = geometryObject.getRealWorldDimension().y;
	}

	public void cancel() {
		this.geometryObject.getRealWorldDimension().y = oldThickness;
		this.geometryObject.getRealWorldPosition().y = oldHeight;
		this.geometryObject.getGeometry().getBorder().setMaterial(oldMtl);
		this.geometryObject.setRequireRefrech(false);
		this.geometryObject = null;
		hide();
	}
	
	public void updateObject() {
		this.geometryObject.setRequireRefrech(true);
		EventDriver.getDriver().deliverEvent(new Event(SceneEvent.OBJECT_CHANGED.name(), this.geometryObject));
		hide();
	}
	
	@Override
	protected Point getInitialSize() {
		return new Point(1080, 600);
	}
}
