package dressing.ui.project;



import java.io.File;

import javax.inject.Inject;

import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

import dressing.model.ProjectManager;
import dressing.model.SuperCadProject;

public class RestoreProjectPage extends WizardPage {
	
	private IEventBroker eventBroker;
	RestoreProjectComposite compos;
	private boolean isProjectSelected;
	private File backupFile;
	public  SuperCadProject project;
	@Inject
	protected RestoreProjectPage(SuperCadProject iproject) {
		super("Import project");
		setDescription("Séléctionner un projet puis clicker Terminer");
		this.project = iproject;
		
	}

	@Override
	public void createControl(Composite parent) {
		compos = new RestoreProjectComposite(parent,this.project, SWT.NONE);

		setControl(compos);
		if(project!=null) {
			compos.getTableViewer().setSelection(new StructuredSelection(project),true);
		}
		compos.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener() {
		    @Override
		    public void selectionChanged(SelectionChangedEvent event) {
		    	   IStructuredSelection selection = (IStructuredSelection) event.getSelection();
			  	      Object selectionobj=  selection.getFirstElement() ;
			  	    backupFile = (File)selectionobj;
			        if(isCurrentPage()) {
						getWizard().getContainer().updateButtons();
					}
		    }
		 });
	}

	@Override
	public boolean isPageComplete() {
		// TODO Auto-generated method stub
		return (this.backupFile!=null);
	}

	public SuperCadProject getProject() {
		return project;
	}

	public void setProject(SuperCadProject project) {
		this.project = project;
	}

	public File getBackupFile() {
		return backupFile;
	}

	public void setBackupFile(File backupFile) {
		this.backupFile = backupFile;
	}
	

}
