package dressing.ui.modelprovders;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider.IStyledLabelProvider;

import dressing.model.Piece2D;

public class MaterialLabelProvider extends LabelProvider implements IStyledLabelProvider {

    @Override
    public StyledString getStyledText(Object element) {
        if (element!=null && element instanceof Piece2D) {
        	Piece2D piece = (Piece2D) element;

                // a directory is just a container and has no size
                return new StyledString(""+piece.getMaterial()==null?" ":piece.getMaterial().getName());
        }
        return new StyledString(" ");
    }
    
}