package dressing.cam.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;

public class Operation implements Cloneable{

	private Tool tool;
	private Usinage usin;
	private double step;
	private double depth;
	private double start; 
	private double end; 
	private String code;	
	private String name;
	CamShape shape;
	PlanUsinage plan;
	
	public Operation(Tool tool, Usinage usin) {
		super();
		this.tool = tool;
		this.usin = usin;
	}
	public Operation( Usinage usin) {
		super();
		this.usin = usin;
	}
	
	public Operation() {
		super();
	}

	public Tool getTool() {
		return tool;
	}

	public void setTool(Tool tool) {
		Tool oldValue=this.tool;
		this.tool = tool;
		firePropertyChange("tool", oldValue, this.tool);
	}

	public Usinage getUsin() {
		return usin;
	}

	public void setUsin(Usinage usin) {
		Usinage oldValue=this.usin;
		this.usin = usin;
		firePropertyChange("usin", oldValue, this.usin);
	}
	
	public double getStep() {
		return step;
	}

	public void setStep(double step) {
		double oldValue=this.step;
		this.step = step;
		firePropertyChange("step", oldValue, this.step);
	}

	public double getDepth() {
		return depth;
	}

	public void setDepth(double depth) {
		double oldValue=this.depth;
		this.depth = depth;
		firePropertyChange("depth", oldValue, this.depth);
	}

	public double getStart() {
		return start;
	}

	public void setStart(double start) {
		double oldValue=this.start;
		this.start = start;
		firePropertyChange("start", oldValue, this.start);
	}

	public double getEnd() {
		return end;
	}

	public void setEnd(double end) {
		double oldValue=this.end;
		this.end = end;
		firePropertyChange("end", oldValue, this.end);
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		String oldValue=this.code;
		this.code = code;
		firePropertyChange("code", oldValue, this.code);
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		String oldValue=this.name;
		this.name = name;
		firePropertyChange("name", oldValue, this.name);
	}

	public boolean check() {
		if(this.step>this.depth) {
			return true;
		}
		if(this.start>this.end) {
			return true;
		}
		
		
		return false;
	}

	public PlanUsinage getPlan() {
		return plan;
	}
	public void setPlan(PlanUsinage plan) {
		this.plan = plan;
	}
	public CamShape getShape() {
		if(shape==null) {
			if(usin instanceof Trou) {
				 shape =new Cercle2D((Trou) getUsin(), plan);
			}else {
				shape=new Cuboid(getUsin(), plan);
			}
		}
		return shape;
	}
	
	public void setShape(CamShape shape) {
		this.shape = shape;
	}
	public PropertyChangeSupport getPropertyChangeSupport() {
		return propertyChangeSupport;
	}

	public void setPropertyChangeSupport(PropertyChangeSupport propertyChangeSupport) {
		this.propertyChangeSupport = propertyChangeSupport;
	}

	transient protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

	public void addPropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(listener);
	}

	public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
	}

	public void removePropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(listener);
	}

	public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
	}

	protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
		if(propertyChangeSupport==null) {
			propertyChangeSupport = new PropertyChangeSupport(this);
		}
		propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
	}
	@Override
	public Operation clone() throws CloneNotSupportedException {
		Operation op=(Operation) super.clone();
		op.usin=null;
		return op;
	}
	
}
