/*
 * Decompiled with CFR 0.152.
 */
package org.frs.serialization.utilities;

import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import org.json.simple.JSONArray;

public class JSONUtilities {
    public static Vector3 toVector3(JSONArray values) {
        Vector3 xyz = new Vector3();
        float[] floatValues = JSONUtilities.toFloatArray(values);
        xyz.set(floatValues);
        return xyz;
    }

    public static Quaternion toQuaternion(JSONArray values) {
        float[] floatValues = JSONUtilities.toFloatArray(values);
        Quaternion quat = new Quaternion(new Vector3(floatValues), floatValues[3]);
        return quat;
    }

    public static float[] toFloatArray(JSONArray values) {
        float[] array = new float[values.size()];
        int i = 0;
        while (i < values.size()) {
            Object value = values.get(i);
            if (value instanceof Float) {
                array[i] = ((Float)value).floatValue();
            } else if (value instanceof Long) {
                array[i] = (float)((Long)value).longValue() + 0.0f;
            } else if (value instanceof Double) {
                array[i] = (float)((Double)value).doubleValue();
            }
            ++i;
        }
        return array;
    }
}

