package supercad.p2.update;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.IProgressMonitor;

public class LoggingProgressMonitor implements IProgressMonitor {

    private final IProgressMonitor delegate;
	private List<LogListner> logListners = new ArrayList();

    public LoggingProgressMonitor(IProgressMonitor delegate) {
        this.delegate = delegate;
    }

    @Override
    public void beginTask(String name, int totalWork) {
    	notifyLog("beginTask: " + name + " (Total work: " + totalWork + ")");
        delegate.beginTask(name, totalWork);
    }

    @Override
    public void done() {
    	notifyLog("done()");
        delegate.done();
    }

    @Override
    public void internalWorked(double work) {
    	notifyLog("internalWorked: " + work);
        delegate.internalWorked(work);
    }

    @Override
    public boolean isCanceled() {
        return delegate.isCanceled();
    }

    @Override
    public void setCanceled(boolean value) {
    	notifyLog("Cancenled : " + value);
        delegate.setCanceled(value);
    }

    @Override
    public void setTaskName(String name) {
    	notifyLog("setTaskName: " + name);
        delegate.setTaskName(name);
    }

    @Override
    public void subTask(String name) {
    	notifyLog("subTask: " + name);
        delegate.subTask(name);
    }

    @Override
    public void worked(int work) {
    	notifyLog("worked: " + work);
        delegate.worked(work);
    }
    
	public void addLogListner(LogListner loglistner) {
		// TODO Auto-generated method stub
		if(logListners!=null) {
			logListners.add(loglistner);
		}
	}

	private void notifyLog(String msg) {
        System.err.println(msg);
		for(LogListner lisnet : logListners) {
			lisnet.updateLog(msg);
		}
	}
}