package gdxapp.tests;

import java.util.ArrayList;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.Texture.TextureFilter;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g3d.Environment;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.shaders.DefaultShader;
import com.badlogic.gdx.graphics.g3d.utils.CameraInputController;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;

import dressing.ui.util.ModelInstanceConfigWindow;
import gdxapp.assets.AssetsTextures;
import gdxapp.object3d.PolygonBuilder;
import geometry.Polygon;
import param.Vertex;

public class TestScreen implements Screen{
	
	Camera camera;
	ModelBatch batch;
	ModelInstance instance;
	Environment environment;
	CameraInputController camController;
	Array<ModelInstance> instances = new Array<ModelInstance>();

	@Override
	public void show() {

		environment = new Environment();
		environment.set(new ColorAttribute(ColorAttribute.AmbientLight, 0.4f, 0.4f, 0.4f, 1f));
		environment.add(new DirectionalLight().set(0.8f, 0.8f, 0.8f, -1f, 0.8f, -0.9f));
		camera = new PerspectiveCamera(60,Gdx.graphics.getWidth(),Gdx.graphics.getHeight());
		camera.position.set(5,0,5);
		camera.lookAt(0,0,0);
		camera.up.set(0,1,0);
		camera.near = 0.5f;
		camera.far = 10;
		camera.update();
		camController = new CameraInputController(camera);
		Gdx.input.setInputProcessor(camController);
		batch = new ModelBatch();
		createObjects();
		
	}

	private void createObjects() {
		Material mtl = new Material();
		int attr = VertexAttributes.Usage.Position | VertexAttributes.Usage.Normal;
		mtl.set(ColorAttribute.createDiffuse(Color.BLUE));
		ModelBuilder modelBuilder = new ModelBuilder();
		Model cube = modelBuilder.createBox(1, 1, 1, mtl , attr);
		ModelInstance cubeInstance = new ModelInstance(cube);
		instances.add(cubeInstance);
		
	}

	@Override
	public void render(float delta) {
		Gdx.gl20.glClearColor(1f,1,1f,1);
		Gdx.gl.glClear(GL20.GL_COLOR_BUFFER_BIT | GL20.GL_DEPTH_BUFFER_BIT |
				(Gdx.graphics.getBufferFormat().coverageSampling ? GL20.GL_COVERAGE_BUFFER_BIT_NV : 0));
		batch.begin(camera);

		for (ModelInstance instance: instances){
			batch.render(instance,environment);
		}

		batch.end();
	}




	@Override
	public void resize(int width, int height) {

	}

	@Override
	public void pause() {

	}

	@Override
	public void resume() {

	}

	@Override
	public void hide() {

	}

	@Override
	public void dispose() {

	}

}
