package gdxapp.screens.wall;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.math.Vector3;
import dressing.mathutils.Surface;
import gdxapp.Commun.AbstractScreen;
import gdxapp.Commun.GroupSelection;
import gdxapp.Commun.ScreenController;

public class SurfaceScreen extends AbstractScreen {

	
	private Surface surface;
	private SurfaceController controller;
	private static SurfaceScreen instance;

	public SurfaceScreen(Surface surface) {
		super();
		controller = new SurfaceController(surface);
	}

	@Override
	public void show() {
		GroupSelection.getInstance().clearSelection();
		controller.setUpInputMultiplexer();
		controller.reloadActors();
		controller.getChangeCommandController().clear();
		controller.setHandleEvent(true);
	}

	@Override
	public void render(float delta) {
		try {
			Gdx.gl20.glClearColor(1f, 1f, 1f, 1);
			Gdx.gl.glClear(GL20.GL_COLOR_BUFFER_BIT | GL20.GL_DEPTH_BUFFER_BIT
					| (Gdx.graphics.getBufferFormat().coverageSampling ? GL20.GL_COVERAGE_BUFFER_BIT_NV : 0));
			controller.getStage().act();
			controller.getStage().draw();
			controller.drawGrid();
			controller.getUIStage().draw();	
		}catch (Exception e) {
			e.printStackTrace();
			if(controller.getStage().getBatch().isDrawing())
				controller.getStage().getBatch().end();
			controller.reloadActors();
		}
		
	}

	@Override
	public void resize(int width, int height) {
		controller.getStage().getViewport().update(width, height, false);
		controller.getUIStage().getViewport().update(width, height, false);
		controller.resize();
		controller.centerCamera();

	}

	@Override
	public void pause() {}

	@Override
	public void resume() {}

	@Override
	public void hide() {
		controller.getChangeCommandController().clear();
		controller.setHandleEvent(false);
	}

	@Override
	public void dispose() {
		controller.dispose();
	}

	@Override
	public SurfaceController getController() {
		return controller;
	}

	@Override
	public Vector3 toWorldCoordiantes(Vector3 screenCoords) {
		return controller.getSurface().toWorldCoords(screenCoords);
	}
	
	public Surface getSurface() {
		return surface;
	}

	public void setSurface(Surface surface) {
		this.surface = surface;
		controller.setSurface(surface);
	}

	public static SurfaceScreen getInstance(Surface surface) {
		if(instance == null) {
			instance = new SurfaceScreen(surface);
		}else {
			instance.setSurface(surface);
		}
		return instance;
	}
	
	

}
