package gdxapp.screens.room3d;

import org.lwjgl.opengl.GL11;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.FrameBufferCubemap;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Vector3;

import dressing.model.ProjectManager;
import gdx.app.camera.CameraViewSelector;
import gdxapp.Commun.AbstractScreen;
import gdxapp.Commun.GroupSelection;
import gdxapp.animation.AnimationManager;
import gdxapp.animation.CameraAnimator;
import gdxapp.object3d.Object2D;
import gdxapp.object3d.Object3D;
import gdxapp.object3d.WorldObject;
import gdxapp.scenes.SceneEvent;
import supercad.scene.object2d.KitchenElement2D;

public class Room3DScreen extends AbstractScreen {
	
	private final String TAG = Room3DScreen.class.getName();
    Room3DController controller;
    FrameBuffer frameBuffer = null;
    FrameBufferCubemap fbCubeMap; 
    Camera camera;
	private static Room3DScreen instance;
	ShaderProgram program;
	
	CameraViewSelector cameraViewSelector = new CameraViewSelector();
    
	public Room3DScreen(){
        controller=Room3DController.getInstance();
        
    }
    
    public static Room3DScreen getInstance() {
		synchronized(Room3DScreen.class) {
			if (instance == null) {
				instance = new Room3DScreen();
			}
			return instance;
		}
	}
    
    @Override
    public void show() {
    	controller.refresh();
    	controller.setHandleEvent(true);
    	cameraViewSelector.setCameraController(controller.getCameraController());
    	controller.getUIStage().addActor(cameraViewSelector.getUiComponent());
    	cameraViewSelector.getUiComponent().setPosition(100, 100);
    }
    
    public void renderScene(float delta){
        controller.sceneBatch.begin(controller.getCameraController().getCurrentCamera());
        GL11.glLineWidth(1.0f);
        try {
        	for(Object3D instance: controller.getActors()){
            	if(instance instanceof Object3D) {
            		WorldObject object= instance.getWorldObject();
                	if(object == null || !object.isHidden())
                    {
                		instance.render(controller.sceneBatch);
                    }
            	}
            }
        	for(var wall: ProjectManager.getManager().getCurrentScene().getWalls()) {
        		for(var frag: wall.get3DObjects()) {
        			if(!frag.getWorldObject().isHidden())
        			{
        				frag.render(controller.sceneBatch);
        			}
        		}
        	}
        controller.sceneBatch.end();
        for(Object selection : GroupSelection.getInstance().getSelection()) {
        	if( selection instanceof Object3D object)
        	{
        		object.drawBoundaries(controller.getCameraController().getCurrentCamera().combined, Vector3.X, 2.0f);
        	}
        	else if(selection instanceof Object2D object2d && object2d.getWorldObject()!=null) {
        		Object3D object = controller.getObject(object2d.getWorldObject());
        		if(object!=null) {
            		object.drawBoundaries(controller.getCameraController().getCurrentCamera().combined, Vector3.X, 2.0f);
        		}
        	}else if(selection instanceof WorldObject wObject){
        		Object3D object = controller.getObject(wObject);
        		if(object!=null) {
            		object.drawBoundaries(controller.getCameraController().getCurrentCamera().combined, Vector3.X, 2.0f);
        		}
        	}
        	
        }
        controller.renderUI();
        controller.draw();
        cameraViewSelector.draw(controller.getUiStage().getCamera(), 1000 * delta);
        AnimationManager.getInstance().animate( delta);
        }catch (Exception e) {
			e.printStackTrace();
		}finally {
			if(controller.sceneBatch.getCamera()!=null) {
				controller.sceneBatch.end();
			}
		}
    }
    

    
	@Override
    public void render(float delta) {
    	if( ProjectManager.instance.getCurrentScene().requireRefresh) {
    		controller.refresh();
    	}
        controller.getCameraController().update();
        controller.getUiStage().act();
        Gdx.gl20.glClearColor(255/255f, 255/255f,200/255f, 1.0f);
        Gdx.gl.glClear(GL20.GL_COLOR_BUFFER_BIT | GL20.GL_DEPTH_BUFFER_BIT | (Gdx.graphics.getBufferFormat().coverageSampling ? GL20.GL_COVERAGE_BUFFER_BIT_NV : 0));
        renderScene(delta);
        controller.getUiStage().draw();

    }
    
	@Override
    public void resize(int width, int height) {
		var camera = controller.getCameraController().getCamera();
		camera.viewportWidth = width;
		camera.viewportHeight = height;
		camera.update();

    }
    @Override
    public void pause() {

    }
    @Override
    public void resume() {
    	Gdx.app.debug(TAG, "resume of 3d screen....");

    }
    @Override
    public void hide() {
    	controller.setSelection(null);
    	controller.setHandleEvent(false);
    	Gdx.app.debug(TAG, "hide of 3d screen....");
    }
    @Override
    public void dispose() {
    	controller.dispose();
    	frameBuffer.dispose();
    }
	public Room3DController getController() {
		return controller;
	}
	public void setController(Room3DController controller) {
		this.controller = controller;
	}

	@Override
	public Vector3 toWorldCoordiantes(Vector3 screenCoords) {
		// TODO Auto-generated method stub
		return null;
	}
	
}
