package gdxapp.screens.room3d;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import com.badlogic.gdx.math.Vector3;
import dressing.model.ModelProvider;
import dressing.model.ProjectManager;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.ModeledObject;
import gdxapp.object3d.WorldObject;
import geometry.Box;

public class ContainmentManager {
	
	private boolean initialized;
	private static ContainmentManager manager = new ContainmentManager();
	
	
	private ContainmentManager() {}
	
	//for testing purposes
	public void init() throws IOException {
		if(!initialized) {
			initialized = true;
		}
	}
		
	public ArrayList<WorldObject> execute(){
		ArrayList<WorldObject> includedObjects = new ArrayList<WorldObject>();
		List<KitchenElement> containers = ProjectManager.getManager().getCurrentScene().getSceneObjects().stream()
				.filter(o -> o instanceof KitchenElement).map(o -> (KitchenElement)o).toList();
		for(KitchenElement container: containers) {
			includedObjects.addAll(resolveContainment(container));
		}
		return includedObjects;
	}

	public static ContainmentManager getManager() {
		return manager;
	}

	public static void setManager(ContainmentManager manager) {
		ContainmentManager.manager = manager;
	}

	/*
	 * for now we re hardcoding oven and microwave uuid 
	 * must be changed and set by user
	 * 
	 */
	public List<WorldObject> resolveContainment(KitchenElement container) {
		List<WorldObject> contained = new ArrayList<WorldObject>();
		Box ovenSpace = container.getDesignObject().getOvenSpace();
		if(ovenSpace != null) {
			ModeledObject oven = ModelProvider.getModeledObjectById(UUID.fromString("5d5e80c7-b9df-46de-9030-87e1c9b1610a"));
			oven.setRealWorldDimension(ovenSpace.getDimensions().cpy().scl(0.001f));
			var position = container.getRealWorldPosition().cpy()
					.sub(container.getRealWorldDimension().xyz().scl(0.5f))  //move to corner
					.add(ovenSpace.getCenter().cpy().scl(0.001f));
			Vector3 translation = new  Vector3(0,0,0.05f).rotate(Vector3.Y, container.getRotation());
//			translation.scl(0.009f); //this value is model dependent
			position.add(translation);
			oven.setRealWorldPosition(position);
			oven.setRotation(container.getRotation());
			contained.add(oven);
		}
		Box microWaveSpace = container.getDesignObject().getMicrowaveSpace();
		if(microWaveSpace!= null && !microWaveSpace.equals(ovenSpace)) {
			ModeledObject microwave = ModelProvider.getModeledObjectById(UUID.fromString("e5ff4275-c0f6-4239-b9e9-696ec85f4f58"));
			microwave.setRealWorldDimension(microWaveSpace.getDimensions().cpy().scl(0.001f));
			var position = container.getRealWorldPosition().cpy()
					.sub(container.getRealWorldDimension().xyz().scl(0.5f))  //move to corner
					.add(microWaveSpace.getCenter().cpy().scl(0.001f));
			Vector3 translation = new  Vector3(0,0,1).rotate(Vector3.Y, container.getRotation());
			translation.scl(0.018f);
			position.add(translation);
			microwave.setRealWorldPosition(position);
			microwave.setRotation(container.getRotation());
			contained.add(microwave);
		}
		
		return contained;
	}
	
	
}
