package gdxapp.screens.room3d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.Input.Keys;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.input.GestureDetector;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;

import dressing.controller.tools.ToolController;
import gdxapp.Commun.ScreenshotFactory;
import gdxapp.screens.room.RoomController;

public class CameraController extends GestureDetector{

    /** The button for rotating the camera. */
    public int rotateButton = Input.Buttons.LEFT;
    /** The angle to rotate when moved the full width or height of the screen. */
    public float rotateAngle = 90f;
    /** The button for translating the camera along the up/right plane */
    public int translateButtonRight = Input.Keys.RIGHT;
    /** The button for translating the camera along the up/right plane */
    public int translateButtonLeft = Input.Keys.LEFT;
    protected boolean rightPressed=false;
    protected boolean leftPressed=false;

    /** The units to translate the camera when moved the full width or height of the screen. */
    public float translateUnits = 0.5f; // FIXME auto calculate this based on the target
    /** The button for translating the camera along the direction axis */
    public int forwardButton = Input.Keys.UP;
    /** The key which must be pressed to activate rotate, translate and forward or 0 to always activate. */
    public int activateKey = 0;
    /** Indicates if the activateKey is currently being pressed. */
    protected boolean activatePressed;
    /** Whether scrolling requires the activeKey to be pressed (false) or always allow scrolling (true). */
    public boolean alwaysScroll = true;
    /** The weight for each scrolled amount. */
    public float scrollFactor = -0.1f;
    /** World units per screen size */
    public float pinchZoomFactor = 15;
    /** Whether to update the camera after it has been changed. */
    public boolean autoUpdate = true;
    /** The target to rotate around. */
    public Vector3 target = new Vector3();
    /** Whether to update the target on translation */
    public boolean translateTarget = true;
    /** Whether to update the target on forward */
    public boolean forwardTarget = true;
    /** Whether to update the target on scroll */
    public boolean scrollTarget = false;
    public int forwardKey = Input.Keys.Z;
    protected boolean forwardPressed;
    public int levitatetCameraKey = Input.Keys.UP;
    protected boolean levitateCameraPressed;
    public int dropCameraKey = Input.Keys.DOWN;
    protected boolean dropCameraPressed;
    public int backwardKey = Input.Keys.S;
    protected boolean backwardPressed;
    public int rotateRightKey = Input.Keys.D;
    protected boolean rotateRightPressed;
    public int rotateLeftKey = Input.Keys.Q;
    protected boolean rotateLeftPressed;
	private int widenFov = Input.Keys.PLUS;
	private boolean widenFovPressed;
	private int shrinkFov = Input.Keys.MINUS;
	private boolean shrinkFovPressed;

    /** The camera. */
    public Camera camera;
    /** The current (first) button being pressed. */
    protected int button = -1;
    private float startX, startY;
    private final Vector3 tmpV1 = new Vector3();
    private final Vector3 tmpV2 = new Vector3();
    private float c = 1.1f;
    Vector3 center = new Vector3(5,2,5);

    protected static class CameraGestureListener extends GestureDetector.GestureAdapter {
        public CameraController controller;
        private float previousZoom;

        @Override
        public boolean touchDown (float x, float y, int pointer, int button) {
            previousZoom = 0;
            return false;
        }

        @Override
        public boolean tap (float x, float y, int count, int button) {
            return false;
        }

        @Override
        public boolean longPress (float x, float y) {
            return false;
        }

        @Override
        public boolean fling (float velocityX, float velocityY, int button) {
            return false;
        }

        @Override
        public boolean pan (float x, float y, float deltaX, float deltaY) {
            return false;
        }

        @Override
        public boolean zoom (float initialDistance, float distance) {
            float newZoom = distance - initialDistance;
            float amount = newZoom - previousZoom;
            previousZoom = newZoom;
            float w = Gdx.graphics.getWidth(), h = Gdx.graphics.getHeight();
            return controller.pinchZoom(amount / ((w > h) ? h : w));
        }

        @Override
        public boolean pinch (Vector2 initialPointer1, Vector2 initialPointer2, Vector2 pointer1, Vector2 pointer2) {
            return false;
        }
    };

    protected final CameraController.CameraGestureListener gestureListener;

    protected CameraController (final CameraController.CameraGestureListener gestureListener, final Camera camera) {
        super(gestureListener);
        this.gestureListener = gestureListener;
        this.gestureListener.controller = this;
        this.camera = camera;
    }

    public CameraController (final Camera camera) {
        this(new CameraController.CameraGestureListener(), camera);
    }

    public void update () {
        if (rotateRightPressed || rotateLeftPressed || forwardPressed || backwardPressed || levitateCameraPressed || 
        		dropCameraPressed ||leftPressed||rightPressed || widenFovPressed || shrinkFovPressed) {
            final float delta = Gdx.graphics.getDeltaTime();
            if (rotateRightPressed) camera.rotate(camera.up, -delta * rotateAngle);
            if (rotateLeftPressed) camera.rotate(camera.up, delta * rotateAngle);
            if (forwardPressed) {
                camera.translate(tmpV1.set(camera.direction.x,0,camera.direction.z).scl(5 * delta * translateUnits));
                //if (forwardTarget) target.add(tmpV1);
            }
            if (backwardPressed) {
                camera.translate(tmpV1.set(camera.direction.x,0,camera.direction.z).scl(-5 * delta * translateUnits));
                //if (forwardTarget) target.add(tmpV1);
            }
            if(levitateCameraPressed) {
            	  camera.translate(tmpV1.set(0, camera.position.y,0).scl(5 * delta * translateUnits));
                  if (forwardTarget) target.add(tmpV1);
            }
            if(dropCameraPressed) {
            	 camera.translate(tmpV1.set(0, camera.position.y,0).scl(-5 * delta * translateUnits));
                 //if (forwardTarget) target.add(tmpV1);
            }
            if(leftPressed) {
            	moveLeftward();
            }
            if(rightPressed)
            {
            	moveRightward();
            }
            
            if(widenFovPressed) {
            	camera.viewportWidth *= 1.1f;
            }
            
            if(shrinkFovPressed) {
            	camera.viewportWidth *= 0.9f;
            }
            
            if (autoUpdate) camera.update();
        }

    }
    //
    public void moveForward() {
    	 camera.translate(tmpV1.set(camera.direction.x,0,camera.direction.z).scl( translateUnits));
    	 camera.update();
    }
    public void moveBackward() {
        camera.translate(tmpV1.set(camera.direction.x,0,camera.direction.z).scl( -translateUnits));
        camera.update();
    }
    public void moveUpward() {
    	 camera.translate(tmpV1.set(0, camera.position.y,0).scl(0.1f*translateUnits));
    	 camera.update();
    }
    public void moveDownward() {
    	 camera.translate(tmpV1.set(0, camera.position.y,0).scl(0.1f*-translateUnits));
    	 camera.update();
    }
    public void moveLeftward() {
//    	camera.translate(tmpV1.set( camera.direction.x,0,camera.direction.z).crs(camera.direction.cpy()).scl(0.1f*translateUnits));
   	 camera.translate(tmpV1.set(camera.direction).crs(camera.up).scl(-0.1f*translateUnits));
   	 camera.update();
   }
   public void moveRightward() {
//	 camera.translate(tmpV1.set( camera.direction.x,0,camera.direction.z).crs(camera.direction.cpy()).scl(-0.1f*translateUnits));
	 camera.translate(tmpV1.set(camera.direction).crs(camera.up).scl(0.1f*translateUnits));
   	 camera.update();
   }

	public void lookLeftward() {
		camera.rotate(camera.up, 5* Gdx.graphics.getDeltaTime()*rotateAngle);
		camera.update();
	}

	public void lookRightward() {
		camera.rotate(camera.up, -5* Gdx.graphics.getDeltaTime()*rotateAngle);
		camera.update();
	}
	public void lookUpward() {
		camera.rotate(camera.direction.cpy().crs(Vector3.Y), 5* Gdx.graphics.getDeltaTime()*rotateAngle);
		camera.update();
	}

	public void lookDownward() {
//		camera.rotate(new Vector3(0, 0, camera.direction.z), -5* Gdx.graphics.getDeltaTime()*rotateAngle);
		camera.rotate(camera.direction.cpy().crs(Vector3.Y), -5* Gdx.graphics.getDeltaTime()*rotateAngle);

		camera.update();
	}
	public void adjustCamera() {
	   	camera.position.set(0f, 4f, 5f);
//	   	camera.lookAt(0f, 1f, 2f);
   	 	camera.update();
   }
    //
    private int touched;
    private boolean multiTouch;


    @Override
    public boolean touchDown (int screenX, int screenY, int pointer, int button) {
//    	if(ToolController.getInstance().isZOOM()) {
//    		PerspectiveCamera camera=	((PerspectiveCamera)this.camera);
//    		float zoom=camera.fieldOfView;
//    		Vector3 tp = new Vector3();
//    		int amount=1;
//    		if(button == Input.Buttons.LEFT) {
//    			amount=1;
//    		}else if(button == Input.Buttons.RIGHT) {
//    			amount=-1;
//    		}
//    		if(zoom<=0.22f ) {
//    			camera.fieldOfView=0.2f;
//    			if(amount<0) {
//    				amount=0;
//    			}
//			}
//    		if(zoom>=100.0f ) {
//    			camera.fieldOfView=100.0f;
//    			if(amount>0) {
//    				amount=0;
//    			}
//			}
//    		camera.unproject(tp.set(Gdx.input.getX(), Gdx.input.getY(), 0));
//			float px = tp.x;
//			float py = tp.y;
//			camera.fieldOfView +=amount*  10.0f;
//			camera.update();
//    		camera.unproject(tp.set(Gdx.input.getX(), Gdx.input.getY(), 0));
//			camera.position.add(px - tp.x, py - tp.y, 0);
////			camera.position.set(tp);
//			camera.update();
//			return true;
//    	}
        touched |= (1 << pointer);
        multiTouch = !MathUtils.isPowerOfTwo(touched);
        if (multiTouch)
            this.button = -1;
        else if (this.button < 0 && (activateKey == 0 || activatePressed)) {
            startX = screenX;
            startY = screenY;
            this.button = button;
        }
        return super.touchDown(screenX, screenY, pointer, button) || (activateKey == 0 || activatePressed);
    }

    @Override
    public boolean touchUp (int screenX, int screenY, int pointer, int button) {
        touched &= -1 ^ (1 << pointer);
        multiTouch = !MathUtils.isPowerOfTwo(touched);
        if (button == this.button) this.button = -1;
        return super.touchUp(screenX, screenY, pointer, button) || activatePressed;
    }

    protected boolean process (float deltaX, float deltaY, int button) {
    	//camera.direction.y = 0 ;
        if (button == rotateButton) {
            tmpV1.set(camera.direction).crs(camera.up).y = 0f;
            camera.rotateAround(center, camera.up, deltaY * rotateAngle);
            camera.rotateAround(center, camera.up, deltaX * -rotateAngle);
        } else if (button == translateButtonRight) {
            camera.translate(tmpV1.set(camera.direction).crs(camera.up).nor().scl(-deltaX * translateUnits));
            camera.translate(tmpV2.set(camera.up).scl(-deltaY * translateUnits));
            if (translateTarget) target.add(tmpV1).add(tmpV2);
        } else if (button == forwardButton) {
            camera.translate(tmpV1.set(camera.direction).scl(deltaY * translateUnits));
            if (forwardTarget) target.add(tmpV1);
        }
        if (autoUpdate) camera.update();
        return true;
    }

    @Override
    public boolean touchDragged (int screenX, int screenY, int pointer) {
        boolean result = super.touchDragged(screenX, screenY, pointer);
        if (result || this.button < 0) return result;
        final float deltaX = (screenX - startX) / Gdx.graphics.getWidth();
        final float deltaY = (startY - screenY) / Gdx.graphics.getHeight();
        startX = screenX;
        startY = screenY;
        return process(deltaX, deltaY, button);
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        return false;
    }

    @Override
    public boolean scrolled (int amount) {
//    	if(Gdx.input.isKeyPressed(Input.Keys.CONTROL_LEFT)||ToolController.getInstance().isZOOM()) {
//    		PerspectiveCamera camera=	((PerspectiveCamera)this.camera);
//    		float zoom=camera.fieldOfView;
//    		Vector3 tp = new Vector3();
//    		if(zoom<=1.0f ) {
//    			camera.fieldOfView=10.0f;
//    			if(amount<0) {
//    				amount=0;
//    			}
//			}
//    		if(zoom>=200.0f ) {
//    			camera.fieldOfView=200.0f;
//    			if(amount>0) {
//    				amount=0;
//    			}
//			}
//    		if(zoom>=1.0f && zoom<=200.0f )
//    		{   			
//
//				//
//				camera.unproject(tp.set(Gdx.input.getX(), Gdx.input.getY(), 0));
//				float px = tp.x;
//				float py = tp.y;
//				camera.fieldOfView += amount * 10.0f;
//				camera.update();
//
//				camera.unproject(tp.set(Gdx.input.getX(), Gdx.input.getY(), 0));
//				camera.position.add(px - tp.x, py - tp.y, 0);
//				camera.update();
//				return true;
//				//
//
//    		}
//    		return true;
//    	}else {
    		tild(amount);
        	return true;
//    	}
    	
        //return zoom(amount * scrollFactor * translateUnits);
    }

    public boolean zoom (float amount) {
        if (!alwaysScroll && activateKey != 0 && !activatePressed) return false;
        camera.translate(tmpV1.set(camera.direction).scl(amount));
        if (scrollTarget) target.add(tmpV1);
        if (autoUpdate) camera.update();
        return true;
    }

    protected boolean pinchZoom (float amount) {
        return zoom(pinchZoomFactor * amount);
    }

    @Override
    public boolean keyDown (int keycode) {
        if (keycode == activateKey) activatePressed = true;
		if (keycode == forwardKey)
            forwardPressed = true;
        else if (keycode == backwardKey)
            backwardPressed = true;
        else if (keycode == rotateRightKey)
            rotateRightPressed = true;
        else if (keycode == rotateLeftKey) rotateLeftPressed = true;
        else if(keycode == Input.Keys.C) {
        	if(Gdx.input.isKeyPressed(Keys.SHIFT_LEFT)) {
//        		Gdx.app.debug("camera controller", "saving scene shot");
    			ScreenshotFactory.saveScreen(Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), "capture");
        	}
        }
        else if (keycode == levitatetCameraKey) levitateCameraPressed = true;
        else if (keycode == dropCameraKey) dropCameraPressed = true;
        else if(keycode == translateButtonRight) {
        	rightPressed=true;
        }
        else if(keycode == translateButtonLeft) {
        	leftPressed=true;
        }
        else if(keycode == widenFov) {
        	 widenFovPressed = true;
        }
        else if(keycode == shrinkFov) {
       	 shrinkFovPressed = true;
       }
        return false;
    }

    @Override
    public boolean keyUp (int keycode) {
        if (keycode == activateKey) {
            activatePressed = false;
            button = -1;
        }
        if (keycode == forwardKey)
            forwardPressed = false;
        else if (keycode == backwardKey)
            backwardPressed = false;
        else if (keycode == rotateRightKey)
            rotateRightPressed = false;
        else if (keycode == rotateLeftKey) rotateLeftPressed = false;
        else if (keycode == levitatetCameraKey) levitateCameraPressed = false;
        else if (keycode == dropCameraKey) dropCameraPressed = false;
        else if(keycode == translateButtonRight) {
        	rightPressed=false;
        }
        else if(keycode == translateButtonLeft) {
        	leftPressed=false;
        }
        else if(keycode == widenFov) {
        	widenFovPressed = false;
        }
        else if(keycode == shrinkFov) {
        	shrinkFovPressed = false;
        }
        return false;
    }

    @Override
    public boolean keyTyped(char character) {
        return false;
    }

    public void rotateAroundTarget(Vector3 target, float xMult){
         float cameraX = camera.position.x;
         float cameraY = camera.position.y;
         float radiusSqr = (float)(Math.pow(cameraX - target.x,2) + Math.pow(cameraY - target.y,2));
         double minX = target.x - Math.sqrt(radiusSqr);
         double maxX = target.x + Math.sqrt(radiusSqr);
         float newX = cameraX * xMult;
         newX = (float) (newX%(maxX - minX));
         //Gdx.app.debug("testing radius calculation", "target pos:" + target.toString() + " camera pos" +
         //camera.position.toString() + " radius :" + radius);
        float yMultSqr = (float)Math.abs(radiusSqr - Math.pow( newX,2))/ cameraY * cameraY;
        float yMult = (float)Math.sqrt(yMultSqr);
        camera.position.set(new Vector3(newX,cameraY * yMult,camera.position.z));
    }
    public void rotateAroundTarget(ModelInstance targetModel){
            Vector3 target = new Vector3();
            targetModel.transform.getTranslation(target);
            float cameraX = camera.position.x - target.x;
            float cameraY = camera.position.y - target.y;
            float radiusSqr = (float)(Math.pow(cameraX ,2) + Math.pow(cameraY ,2));
            double minX = - Math.sqrt(radiusSqr);
            double maxX =  + Math.sqrt(radiusSqr);
            float newX = cameraX + 0.01f;
            newX  = (float) (newX % (maxX - minX)) ;
            
            float newY = calculateCirclePoint(newX,(float)Math.sqrt(radiusSqr));
            camera.position.set(newX + target.x,newY + target.y,1.5f);
            camera.lookAt(target.x,target.y,1.5f);
            camera.up.set(0,0,1);
            camera.update();
//            Gdx.app.debug("camera position", camera.position.toString());

    }
    public float calculateCirclePoint(float x, float radius){
        if( x!= x)
            x = 0.1f;
        float y = (float)Math.sqrt((radius * radius - x * x ));
        if(y!=y)
            y = 0;
        return y;
    }
    
    public void tild(float amount) {
    	Vector3 rotationVector = this.camera.direction.cpy().crs(camera.up);
    	camera.direction.rotate(rotationVector, 3 * amount);
    	camera.update();
    }
    
    
    
}
