package gdxapp.screens.room;

import java.util.ArrayList;
import java.util.HashMap;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.Input.Keys;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import dressing.controller.tools.ToolController;
import dressing.events.EventDriver;
import dressing.mathutils.Edge;
import gdxapp.Commun.AbstractScreen;
import gdxapp.Commun.ActionProcessor;
import gdxapp.Commun.GroupSelection;
import gdxapp.object3d.WorldObject;
import gdxapp.object3d.Object2D;
import gdxapp.object3d.Wall;
import gdxapp.scenes.Scene;
import gdxapp.scenes.SceneEvent;



public class ActionController implements InputProcessor{
	
	private static final String TAG = ActionController.class.getName();

    public static Wall selectedWall = null;
    private Object2D selectedActor = null;
    private ArrayList<Vector3> points = new ArrayList<Vector3>();
    public static Edge measurement = null;
    Vector2 temporaryVertice;
    ArrayList<Vector2> vertices;
    
    @Override
    public boolean keyDown(int keycode) {
    	if(Gdx.input.isKeyPressed(Input.Keys.CONTROL_LEFT)) {
//    		if(keycode == Keys.T) {
//    			Scene.game.setScreen(new TestScreen());
//    		}
    	}
    	if(Gdx.input.isKeyPressed(Input.Keys.CONTROL_LEFT)||Gdx.input.isKeyPressed(Input.Keys.CONTROL_RIGHT)) {
    		if(keycode == Input.Keys.Z) {
    			((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController().undo();
    		}
        }
        if(Gdx.input.isKeyPressed(Input.Keys.CONTROL_LEFT)||Gdx.input.isKeyPressed(Input.Keys.CONTROL_RIGHT)) {
        	if(keycode == Input.Keys.Y) {
        		((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController().redo();	
        	}
        }
     
        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
    	Gdx.app.debug(TAG, "key up");
    	try {
        	selectedActor = RoomController.getInstance().getObject((WorldObject) GroupSelection.getInstance().getFirstElement());
    	}catch(Exception e) {
    		selectedActor = null;
    	}
    	if (selectedActor!=null && (Gdx.input.isKeyPressed(Keys.SHIFT_LEFT) || Gdx.input.isKeyPressed(Keys.SHIFT_RIGHT))) {
			if (keycode == Keys.R) {
				selectedActor.adjustRotation();
				return true;
			}else if (keycode == Keys.P) {
				selectedActor.adjustPosition();
				return true;
			}
		}
    	
         if(keycode == Keys.CONTROL_LEFT && ToolController.getInstance().isDRAW_ROOM_POLYGONE()) {
        	 if(RoomController.getInstance().polygon != null) {
 //       		RoomController.getInstance().polygon.setTempVertex(null);
        	 }
        	 if(GroupSelection.getInstance().getSelection() != null)
        		 GroupSelection.getInstance().clearSelection();
        		return true;
         }

         if(keycode == Keys.F1) {
			ActionProcessor.getProcessor().setShowTop(!ActionProcessor.getProcessor().isShowTop());
			return true;
         }
         if(keycode == Keys.F2) {
        	 ActionProcessor.getProcessor().setShowBottom(!ActionProcessor.getProcessor().isShowBottom());
        	 return true;
         }
         if(keycode == Keys.F3) {
        	 ActionProcessor.getProcessor().setShowColonne(!ActionProcessor.getProcessor().isShowColonne());
        	 return true;
         }
         if(keycode == Keys.F12) {
        	 ActionProcessor.getProcessor().setShowInnerQuotations(!ActionProcessor.isShowInnerQuotations());
        	 return true;
         }
         if(keycode == Keys.F11) {
        	 ActionProcessor.getProcessor().setShowOuterQuotations(!ActionProcessor.isShowOuterQuotations());
        	 return true;
         }
         if(keycode == Keys.D) {
        	 RoomController.getInstance().setDebugEdges(false);
         }
         if(keycode==Keys.F7) {
        	 OrthographicCamera camera=	((OrthographicCamera)RoomController.getInstance().stage.getCamera());
     		camera.zoom=1;
     		camera.setToOrtho(false);
         }
   
    	return false;
    }

    @Override
    public boolean keyTyped(char character) {
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
    		
    	if(button == Input.Buttons.RIGHT) {
			HashMap<String, Object> eventData = new HashMap<>();
			eventData.put("location", new Vector3(screenX ,RoomController.getInstance().getStage().getHeight() - screenY, 0));
			eventData.put("source", null);
			dressing.events.Event sceneEvent = new dressing.events.Event(SceneEvent.OBJECT_RIGHT_CLICK.name(), eventData);
			EventDriver.getDriver().deliverEvent(sceneEvent);
			return true;
		}else {
			dressing.events.Event sceneEvent = new dressing.events.Event(SceneEvent.VOID_CLICK.name(), "");
			EventDriver.getDriver().deliverEvent(sceneEvent);
		}
        return false;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {

        return false;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
//    	Vector2 stageCoords = RoomController.getInstance().stage.screenToStageCoordinates(new Vector2(screenX, screenY));
//    	ZoneSelector.getSelector().setTemporaryZoneEnd(stageCoords);
//    	ZoneSelector.getSelector().update();
        return false;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
    
        return false;
    }

    @Override
    public boolean scrolled(int amount) {
    	return false;
    }
}
