package gdxapp.screens.ObjectEditor;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;

import dressing.events.Event;
import dressing.events.EventDriver;
import dressing.events.EventHandler;
import dressing.ui.parts.GdxPart;
import gdx.app.camera.PerspectiveCameraController;
import gdxapp.scenes.SceneEvent;

public class TargetCamera extends PerspectiveCameraController implements InputProcessor, EventHandler{
	
	private final Vector2 tmp = new Vector2();
	private final Vector2 lastClick = new Vector2();
	private OrthographicCamera orthoCam;
	private Camera currentCamera;
	
	public enum SIDE{
		FACE,
		BACK,
		TOP,
		BOTTOM,
		LEFT,
		RIGHT
	}
	
	boolean dragEnabled;
	
	public TargetCamera(Camera camera, Vector3 target) {
		this.camera = camera;
		this.orbitCenter = target.cpy();
		orthoCam = new OrthographicCamera(10, 10);
		orthoCam.near = 2;
		orthoCam.far = 10;
		orthoCam.up.set(0,1,0);
		orthoCam.update();
		currentCamera = camera;
		subscribe(SceneEvent.SIDE_PROJECTION.name());
	}
	
	
	private void setToOrtho(Event event) {
		if(event.getData() instanceof SIDE) {
			SIDE side =  (SIDE) event.getData();
			Vector3 position = orbitCenter.cpy();
			switch (side) {
			case FACE:
				position.add(0, 0, 10);
				orthoCam.up.set(0,1,0);
				break;
			case BACK:
				position.add(0, 0, -10);
				orthoCam.up.set(0,1,0);
				break;
			case LEFT:
				position.add(-10, 0, 0);
				orthoCam.up.set(0,1,0);
				break;
			case RIGHT:
				position.add(10, 0, 0);
				orthoCam.up.set(0,1,0);
				break;
			case TOP:
				position.add(0, 10, 0);
				orthoCam.up.set(0,0,1);
				break;
			default:
				position.add(0, -10, 0);
				orthoCam.up.set(0,0,1);
				break;
			}
			orthoCam.position.set(position);
			orthoCam.lookAt(orbitCenter);
			orthoCam.update();
			setCurrentCamera(orthoCam);
		}
	}
	

	@Override
	public boolean keyDown(int keycode) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean keyUp(int keycode) {
		return false;
	}

	@Override
	public boolean keyTyped(char character) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean touchDown(int screenX, int screenY, int pointer, int button) {
		EventDriver.getDriver().deliverEvent(new Event(SceneEvent.CLEAR_KEYBOARD_FOCUS.name(), null));
		setCurrentCamera(camera);
		if(button == Input.Buttons.RIGHT) {
			lastClick.set(screenX, Gdx.graphics.getHeight() - screenY);
			dragEnabled = true;
			return true;
		}
		dragEnabled = false;
		return false;
	}

	@Override
	public boolean touchUp(int screenX, int screenY, int pointer, int button) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean touchDragged(int screenX, int screenY, int pointer) {
		if(dragEnabled) {
			Vector2 mvt = new Vector2(screenX, Gdx.graphics.getHeight() - screenY).sub(lastClick)
					.scl(10.0f/Gdx.graphics.getWidth(), 5.0f/Gdx.graphics.getHeight());
			orbit(mvt.x, mvt.y);
			return true;
		}
		return false;
		
	}

	@Override
	public boolean mouseMoved(int screenX, int screenY) {
		tmp.set(screenX, Gdx.graphics.getHeight() - screenY);
		return false;
	}

	@Override
	public boolean scrolled(int amount) {
		advance(-amount);
		return true;
	}
	
	@Override
	public void handleKeyDown() {
		
	}


	@Override
	public void handle(Event event) {
		SceneEvent sceneEvent = SceneEvent.valueOf(event.getTopic());
		switch (sceneEvent){
		case SIDE_PROJECTION:
			setToOrtho(event);
			break;
		}
	}


	public Camera getCurrentCamera() {
		return currentCamera;
	}


	public void setCurrentCamera(Camera camera) {
		boolean changed = this.currentCamera == camera;
		this.currentCamera = camera;
		if(changed) {
			EventDriver.getDriver().deliverEvent(new Event(SceneEvent.TARGET_CAMERA_CHANGED.name(), this.currentCamera));
		}
	}
	
	



}
