package gdxapp.object3d;

import java.util.HashMap;

import gdxapp.animation.ICallable;


public abstract class Animation {

	private HashMap<String, Object> context;
	private ICallable postAnimationCallable;
	private boolean playing;
	
	
	public Animation(HashMap<String, Object> context, Runnable postAction) {
		super();
		this.context = context;
	}

	public abstract Animation act(float delta);

	public HashMap<String, Object> getContext() {
		return context;
	}

	public void setContext(HashMap<String, Object> context) {
		this.context = context;
	}

	public ICallable getPostAnimationCallable() {
		return postAnimationCallable;
	}

	public void setPostAnimationCallable(ICallable postAnimationCallable) {
		this.postAnimationCallable = postAnimationCallable;
	}

	public boolean isPlaying() {
		return playing;
	}

	public void setPlaying(boolean playing) {
		this.playing = playing;
	}
	
	
}
