package dressing.model.persistence.dpos;

import gdxapp.object3d.ModeledObject;

public class ModeledObjectDPO extends Object3D implements DPO<ModeledObject> {


	
	@Override
	public DPO<ModeledObject> from(ModeledObject entity) {
		super.set(entity);
		return this;
	}

	@Override
	public ModeledObject get() {
		ModeledObject modeledObject = new ModeledObject();
		modeledObject.setRealWorldDimension(dimension);
		modeledObject.setRealWorldPosition(position);
		modeledObject.setRotation(rotation);
		modeledObject.setUuid(uuid);
		modeledObject.setProperties(properties);
		modeledObject.setSceneId(sceneID);
		modeledObject.setStaticobject(staticObject);
		boolean constraint = false;
		var constrt =  properties.getOrDefault("constraint", false);
		if(constrt instanceof String) {
			constraint = Boolean.parseBoolean((String) constrt);
		}else {
			constraint = (boolean) constrt;
		}
		modeledObject.setConstraint(constraint);
		return modeledObject;
	}	
}
