package dressing.model.debitage;

import java.util.ArrayList;
import java.util.List;

import org.frs.debitage.engine.core.evalutor.Equation;
import org.frs.debitage.engine.core.evalutor.GeometricEngineException;

import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import param.MechanicPrivateParam;
import param.MechanicPublicParam;

public class GenericDebitage extends Debitage{

	List<MechanicPrivateParam> privateparams ;
	List<MechanicPublicParam> publicparams;
	Object  emf ;
	
	public GenericDebitage() {
		super();
		// TODO Auto-generated constructor stub
	}
	public GenericDebitage(List<MechanicPrivateParam> privateparams, List<MechanicPublicParam> publicparams,Object emf) {
		// TODO Auto-generated constructor stub
		this.privateparams = privateparams;
		this.publicparams = publicparams;
		this.emf = emf;
	}
	
	public void createupdateDebitage() throws DesignException
	{
		if(  child==null)
			throw new DesignException("Debitage child null");
		GenericDebitageFormula formulas = new GenericDebitageFormula(privateparams,publicparams,this.emf,exportlist);
		formulas.filldebitagesequations(parent, child, equations);
	}
	public static void createupdateDebitage(DesignObject3D parent, DesignObject3D child, List<MechanicPrivateParam> privateparams, List<MechanicPublicParam> publicparams, Object emf, ArrayList<Equation> equations) throws DesignException
	{
		if(  child==null)
			throw new DesignException("Debitage child null");
		GenericDebitageFormula.filldebitagesequations(parent, child,emf,privateparams,publicparams, equations);
	}
	@Override
	public void evaluate() throws GeometricEngineException
	{
		GenericDebitageFormula.EVALUATE(equations);
	}
}
