package dressing.cam.model;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.frs.debitage.cam.graphunit.PointDXF;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;

import dressing.mathutils.CoordinateSystem;
import dressing.model.Cavity;
import dressing.model.DesignObject3D;
import dressing.model.Kitchen;
import dressing.model.Piece2D;
import dressing.model.Project3D;
import dressing.cam.model.Rainure;
import dressing.model.Space3DFree;
import dressing.model.SuperCadProject;
import dressing.cam.model.Trou;
import dressing.io.IOUtilities;
import dressing.model.types.Orientation;
import param.MechanicPublicParam;
import param.PieceType;

public class GcodeHolefilemanager {
	boolean codeseulfaceExist;
	boolean codedeuxfaceExist;
	public boolean isCodeExist() {
		return codeseulfaceExist;
	}

	public void setCodeseulfaceExist(boolean codeExist) {
		this.codeseulfaceExist = codeExist;
	}

	public boolean isCodedeuxfaceExist() {
		return codedeuxfaceExist;
	}

	public void setCodedeuxfaceExist(boolean codedeuxfaceExist) {
		this.codedeuxfaceExist = codedeuxfaceExist;
	}
	String filepath = "";

	public int creatGcodebrochefile(String filepathxml ,DesignObject3D design , int index) throws Exception {
		Map<String, String> gcodes=new HashMap<String, String>();
		boolean codeExist=false;
		boolean codedoublefaceExist=false;
		//String codemachine = "";
		Writermachinecode machineCode = new Writermachinecode();
	//	Writermachinecode machineCode2 = new Writermachinecode();
		
		ArrayList<Trou> TroudeChamp = new ArrayList<Trou>();
		ArrayList<Trou> TroudeBack = new ArrayList<Trou>();
		ArrayList<Trou> Troudeface = new ArrayList<Trou>();

		ArrayList<Trou> TroudeChamp3 = new ArrayList<Trou>();
		ArrayList<Trou> TroudeChamp4 = new ArrayList<Trou>();
		
		ArrayList<Rainure> rainures = new ArrayList<Rainure>();
		ArrayList<Rainure> rainureHaut = new ArrayList<Rainure>();
		ArrayList<Rainure> rainurebas = new ArrayList<Rainure>();
		
		ArrayList<Cavity> cavities = new ArrayList<Cavity>();

		if (design instanceof Piece2D) {
			if (((Piece2D) design).getMaterialType() != null
					&& ((Piece2D) design).getMaterialType().getMaterial() != null
					&& ((Piece2D) design).getMaterialType().getMaterial().isProduction() && (((Piece2D) design)
							.getMechanicDesignElementDefinition().getType().equals(PieceType.PIECE2D))) {
//			boolean codeseulfaceExist = false;
//			boolean codedeuxfaceExist=false;
			Orientation orien =design.getPieceOrientation();
			rainures.clear();
			rainurebas.clear();
			rainureHaut.clear();
			TroudeBack.clear();
			String codemachine = "";
			String codemachine2 = "";
			
			StringBuilder blocktrouface =new StringBuilder();
			StringBuilder blocktrouBack =new StringBuilder();
			StringBuilder blocktrouchamp4 =new StringBuilder();
			StringBuilder blocktrouchamp3 =new StringBuilder();
			StringBuilder blockRainureB =new StringBuilder();
			StringBuilder blockRainureH =new StringBuilder();
			StringBuilder blockCavite =new StringBuilder();
			StringBuilder headRain =new StringBuilder();
			headRain.append(String.format("F=1 \r\n"));
			headRain.append(String.format("C=0 \r\n"));
			
			Piece2D p = (Piece2D) design;
			Piece2D design1 = transformHolePiece(p);
			
			
			
			List<PlanUsinage> primaryPlans = new ArrayList<PlanUsinage>();
			
			Piece2D piece = (Piece2D) design1;

			String formastlargeur = String.format("%.6f", design1.getLongeurext());

			String formastepaisseur = String.format("%.6f", design1.getProfondeurext());

			String formasthauteur = String.format("%.6f", design1.getHauteurext());
			
			StringBuilder header = machineCode.writeheadercode(formastlargeur,formasthauteur,formastepaisseur);
			
			codemachine+=header;
			codemachine2+=header;

			
			for (DesignObject3D usinage : design1.getChilds()) {
				codeExist=true;
				
				if (usinage instanceof Trou) {
					
					Trou trou = (Trou) usinage;

					if ((trou.getZpos() == 0 || trou.getZpos() == design1.getProfondeurext())) {
if(trou.getDirection()==Direction.YMINUS ||trou.getDirection()==Direction.YPLUS ||trou.getDirection()==Direction.XPLUS ||trou.getDirection()==Direction.XMINUS||trou.getDirection()==Direction.ZMINUS) {
	

						if (trou.getZpos() > 0  ) {
							Troudeface.add(trou);

						} else {
							TroudeBack.add(trou);
						}
}else {
	if (trou.getZpos() > 0  ) {
		TroudeBack.add(trou);

	} else {
		Troudeface.add(trou);
	}
}
					} else {
						if (trou.getXpos() == 0) {
							TroudeChamp4.add(trou);
						} else {
							TroudeChamp3.add(trou);
						}

					}

				}
				if (usinage instanceof Rainure) {

					Rainure rainure = (Rainure) usinage;
					rainures.add(rainure);

				}
				if (usinage instanceof Cavity) {

					
					Cavity cavity = (Cavity) usinage;
					cavities.add(cavity);
					
					
				}
			}
			if (rainures.size() > 0) {

				

				for (Rainure rn : rainures) {

					if (rn.getZpos() == rn.getProfondeurext() ||rn.getZpos() ==design.getZSize()- rn.getProfondeurext()||rn.getZpos() ==rn.getHauteurext() ||rn.getZpos() ==rn.getLongeurext()) {
						rainureHaut.add(rn);

					} else {
						rainurebas.add(rn);
					}
				}}
			
			
			discussionfaces(rainurebas,rainureHaut,Troudeface,TroudeBack,TroudeChamp4,TroudeChamp3,orien,codeseulfaceExist,codedeuxfaceExist);
			
			
				
				if (Troudeface.size() > 0) {
				//	scoreUsinage+=1;
					for (Trou trou : Troudeface) {
						
						StringBuilder Trouface =new StringBuilder();
						
						float a = (float) trou.getXpos();
						String formattedStringa = String.format("%.6f", a);

						float b = (float) trou.getYpos();
						String formattedStringb = String.format("%.6f", b);

						float c = (float) trou.getDepth();
						String formattedStringc = String.format("%.6f", c);

						float d = (float) trou.getDiameter();
						String formattedStringd = String.format("%.6f", d);
						
						Trouface = machineCode.writTrouFacercode(formattedStringa, formattedStringb, formattedStringc,formattedStringd);
					if(codeseulfaceExist)	{
						codemachine+=Trouface;
					}
					blocktrouface.append(Trouface);
					}
				}
				

				if (TroudeChamp4.size() > 0) {
					for (Trou trou : TroudeChamp4) {
						int face = 4;
						float a = (float) trou.getXpos();
						String formattedStringa = String.format("%.6f", a);

						float b = (float) trou.getYpos();
						String formattedStringb = String.format("%.6f", b);

						float c = (float) trou.getDepth();
						String formattedStringc = String.format("%.6f", c);

						float d = (float) trou.getDiameter();
						String formattedStringd = String.format("%.6f", d);

						float z = (float) trou.getZpos();
						String formattedStringz = String.format("%.6f", z);
						
						 blocktrouchamp4= machineCode.writTrouchap4code(formattedStringz, formattedStringb, formattedStringc,formattedStringd,formattedStringa);
						
						codemachine+=blocktrouchamp4;
						
						if(codeseulfaceExist) {
							codemachine+=blocktrouchamp4;
						}
					}
				}
				if (TroudeChamp3.size() > 0) {
					for (Trou trou : TroudeChamp3) {
						
						
						float a = (float) trou.getXpos();
						String formattedStringa = String.format("%.6f", a);

						float b = (float) trou.getYpos();
						String formattedStringb = String.format("%.6f", b);

						float c = (float) trou.getDepth();
						String formattedStringc = String.format("%.6f", c);

						float d = (float) trou.getDiameter();
						String formattedStringd = String.format("%.6f", d);

						float z = (float) trou.getZpos();
						String formattedStringz = String.format("%.6f", z);
						
						 blocktrouchamp3= machineCode.writTrouchap3code(formattedStringa, formattedStringb, formattedStringc,formattedStringd,formattedStringz);
						codeExist=true;
						codemachine+=blocktrouchamp3;
							if(codeseulfaceExist) {
								codemachine+=blocktrouchamp3;
							}
					}
				}
				if (TroudeBack.size() > 0) {
				//	scoreUsinage+=1;
					for (Trou trou : TroudeBack) {
						
						StringBuilder Trouface =new StringBuilder();
					
						float a = (float) trou.getXpos();
						String formattedStringa = String.format("%.6f", a);

						float b = (float) trou.getYpos();
						String formattedStringb = String.format("%.6f", b);

						float c = (float) trou.getDepth();
						String formattedStringc = String.format("%.6f", c);

						float d = (float) trou.getDiameter();
						String formattedStringd = String.format("%.6f", d);
						
						
						Trouface=machineCode.writTrouBackrcode(formattedStringa, formattedStringb, formattedStringc,formattedStringd);
						if(codeseulfaceExist) {
						codemachine+=Trouface;
						}
					blocktrouBack.append(Trouface);
					}
				}

				
					if (rainureHaut.size() > 0) {
						//scoreRunire+=1;
						if (codeseulfaceExist) {
							codemachine+=headRain;
						}
						for (Rainure rn : rainureHaut) {
							StringBuilder Trouface =new StringBuilder();
							float width = (float) Util.getDesignWidth(rn,piece.getPrimaryPrespective());
							float height = (float) Util.getDesignHeight(rn,piece.getPrimaryPrespective());

							// this.epaisseur=Math.min(height , width );

							PointDXF origin = DXFUtils.getOrigin(piece.getPrimaryPrespective(), piece,rn);
							PointDXF p1 = new PointDXF();
							PointDXF p2 = new PointDXF();
							PointDXF p3 = new PointDXF();
							PointDXF p4 = new PointDXF();

							// ligne 1
							if (height < width) {
								p1 = origin.getLocation();
								p2 = p1.getLocation();
								p2.x += width;

								// ligne2
								p3 = p2.getLocation();
								p3.y -= height;

								// ligne 3
								p4 = p1.getLocation();
								p4.y -= height;

							}
							if (width < height) {
								p1 = origin.getLocation();
								p2 = p1.getLocation();
								p2.x += height;

								// ligne2
								p3 = p2.getLocation();
								p3.y -= width;

								// ligne 3
								p4 = p3.getLocation();
								p4.x = p1.x;

							}
							// on represent les rainure par des demi ligne passant par l'axe de rainure
							PointDXF pstart = new PointDXF();
							PointDXF pend = new PointDXF();

							if (epsilonEquals(p1.x, p4.x, 0.1f)) {
								pstart = p1.getLocation();
								float y = Math.min(height / 2, width / 2);
								pstart.y -= y;

								pend = p3.getLocation();
								pend.y = pstart.y;

							}
							if (epsilonEquals(p1.y, p4.y, 0.1f)) {
								pstart = p1.getLocation();
								float x = Math.min(width / 2, height / 2);
								pstart.y += x;

								pend = p3.getLocation();
								pend.y -= pstart.x;

							}
							float a = (float) rn.getProfondeurext();
							String formattedStringa = String.format("%.6f", a);

							float b = (float) Math.min(rn.getLongeurext(), rn.getHauteurext());
							String formattedStringb = String.format("%.6f", b);

							if (rn.getLongeurext() > rn.getHauteurext()) {
								float c = pstart.y;
								String formattedStringc = String.format("%.6f", c);

								float d = pstart.x;
								String formattedStringd = String.format("%.6f", d);

								float f = pend.y;
								String formattedStringf = String.format("%.6f", f);

								float g=pend.x ;
								
								if(pend.x>design1.getLongeurext()) {
									g=pstart.x-a;
									formattedStringa=formattedStringb;
								}
								String formattedStringg = String.format("%.6f", g);
								Trouface= machineCode.writRainureHcode(formattedStringa, formattedStringb, formattedStringc,formattedStringd,formattedStringf,formattedStringg);
								if (codeseulfaceExist) {
									codemachine+=Trouface;
								}
									blockRainureH.append(Trouface);
								
								
							}
							else {
								
							
							String formattedStringc = String.format("%.6f", pstart.y);

							String formattedStringd = String.format("%.6f", pstart.x);

							String formattedStringf = String.format("%.6f", pend.y);

							String formattedStringg = String.format("%.6f", pend.x);
							

							Trouface= machineCode.writRainureHcode(formattedStringa, formattedStringb, formattedStringc,formattedStringd,formattedStringf,formattedStringg);
							if (codeseulfaceExist) {
								codemachine+=Trouface;
							}
							
								blockRainureH.append(Trouface);
							
							}

					}
						
			}//
					if (rainurebas.size() > 0) {
						
						StringBuilder Trouface =new StringBuilder();
						
						if (codeseulfaceExist) {
							codemachine+=headRain;
						}
						for (Rainure rn : rainurebas) {
							
							
							float width = (float) Util.getDesignWidth(rn,piece.getPrimaryPrespective());
							float height = (float) Util.getDesignHeight(rn,piece.getPrimaryPrespective());
							// this.epaisseur=Math.min(height , width );
							PointDXF origin = DXFUtils.getOrigin(piece.getPrimaryPrespective(), piece,rn);
							PointDXF p1 = new PointDXF();
							PointDXF p2 = new PointDXF();
							PointDXF p3 = new PointDXF();
							PointDXF p4 = new PointDXF();
							// ligne 1
							if (height < width) {
								p1 = origin.getLocation();
								p2 = p1.getLocation();
								p2.x += width;
								// ligne2
								p3 = p2.getLocation();
								p3.y -= height;
								// ligne 3
								p4 = p1.getLocation();
								p4.y -= height;
							}
							// piece vert cote
							if (width < height) {
							
								p1 = origin.getLocation();
								p2 = p1.getLocation();
								p2.x += height;
								// ligne2
								p3 = p2.getLocation();
								p3.y -= width;
								// ligne 3
								p4 = p3.getLocation();
								p4.x = p1.x;
							}
							// on represent les rainure par des demi ligne passant par l'axe de rainure
							PointDXF pstart = new PointDXF();
							PointDXF pend = new PointDXF();
							if (epsilonEquals(p1.x, p4.x, 0.1f)) {
								pstart = p1.getLocation();
								float y = Math.min(height / 2, width / 2);
								pstart.y -= y;
								pend = p3.getLocation();
								pend.y = pstart.y;
							}
							if (epsilonEquals(p1.y, p4.y, 0.1f)) {
								pstart = p1.getLocation();
								float x = Math.min(width / 2, height / 2);
								pstart.x += x;
								pend = p3.getLocation();
								pend.x = pstart.x;
							}
							float a = (float) rn.getProfondeurext();
							String formattedStringa = String.format("%.6f", a);
							float b = (float) Math.min(rn.getLongeurext(), rn.getHauteurext());
							String formattedStringb = String.format("%.6f", b);
							if (rn.getLongeurext() > rn.getHauteurext()) {
								float c = pstart.y;
								String formattedStringc = String.format("%.6f", c);
								float d = pstart.x;
								String formattedStringd = String.format("%.6f", d);
								float f = pend.y;
								String formattedStringf = String.format("%.6f", f);
								float g = pend.x;
								
								if(pend.x>design1.getLongeurext()) {
									g=pstart.x-a;
									formattedStringa=formattedStringb;
								}
								String formattedStringg = String.format("%.6f", g);
								Trouface= machineCode.writRainureBcode(formattedStringa, formattedStringb, formattedStringc,formattedStringd,formattedStringf,formattedStringg);
								
								if(codeseulfaceExist) {
									codemachine+=Trouface;
								}
								blockRainureB.append(Trouface);
							}
							else {
								
							
							String formattedStringc = String.format("%.6f", pstart.y);

							String formattedStringd = String.format("%.6f", pstart.x);

							String formattedStringf = String.format("%.6f", pend.y);

							String formattedStringg = String.format("%.6f", pend.x);
							
							Trouface= machineCode.writRainureBcode(formattedStringa, formattedStringb, formattedStringc,formattedStringd,formattedStringf,formattedStringg);
								
							if(codeseulfaceExist) {
								codemachine+=Trouface;
							}
							blockRainureB.append(Trouface);
								}

						}
						}
					if (codedeuxfaceExist) {
						
						if( orien == Orientation.VERTICAL) {
							if(Troudeface.size()>0) {
								codemachine+=blocktrouface;
							}
							if(rainureHaut.size()>0) {
								codemachine+=headRain;
								codemachine+=blockRainureH;
							}
							//
							if(TroudeBack.size()>0) {
								codemachine2+=blocktrouBack;
							}
							if(rainurebas.size()>0) {
								codemachine2+=headRain;
								codemachine2+=blockRainureB;
							}}
							else if(orien == Orientation.HORIZONTAL){
								
								if(TroudeBack.size()>0) {
									codemachine+=blocktrouBack;
								}
								if(rainureHaut.size()>0) {
									codemachine+=headRain;
									codemachine+=blockRainureH;
								}
								//
								if(Troudeface.size()>0) {
									codemachine2+=blocktrouface;
								}
								if(rainurebas.size()>0) {
									codemachine2+=headRain;
									codemachine2+=blockRainureB;
								}
							}
						}
					
					if (cavities.size()>0) {
						
						for (Cavity cavity :cavities  ) {
							
							StringBuilder cavitecode =new StringBuilder();
							
							float prof = (float) design1.getEpaisseur();
							

							float a = (float) cavity.getXpos();
							

							float b = (float) cavity.getYpos();
							
							
							float c = (float) cavity.getProfondeurext();
							
							
							float e = (float) cavity.getHauteurext();
						
							cavitecode=machineCode.writecavitecode(a,b,c,e,prof);
							codemachine+=(cavitecode);
							
							
							
						}
						
					}
						
				
			if(codeExist) {
			
				
				String root=filepathxml + File.separator + "P"+index+"_"+piece.getName().trim()+"_"+((int)design1.getLongeurext())+"X"+((int)design1.getHauteurext());
				File file = new File(root);
				if (!file.exists()) {
					file.mkdirs();
				}
				String monFichier =root+ File.separator+"face1".trim()+ ".xxl";

				PrintWriter writer = new PrintWriter(monFichier, "UTF-8");
				String gcodemachine =codemachine.replaceAll(",", ".");
				String gcodemachine2 =codemachine2.replaceAll(",", ".");
				gcodes.put(design.getName().trim()+"_face1", gcodemachine);
				if(codedeuxfaceExist) {
					String monFichier2 = root+ File.separator+"face2".trim()+".xxl";
					PrintWriter writer2 = new PrintWriter(monFichier2, "UTF-8");
					gcodes.put(design.getName().trim()+"_face2", gcodemachine2);
					writer2.print(gcodemachine2);
					writer2.close();
				}
				writer.print(gcodemachine);
				writer.close();
				return index+1;
			}
		}
		}
		else if ((design instanceof Project3D)) {
			File file = new File(filepathxml);
			if (!file.exists()) {
				file.mkdirs();
			}
			String root = "";
			int i = 1;
			for (DesignObject3D sapce : design.getChilds()) {
				root = filepathxml + File.separator + "P" + i + "_" + sapce.getName().trim() + "_"
						+ ((int) sapce.getLongeurext());
				creatGcodebrochefile(root, sapce,i);
				i++;

			}
		}
		else if (design instanceof Space3DFree) {
			boolean isblockTiroir = false;
			try {
				MechanicPublicParam param = design.getMechanicDesignDefinition().getPublicParam("SPACE_TYPE");
				if (param != null) {
					isblockTiroir = param.getTypedefelement().getKey().contentEquals("FACADE")
							|| param.getTypedefelement().getKey().contentEquals("BLOCK_TIROIR");
				}
			} catch (Exception e) {
				// TODO: handle exception
			}
			if (isblockTiroir) {
				String root = "";
				String namefolder = "P" + index + "_" + design.getName();
				root = filepathxml + File.separator + namefolder.trim();
				
				int i = 1;
				for (DesignObject3D sapce : design.getListPieces()) {
					i=creatGcodebrochefile(root, sapce, i);
				}
				if(i>1)
				{
					index++;
				}
			}
			else {
				for (DesignObject3D sapce : design.getChilds()) {

					index = creatGcodebrochefile(filepathxml, sapce, index);
				}
			}
		}
		return index;

	}

	private void discussionfaces(ArrayList<Rainure> rainurebas, ArrayList<Rainure> rainureHaut,
			ArrayList<Trou> troudeface, ArrayList<Trou> troudeBack, ArrayList<Trou> troudeChamp4,
			ArrayList<Trou> troudeChamp3, Orientation orien, boolean codeseulfaceExist, boolean codedeuxfaceExist) {
		if ((rainurebas.size() == 0) && (rainureHaut.size() == 0) && (troudeface.size() == 0)
				&& (troudeBack.size() == 0) && (troudeChamp3.size() == 0) && (troudeChamp4.size() == 0)) {
			setCodeseulfaceExist(false);
			setCodedeuxfaceExist(false);
		} else {
			if (orien == Orientation.VERTICAL) {

				if ((troudeface.size() > 0 && rainureHaut.size() > 0)
						|| (troudeBack.size() > 0 && rainurebas.size() > 0)
						|| (troudeBack.size() > 0 && troudeface.size() > 0)
						|| (rainurebas.size() > 0 && rainureHaut.size() > 0)) {

					setCodedeuxfaceExist(true);
					setCodeseulfaceExist(false);
				} else {
					setCodeseulfaceExist(true);
					setCodedeuxfaceExist(false);
				}

			}
		}
		if (orien == Orientation.HORIZONTAL) {
			//Verifier
			if ((troudeface.size() > 0 && rainurebas.size() > 0) 
					|| (troudeBack.size() > 0 && rainureHaut.size() > 0)
					|| (troudeBack.size() > 0 && troudeface.size() > 0)
					|| (rainurebas.size() > 0 && rainureHaut.size() > 0)) {

				setCodedeuxfaceExist(true);
				setCodeseulfaceExist(false);
			} else {
				setCodeseulfaceExist(true);
				setCodedeuxfaceExist(false);
			}
		}

	}

	private Piece2D transformHolePiece(Piece2D piece) {
		SystemCoordinateSwitcher scs = new SystemCoordinateSwitcher();
		Piece2D copypiece = piece;// .clone();

		Matrix4 mTransform = scs.initMat(copypiece);
		Vector3 dimension = CoordinateSystem.getPieceDimension(copypiece);
		copypiece.setLongeurext(dimension.x);
		copypiece.setHauteurext(dimension.y);
		copypiece.setProfondeurext(dimension.z);

		List<Trou> sortedTrous = copypiece.getTrous();

			List<Cavity> cavities=copypiece.getPiecesCavities();
    		List<Rainure> rainures=copypiece.getPiecesRainures();
		for (Trou tr : sortedTrous) {
			transformTR(tr, mTransform);
		}
		for (Rainure tr : rainures) {
			transformRainure(tr, mTransform);
		}
		for (Cavity extrusion : cavities) {
			transformExtrusion(extrusion,mTransform);
		}
		return copypiece;
	}

private void transformExtrusion(Cavity extrusion, Matrix4 mTransform) {
		
	Vector3 positionTrou = new Vector3();
	positionTrou.set((float) extrusion.getXpos(), (float) extrusion.getYpos(), (float) extrusion.getZpos());
	positionTrou=	positionTrou.mul(mTransform);
	
	extrusion.setXpos(positionTrou.x);
	extrusion.setYpos(positionTrou.y);
	extrusion.setZpos(positionTrou.z);
	}


	private void transformRainure(Rainure tr, Matrix4 mTransform) {
		Vector3 positionTrou = new Vector3();
		positionTrou.set((float) tr.getXpos(), (float) tr.getYpos(), (float) tr.getZpos());
		positionTrou=	positionTrou.mul(mTransform);
		
		tr.setXpos(positionTrou.x);
		tr.setYpos(positionTrou.y);
		tr.setZpos(positionTrou.z);
	}

	private void transformTR(Trou tr, Matrix4 machineTransform2) {
		Vector3 positionTrou = new Vector3();
		positionTrou.set((float) tr.getXpos(), (float) tr.getYpos(), (float) tr.getZpos());
		positionTrou.mul(machineTransform2);
		tr.setXpos(positionTrou.x);
		tr.setYpos(positionTrou.y);
		tr.setZpos(positionTrou.z);
		//
		
	}

	public String getFilepath() {
		return filepath;
	}

	public void setFilepath(String filepath) {
		this.filepath = filepath;
	}
	public static boolean epsilonEquals(float f1, float f2, float epsilon) {
        return (f1 + epsilon >= f2 && f1 - epsilon <= f2);
    }
	
	 public void saveKitchenDXF(String filepath,Kitchen kitchen) throws Exception {
	    	kitchen.generateElementsUsinage();
	    	if(filepath!=null && !filepath.isEmpty()&& kitchen!=null ) {
	    		File file=new File(filepath);
				if(!file.exists()) {
	    			file.mkdirs();
				}else {
					IOUtilities.deleteFolder(file);
	    			file.mkdirs();
				}
				
				String root = "";
				List<DesignObject3D> elements=kitchen.getElementsWithoutFausseFacades();
				int index =1;
				for (DesignObject3D element : elements) {
					root = filepath + File.separator +'N'+( index)+"_"+ element.getName()+"_"+element.getLongeurext() +"_"+element.getProfondeurext()+"_"+element.getHauteurext();
					creatGcodebrochefile(root,element, index);
					index++;
				}
	    	}

	    }
	 public void saveSuperCadProjectDXF(String filepath,SuperCadProject project) throws Exception {
	    	if(filepath!=null && !filepath.isEmpty()&& project!=null ) {
	    		File file=new File(filepath);
				if(!file.exists()) {
	    			file.mkdirs();
				}else {
					IOUtilities.deleteFolder(file);
	    			file.mkdirs();
				}
				String root = "";
				for (int i =0;i<project.getKitchens().size();i++) {
					Kitchen kitchen= project.getKitchens().get(i);
					root = file.getAbsolutePath() + File.separator + kitchen.getName() + " N" + i;
					saveKitchenDXF(root, kitchen);
				}
	    	}

	    }

}

