package dressing.cam.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.frs.debitage.cam.dxf.model.DXF_STATIC_VALUE;
import org.frs.debitage.cam.dxf.model.Rotationangle;
import org.frs.debitage.cam.graphunit.PCircleDXFEntity2;
import org.frs.debitage.cam.graphunit.PLineDXFEntity;
import org.frs.debitage.cam.graphunit.PointDXF;
import org.frs.debitage.cam.graphunit.PolyLineDXFEntity;

import com.badlogic.gdx.math.Vector3;

import dressing.config.ReportingPreferences;
import dressing.mathutils.CoordinateSystem;
import dressing.model.Cavity;
import dressing.model.Piece2D;
import dressing.model.types.PieceType;
import param.cam.MachineHead;
import param.Tool;

public class DXFGcodeGenerator extends GcodeGeneratorImp implements GcodeGenerator {

	public final String N = System.getProperty("line.separator");
    public static DXFGcodeGenerator instance;
	public static DXFGcodeGenerator getInstance() {
 		synchronized(DXFGcodeGenerator.class) {
 			if (instance == null) {
 				instance = new DXFGcodeGenerator();
 			}
 			return instance;
 		}
	}
	@Override
	public String generateHoleBlock(Tool tool, MachineHead head, Vector3 start, Vector3 end, int depth) {
		String operatioLine = "O" + head.getCode() + " T" + tool.getCode() + N;
        String block = "";
        block += operatioLine;
        block += "F"+tool.getFeed() + N;
        String startLine = "G0 X" + (int)start.x+ " Y" + (int)start.y+ " Z" + (int)start.z + N;
        block += startLine;
        String endLine = "";
        endLine = "G1 X" + (int)end.x+ " Y" + (int)end.y + " Z" +(int)end.z + N;
        block += endLine;
        return  block;
	}
	@Override
	public String generateHeader(Vector3 point) {
			Vector3 origin = new Vector3(0,0,0);

	        //ligne 1 
			Vector3 p1 = origin.cpy();
			Vector3 p2 = p1.cpy();
	        p2.x += point.x;

	        //ligne2
	        Vector3 p3 = p2.cpy();
	        p3.y += point.y;

	        //ligne 3 
	        Vector3 p4 = p1.cpy();
	        p4.y += point.y;
	      
		return  generatePolyline(p1,p2,p3,p4);
	}
	public String generaterRainureBlock(Tool tool, MachineHead head, Vector3 start, Vector3 end, int depth) {
		String operatioLine = "O" + head.getCode() + " T" + tool.getCode() + N;
        String block = "";
        block += operatioLine;
        block += "F"+tool.getFeed() + N;
        String startLine = "G0 X" + (int)start.x+ " Y" + (int)start.y + " Z" + (int)start.z + N;
        block += startLine;
        String endLine = "";
        endLine = "G1 X" + (int)end.x+ " Y" + (int)end.y + " Z" +(int)end.z + N;
        block += endLine;
       //System.err.println(block);
        return  block;
	}
	


	public String getDXFLineEntetity(Trou trou,Vector3 start,Vector3 end) {
		// TODO Auto-generated method stub
		String s="";
		PointDXF centre  = new PointDXF(start.x, start.y);
		
		
        PCircleDXFEntity2 circle = new PCircleDXFEntity2(centre, trou.getDiameter()/2);
        s += circle.getDXFLineEntetity();
        return s;
	}
	public String getDXFLineEntetityLateral(Trou trou,Vector3 start,Vector3 endPoint) {
		String s = "";
		if (ReportingPreferences.getInstance().getProperty("DXF.TrouLateraleRectangle", false)) {

			PointDXF centre = new PointDXF(start.x, start.y);
			PointDXF end = new PointDXF(endPoint.x, endPoint.y);
			float width = 0;
			float height = 0;

			float x0 = 0;
			float y0 = 0;
			if (centre.x == end.x) {
				width = (float) trou.getDiameter();
				height = (float) trou.getDepth();
				x0 = centre.x - width / 2;
				y0 = Math.min(centre.y, end.y);
			} else {
				width = (float) trou.getDepth();
				height = (float) trou.getDiameter();

				x0 = Math.min(centre.x, end.x);
				y0 = centre.y - height / 2;
			}
			PointDXF p1 = new PointDXF(x0, y0);
			PointDXF p2 = new PointDXF(x0 + width, y0);
			PointDXF p3 = new PointDXF(x0 + width, y0 + height);
			PointDXF p4 = new PointDXF(x0, y0 + height);
			PolyLineDXFEntity poly = new PolyLineDXFEntity(true);
			poly.addVertices(p1);
			poly.addVertices(p2);
			poly.addVertices(p3);
			poly.addVertices(p4);
			poly.addVertices(p1);
			s += poly.getDXFEntity(Rotationangle.angleRotation0);

		} else {
			PolyLineDXFEntity poly = new PolyLineDXFEntity(true);
			PointDXF centre = new PointDXF(start.x, start.y);
			PointDXF end = new PointDXF(endPoint.x, endPoint.y);
			float width = 0;
			float height = 0;

			float x0 = 0;
			float y0 = 0;
			if (centre.x == end.x) {
				width = (float) trou.getDiameter();
				height = (float) trou.getDepth();
				x0 = centre.x;
				y0 = Math.min(centre.y, end.y);
				PointDXF p1 = new PointDXF(x0, y0);
				PointDXF p2 = new PointDXF(x0, y0 + height);

				poly.addVertices(p1);
				poly.addVertices(p2);
				poly.addVertices(p1);
			} else {
				width = (float) trou.getDepth();
				height = (float) trou.getDiameter();

				x0 = Math.min(centre.x, end.x);
				y0 = centre.y;
				PointDXF p1 = new PointDXF(x0, y0);
				PointDXF p2 = new PointDXF(x0 + width, y0);

				poly.addVertices(p1);
				poly.addVertices(p2);
				poly.addVertices(p1);
			}

			s += poly.getDXFEntity(Rotationangle.angleRotation0);

		}
		 return s;
	}
	
	public String generatePolyline(Vector3... points) {

		PolyLineDXFEntity poly = new PolyLineDXFEntity(true);
		for (Vector3 point : points) {
			poly.addVertices(new PointDXF(point.x, point.y));
		}
		poly.addVertices(poly.getVertices().get(0));

		String block = poly.getDXFEntity(Rotationangle.angleRotation0);
		// System.err.println(block);
		return block;
	}
	
	public String getRainureDXFLineEntetity(Vector3 start,Vector3 end ,float width,float depth) {
    	
 
    	String s="";
        PLineDXFEntity line1 = null;
        PLineDXFEntity line2 = null;
        PLineDXFEntity line3 = null;
        PLineDXFEntity line4 = null;
        PointDXF p1=null;
        PointDXF p2=null;
        PointDXF p3=null;
        PointDXF p4=null;
        if (ReportingPreferences.getInstance().getProperty("DXF.VueRainureLine", true)) {
        	p1 = new PointDXF(start.x, start.y);
			p2 = new PointDXF(end.x, end.y);
			line1 = new PLineDXFEntity(p1, p2);
			s += line1.generateDXFLine();
        }else {
			if (start.x == end.x) {
				p1 = new PointDXF(start.x - width / 2, start.y);
				p2 = new PointDXF(start.x + width / 2, start.y);
				p3 = new PointDXF(end.x + width / 2, end.y);
				p4 = new PointDXF(end.x - width / 2, end.y);
			} else if (start.y == end.y) {
				p1 = new PointDXF(start.x, start.y - width / 2);
				p2 = new PointDXF(end.x, end.y - width / 2);
				p3 = new PointDXF(end.x, end.y + width / 2);
				p4 = new PointDXF(start.x, start.y + width / 2);
			}

			if (DXF_STATIC_VALUE.USE_POLYLINE == false) {
				line1 = new PLineDXFEntity(p1, p2);
				line2 = new PLineDXFEntity(p2, p3);
				line3 = new PLineDXFEntity(p1, p4);
				line4 = new PLineDXFEntity(p4, p3);

				// Create String seintity
				s += line1.getDXFLineEntetity();
				s += line2.getDXFLineEntetity();
				s += line3.getDXFLineEntetity();
				s += line4.getDXFLineEntetity();
			} else {
				PolyLineDXFEntity poly = new PolyLineDXFEntity(true);
				poly.addVertices(p1);
				poly.addVertices(p2);
				poly.addVertices(p3);
				poly.addVertices(p4);
				poly.addVertices(p1);
				s += poly.getDXFEntity(Rotationangle.angleRotation0);
			}
        }
      
        return s;
	}
	
	

	public Map<String, String> generateCode(Piece2D piece) {
		Map<String, String> gcodes=new HashMap<String, String>();

		SystemCoordinateSwitcher scs = new SystemCoordinateSwitcher();
		scs.init(piece);
		List<Trou> sortedTrous =piece.getTrous();
		List<Cavity> cavities=piece.getPiecesCavities();
		List<Rainure> rainures=piece.getPiecesRainures();
    	boolean isLateralVisible=ReportingPreferences.getInstance().getProperty("DXF.showLateral",true);

		Vector3 dimension = CoordinateSystem.getPieceDimension(piece);
		List<RainureGcode> faceRainures=new ArrayList<RainureGcode>();
		List<RainureGcode> backRainures=new ArrayList<RainureGcode>();
		float length = dimension.x;
		float depth = dimension.z;
		float width = dimension.y;
		Vector3 vector;
		switch (piece.getPieceOrientation()) {
		case VERTICAL:
			vector = Vector3.X;
			break;
		case HORIZONTAL:
			vector = Vector3.Y;
		break;
		case PROUFOUND:
			vector = Vector3.Z;
			break;
		default:
			vector = Vector3.Z;
			break;
		}
		
		String header = generateHeader(new Vector3(length,width,depth));
		String gcode = "";
		String gcodeBack = "";
		String lateralTrou = "";
		String lateralTrouBack = "";
		String extrusion = "";
		String extrusionback = "";
		String gcodeRainure = "";
		String gcodeBackRainure = "";
		for (Trou tr : sortedTrous) {

			Vector3 start = scs.toMachineCoordinate(tr.getStart());
			Vector3 end = scs.toMachineCoordinate(tr.getEnd());

			double sense = start.z;
			start.z = depth;
			if (sense == 0) {
				end.z *= -1;
				end.z += depth;
				start.x = length - start.x;
				end.x = length - end.x;
			}

			double cheek = getCheek(tr, piece.getPieceOrientation(), piece);
			if (cheek == 0) {
				gcode += getDXFLineEntetity(tr, start, end);
			}
			if (cheek == 1) {
				gcodeBack += getDXFLineEntetity(tr, start, end);
			}
			if (cheek == 100) {
				lateralTrou += getDXFLineEntetityLateral(tr, start, end);
				start.x = length - start.x;
				end.x = length - end.x;
				lateralTrouBack += getDXFLineEntetityLateral(tr, start, end);
			}
		}
		for (Rainure rainure : rainures) {

			Vector3 dimRainure = new Vector3((float) rainure.getLongeurext(), (float) rainure.getHauteurext(),
					(float) rainure.getProfondeurext());
			float depthR = vector.dot(dimRainure);
			double distance = Math.max(Math.max(rainure.getLongeurext(), rainure.getHauteurext()),
					rainure.getProfondeurext());
			float rainureWidth = (float) ((dimRainure.x + dimRainure.y + dimRainure.z) - distance - depthR);
			Vector3 start = new Vector3((float) rainure.getXpos(), (float) rainure.getYpos(),
					(float) rainure.getZpos());
			Vector3 end = new Vector3((float) rainure.getXpos(), (float) rainure.getYpos(), (float) rainure.getZpos());
			if (distance == rainure.getLongeurext()) {
				start.z += rainure.getProfondeurext() / 2;
				end.x += distance;
				end.y = start.y;
				end.z = start.z;
			} else if (distance == rainure.getHauteurext()) {
				if (start.x == 0) {
					start.x += rainure.getLongeurext();
				}
				// test if the piece is profondeur and rainure move on the axe Y
				// we move the axe X to be in the middle of the width of the rainure
				// and otherwise meaning the piece is vertical we move the axe X to be in the
				// middle of the width of the rainure
				if (vector == Vector3.Z) {
					start.x += rainure.getLongeurext() / 2;
					end.y += distance;
					end.x = start.x;
					end.z = start.z;
				} else {
					start.z += rainure.getProfondeurext() / 2;
					end.y += distance;
					end.x = start.x;
					end.z = start.z;
				}

			} else {
				start.x += rainure.getLongeurext() / 2;
				end.z += distance;
				end.x = start.x;
				end.y = start.y;
			}
			Vector3 startX = scs.toMachineCoordinate(start);
			Vector3 endX = scs.toMachineCoordinate(end);
			if (startX.x > endX.x) {
				Vector3 bucket = startX;
				startX = endX;
				endX = bucket;
			}
			startX.z = depth;
			endX.z = depth - depthR;
			int cheek = getCheek(rainure, piece.getPieceOrientation(), piece);
			if (cheek == 0) {
				if (vector == Vector3.Z || vector == Vector3.X) {
					startX.x = length - startX.x;
					endX.x = length - endX.x;
					if (startX.x > endX.x) {
						Vector3 bucket = startX;
						startX = endX;
						endX = bucket;
					}
					startX.z = depth;
					endX.z = depth - depthR;
				}
				faceRainures.add(new RainureGcode(startX, endX,rainureWidth,depthR));
			}
			if (cheek == 1) {
				if (vector == Vector3.Y) {
					startX.x = length - startX.x;
					endX.x = length - endX.x;
					if (startX.x > endX.x) {
						Vector3 bucket = startX;
						startX = endX;
						endX = bucket;
					}
					startX.z = depth;
					endX.z = depth - depthR;
				}
				backRainures.add(new RainureGcode(startX, endX,rainureWidth,depthR));
			}

		}
		Util.sortRainure(faceRainures);
		Util.sortRainure(backRainures);
		boolean AssembleRainure = ReportingPreferences.getInstance().getProperty("DXF.AssembleRainure", true);
		if(AssembleRainure) {
			faceRainures =Util.assembleRainures(faceRainures,true,true);
			backRainures =Util.assembleRainures(backRainures,true,true);
		}
		for(RainureGcode rn:faceRainures) {
			gcodeRainure += getRainureDXFLineEntetity(rn.getStart(), rn.getEnd(),(float) rn.getWidth(),(float)rn.getDepth());
		}
		for(RainureGcode rn:backRainures) {
			gcodeBackRainure += getRainureDXFLineEntetity(rn.getStart(), rn.getEnd(),(float) rn.getWidth(),(float)rn.getDepth());
		}
		
		for (Cavity usin : cavities) {
			ArrayList<Vector3> verticesToConsider = getCavityVertices(scs, usin);
			String gcodeExtrusion1 = "";
			String gcodeExtrusion2 = "";
			Vector3[] points = sortVertices(verticesToConsider, dimension);
			gcodeExtrusion1 += generatePolyline(points[0], points[1], points[2], points[3]);
			for (Vector3 v : verticesToConsider) {
				v.x = length - v.x;

			}
			points = sortVertices(verticesToConsider, dimension);
			gcodeExtrusion2 += generatePolyline(points[0], points[1], points[2], points[3]);
			if (vector == Vector3.Z || vector == Vector3.X) {
				extrusionback += gcodeExtrusion1;
				extrusion += gcodeExtrusion2;
			} else {
				extrusionback += gcodeExtrusion2;
				extrusion += gcodeExtrusion1;
			}

		}
		boolean lateralAdded = false;
		if (!gcode.isEmpty()||!gcodeRainure.isEmpty()) {
			String code=header;
			code+=gcodeRainure;
			if(!(piece.getPiecetype().equals(PieceType.BAS_CUISSON)&&gcode.isEmpty())) {
				code+=extrusion;
				if(isLateralVisible)
				{
					code+=lateralTrou;
					lateralAdded = true;
				}
			}
			
			code+=gcode;
			gcodes.put("face", code);	
		}
		if (!gcodeBack.isEmpty()|| !gcodeBackRainure.isEmpty()) {
			String code=header;
			code+=gcodeBackRainure;
			
			if(!lateralAdded && isLateralVisible) {		
				code += extrusionback;
				code += lateralTrouBack;
				lateralAdded = true;
			}
			code+=gcodeBack;
			gcodes.put("back", code);
		}
		if(isLateralVisible &&!lateralAdded && (!extrusion.isEmpty()|| !lateralTrou.isEmpty())){
			gcode=header;
			gcode+=gcodeRainure;
			gcode += extrusion;
			gcode += lateralTrou;
			gcodes.put("face", gcode);	
			lateralAdded = true;

		}
		return gcodes;
	}

	/**
	 * @param scs
	 * @param usin
	 * @return
	 */
	private ArrayList<Vector3> getCavityVertices(SystemCoordinateSwitcher scs, Usinage usin) {
		Cavity cavity =(Cavity) usin;
		Vector3 vertice000 = new Vector3((float)cavity.getXpos(), (float)cavity.getYpos(),(float) cavity.getZpos());
		Vector3 vertice001 = new Vector3((float)cavity.getXpos(),(float) cavity.getYpos(),(float)
				cavity.getZpos() + (float)cavity.getProfondeurext());
		Vector3 vertice010 = new Vector3((float)cavity.getXpos(),(float) cavity.getYpos() + (float)cavity.getHauteurext(),
				(float)cavity.getZpos());
		Vector3 vertice011 = new Vector3((float)cavity.getXpos(), (float)cavity.getYpos() +(float) cavity.getHauteurext(),
				(float)cavity.getZpos() + (float)cavity.getProfondeurext());
		Vector3 vertice100 = new Vector3((float)cavity.getXpos() + (float)cavity.getLongeurext(), (float)cavity.getYpos(),
				(float)cavity.getZpos());
		Vector3 vertice101 = new Vector3((float)cavity.getXpos() + (float)cavity.getLongeurext(), (float)cavity.getYpos(),
				(float)cavity.getZpos() + (float)cavity.getProfondeurext());
		Vector3 vertice110 = new Vector3((float)cavity.getXpos() +(float) cavity.getLongeurext(),
				(float)cavity.getYpos() +(float) cavity.getHauteurext(),(float) cavity.getZpos());
		Vector3 vertice111 = new Vector3((float)cavity.getXpos() + (float)cavity.getLongeurext(),
				(float)cavity.getYpos() +(float) cavity.getHauteurext(),(float) cavity.getZpos() + (float)cavity.getProfondeurext());
		vertice000 = scs.toMachineCoordinate(vertice000);
		vertice001 = scs.toMachineCoordinate(vertice001);
		vertice010 = scs.toMachineCoordinate(vertice010);
		vertice011 = scs.toMachineCoordinate(vertice011);
		vertice100 = scs.toMachineCoordinate(vertice100);
		vertice101 = scs.toMachineCoordinate(vertice101);
		vertice110 = scs.toMachineCoordinate(vertice110);
		vertice111 = scs.toMachineCoordinate(vertice111);
		ArrayList<Vector3> vertices = new ArrayList<Vector3>();
		vertices.add(vertice111);
		vertices.add(vertice110);
		vertices.add(vertice101);
		vertices.add(vertice100);
		vertices.add(vertice011);
		vertices.add(vertice010);
		vertices.add(vertice001);
		vertices.add(vertice000);
		int j = 0;
		ArrayList<Vector3> verticesToConsider = new ArrayList<Vector3>();
		while (verticesToConsider.size() < 4) {
			for (int i = j; i < vertices.size(); i++) {
				if (vertices.get(i) == vertices.get(j)
						|| verticesToConsider.contains(vertices.get(i)))
					continue;
				if (vertices.get(i).x == vertices.get(j).x && vertices.get(i).y == vertices.get(j).y)
					verticesToConsider.add(vertices.get(i));
			}
			j++;
		}
		return verticesToConsider;
	}
	@Override
	public String generaterRectangulaireFreizeBlock(Tool tool, MachineHead head, Vector3 point1, Vector3 point2,
			Vector3 point3, Vector3 point4, Vector3 piece, int depth, float cutterRadius) {
		// TODO Auto-generated method stub
		return null;
	}

}
