/*
 * Decompiled with CFR 0.152.
 */
package com.sandmonkey.viewer3d.api.graphics;

import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.math.Vector3;
import dressing.config.WorkspaceConfiguration;
import dressing.model.DesignObject3D;
import dressing.model.MechanicDesignCreator;
import gdxapp.assets.ModelExporter;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.WorldObjectFactory;
import gdxapp.shaders.PbrMaterial;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.List;
import param.MechanicDesign;

public class PreviewController {
    private List<MechanicDesign> designs;
    private HashMap<String, api.graphics.Model> previews = new HashMap();
    private static PreviewController controller;
    private Thread loader;

    private void init() {
        this.loader = new Thread(() -> this.load());
        this.loader.start();
    }

    public void load() {
        File[] folders;
        File previewFolder = new File(WorkspaceConfiguration.DOT_OBJ_FOLDER);
        File[] fileArray = folders = previewFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            File folder = fileArray[n2];
            this.loadPreviewModel(folder);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPreviewModel(File folder) {
        File dotObj = null;
        try {
            dotObj = folder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(".obj");
                }
            })[0];
            api.graphics.Model model = new api.graphics.Model(dotObj.getAbsolutePath());
            model.load();
            HashMap<String, api.graphics.Model> hashMap = this.previews;
            synchronized (hashMap) {
                this.previews.put(dotObj.getName(), model);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createPreviews(List<MechanicDesign> designs) {
        for (MechanicDesign design : designs) {
            try {
                DesignObject3D designobject = MechanicDesignCreator.getInstance().constructObject(design, MechanicDesignCreator.preview);
                String path = WorkspaceConfiguration.DOT_OBJ_FOLDER + File.separator + designobject.getName() + File.separator + designobject.getName() + ".obj";
                File file = new File(path);
                if (file.exists()) continue;
                KitchenElement element = WorldObjectFactory.getFactory().createObjectFromDefinition(designobject, false);
                PbrMaterial doorHandleMtl = new PbrMaterial();
                doorHandleMtl.setAlbedo(new Vector3());
                doorHandleMtl.setMetalness(0.5f);
                doorHandleMtl.setRoughness(0.1f);
                element.getDoorHandles().values().forEach(handle -> handle.setMaterial(doorHandleMtl));
                WorldObjectFactory.getFactory().createDesignModelSynch(element);
                ModelExporter modelExporter = new ModelExporter();
                Model model = element.getModel().getModel();
                modelExporter.exportModelInstance(model, WorkspaceConfiguration.DOT_OBJ_FOLDER, element.getName(), "textures");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static PreviewController getController() {
        return controller;
    }

    public static void setController(PreviewController controller) {
        PreviewController.controller = controller;
    }
}

