package reporting.htmlReporting;

import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.frs.html.CrudeHtmlElement;
import org.frs.html.ExtendedHtmlParser;
import org.frs.html.HtmlElementAttribute;
import org.frs.html.HtmlPreprocessor;
import org.frs.html.JavaCodeEvaluator;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

import dressing.model.ProjectManager;
import reporting.SVGGnerator;

public class HtmlReport {

	protected HashMap<String, Object> binding = new HashMap<String, Object>();
	protected String template;
	protected CrudeHtmlElement doc;
	protected SVGGnerator svgGen;
	protected transient HtmlPreprocessor preprocessor;
	protected transient JavaCodeEvaluator compiler;
	public Shell shell;
	
	public HtmlReport() {
		compiler = JavaCodeEvaluator.getInstance();
	}

	public void loadTemplate() {
	};

	public void bind() throws Exception{};

	public void loadTemplateFile(String filePath) {
		Bundle bundle = Platform.getBundle("Dressing");
		URL url = FileLocator.find(bundle, new Path(filePath), null);
		FileInputStream fis = null;
		try {
			String path = FileLocator.toFileURL(url).getPath();
			File file = new File(path);
			fis = new FileInputStream(file);
			byte[] buffer = new byte[(int) file.length()];
			fis.read(buffer);
			this.template = new String(buffer, StandardCharsets.UTF_8);
			this.template = this.template.replace("\n", "").replace("\r", "");

		} catch (IOException e) {
			e.printStackTrace();
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					MessageDialog.openError(Display.getCurrent().getActiveShell(), "error",
							"failed to load template file " + filePath);
				}
			});
		} finally {
			if (fis != null)
				try {
					fis.close();
				} catch (IOException e) {
					e.printStackTrace();
					fis = null;
				}
		}
	}

	// remove the for each loop and conditioned blocked
	public void preprocess() {
		if (preprocessor == null)
			preprocessor = new HtmlPreprocessor();
		this.preprocessor.preprocess(doc, this.binding);

	}

	public void generate(boolean export) {
		loadTemplate();
		parseDoc();
		preprocess();
		process();
		if (export) {
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					writeAndDisplay();

				}
			});
		}
	}

	public String export(String path) {
		String fileURI = null;
		File file = new File(path);
		try {
			file.getParentFile().mkdirs();
			file.createNewFile();
			FileOutputStream fos = new FileOutputStream(file);
			fos.write(doc.toString().getBytes());
			fos.close();
			fileURI = file.getPath();
			System.out.println("writing report " + fileURI);
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
		return fileURI;
	}

	public void parseDoc() {
		ExtendedHtmlParser parser = new ExtendedHtmlParser();
		doc = new CrudeHtmlElement();
		doc.setType("html");
		if (template != null) {
			parser.parse(template, doc);
		}
	}

	// substitute and evaluate all java expressions to output pure html
	public void process() {
		for (CrudeHtmlElement elementX : doc) {
			for (HtmlElementAttribute attr : elementX.getAttributes()) {
				String attrValue = attr.getValue();
				if (attrValue.contains("{{")) {
					int start = attrValue.indexOf("{{");
					int end = attrValue.indexOf("}}");
					String expr = attrValue.substring(start + 2, end);
					String str = (String) compiler.evaluate(expr, this.binding, true);
					String evaluatedExpr = attrValue.substring(0, start) + str
							+ attrValue.substring(end + 2, attrValue.length());
					attr.setValue(evaluatedExpr);
				}
			}
			if (elementX.getContent() != null && !elementX.getContent().isEmpty()) {
				String processedContent = processString(elementX.getContent());
				elementX.setContent(processedContent);
			}

		}
	}

	public String processString(String content) {
		String ref = null;
		do {
			ref = HtmlPreprocessor.findNextRef(content);
			if (ref != null) {
				String reference = ref.substring(2, ref.length() - 2);
				String result = String.valueOf(compiler.evaluate(reference, this.binding, true));
				int start = content.indexOf(ref);
				int end = start + ref.length();
				String replacement = content.substring(0, start) + result + content.substring(end);
				content = replacement;
			}
		} while (ref != null);
		return content;
	}

	public void writeAndDisplay() {
		Preferences preferences = InstanceScope.INSTANCE.getNode("com.dressing");
		Preferences projectpref = preferences.node("SuperDressingProject");
		String defaultpath = projectpref.get("SaveAsdirectory",
				System.getProperty("user.home") + File.separator + "Desktop");
		String dirpath = projectpref.get("directoryWrite", defaultpath);
		FileDialog openFileDialog = new FileDialog(shell, SWT.SAVE);
		openFileDialog.setFilterExtensions(new String[] { "*.html" });
		openFileDialog.setFilterPath(dirpath);
		openFileDialog.setFileName(ProjectManager.getManager().getCurrentProject().getName() + " fiche du debit.html");

		String path = openFileDialog.open();
		if (path != null && !path.isEmpty()) {
			File file = new File(path);
			try {
				file.createNewFile();
				FileOutputStream fos = new FileOutputStream(file);
				fos.write(doc.toString().getBytes());
				fos.close();
				String fileURI = file.toURI().toString();
				System.out.println(fileURI);
				// save the new path to preferences to use directly in the next save file action
				dirpath = file.getParent();
				projectpref.put("directoryWrite", dirpath);
				try {
					projectpref.flush();
				} catch (BackingStoreException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				Desktop.getDesktop().browse(URI.create(file.toURI().toString().replace(" ", "%20")));
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	// getters and setters
	public CrudeHtmlElement getDoc() {
		return doc;
	}

	public void setDoc(CrudeHtmlElement doc) {
		this.doc = doc;
	}

	public Shell getShell() {
		return shell;
	}

	public void setShell(Shell shell) {
		this.shell = shell;
	}

}
