package reporting;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import dressing.model.Piece2D;
import utils.EmfUtils;
import dressing.cam.model.Cercle2D;
import dressing.cam.model.Cuboid;

import dressing.cam.model.PlanUsinage;
import dressing.cam.model.Util;

import dressing.cam.model.*;
import dressing.model.Piece2D;

public class Positioncotation {
	enum aXE {

		xaxe, yaxe

	}

	enum DIRECTION {
		UP, DOWN
	}

	aXE axe;
	int position;
	DIRECTION direction;

	public Positioncotation(aXE axe, int position, DIRECTION direction) {
		super();
		this.axe = axe;
		this.position = position;
		this.direction = direction;
	}

	public static ArrayList<Positioncotation> generate(Piece2D piece, PlanUsinage face) {
		Set<Positioncotation> posSet = new HashSet<>();
		ArrayList<Double> posarl = null;
		List<Cuboid> cuboids = Util.getcuboidsforPlan(face, piece);
		List<Cercle2D> cercles = Util.gettrousforPlan(face, piece);
		double h=Util.getPieceH(piece, face);
		double l=Util.getPieceL(piece, face);
		//
//		ArrayList<CamShape> shapes = new ArrayList<CamShape>();
//		for (Usinage usinage : piece.getusinage()) {
//			CamShape shape = null;
//			try {
//				shape = usinage.getShape();
//			} catch (DesignException e) {
//				e.printStackTrace();
//				shape = null;
//			}
//			if (shape != null && shape.getPlan() == face) {
//				shapes.add(shape);
//			}
//			for (CamShape shapeX : shapes) {
//				if (shapeX instanceof Cercle2D) {
//					Cercle2D circle = (Cercle2D) shapeX;
//
//					posSet.add(circle.getxPos());
//				}
//
//			}
//			posarl = new ArrayList<Double>(posSet);
//
//		}
		//
		for(Cercle2D cercle:cercles) {
			posSet.add(new Positioncotation(aXE.xaxe, mesurechoice((int)cercle.getxPos(),(int) l), directionchoice(cercle.getxPos(), l)));
			posSet.add(new Positioncotation(aXE.yaxe, mesurechoice((int)cercle.getyPos(),(int) h), directionchoice(cercle.getyPos(), h)));
		}
		for (Cuboid cuboid:cuboids) {
			try {
				if(cuboid.hauteur==EmfUtils.getDesignHauteur(piece)) {
					posSet.add(new Positioncotation(aXE.xaxe, mesurechoice((int)(cuboid.getxPos()+0.5*cuboid.longeur),(int) l), directionchoice(cuboid.getxPos(), l)));	
		
				}
				if(cuboid.longeur==EmfUtils.getDesignLongeur(piece)) {
					posSet.add(new Positioncotation(aXE.yaxe, mesurechoice((int)(cuboid.getyPos()+0.5*cuboid.hauteur),(int) h), directionchoice(cuboid.getyPos(), h)));	
						
				}
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			
		}
		return new ArrayList<Positioncotation>(posSet);
	}

	public static DIRECTION directionchoice(double pos, double dimension) {

		if (pos > 0.5 * dimension) {
			return DIRECTION.UP;
		} else {
			return DIRECTION.DOWN;
		}
	}
	public static  int mesurechoice(int pos, int dimension) {

		if (pos > 0.5 * dimension) {
			return dimension-pos;
		} else {
			return pos;
		}
	}
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((axe == null) ? 0 : axe.hashCode());
		result = prime * result + ((direction == null) ? 0 : direction.hashCode());
		result = prime * result + position;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Positioncotation other = (Positioncotation) obj;
		if (axe != other.axe)
			return false;
		if (direction != other.direction)
			return false;
		if (position != other.position)
			return false;
		return true;
	}
	
}