package gdxapp.shaders;

import java.io.File;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.Shader;
import com.badlogic.gdx.graphics.g3d.utils.RenderContext;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.GdxRuntimeException;

import dressing.config.WorkspaceConfiguration;
import gdxapp.Commun.Preferences;

public class DepthMapShader implements Shader {
	 	ShaderProgram program;
	    Camera camera;
	    RenderContext context;

	    @Override
	    public void init() {
	        String vertx = Gdx.files.absolute(WorkspaceConfiguration.SHADERS_PATH + File.separator +  "depth/vertx.glsl").readString();
	        String frag = Gdx.files.absolute(WorkspaceConfiguration.SHADERS_PATH + File.separator +  "depth/frag.glsl").readString();
	        program = new ShaderProgram(vertx,frag);
	        if(!program.isCompiled())
	            throw new GdxRuntimeException(program.getLog());
	        program.pedantic = false;
	    }

	    @Override
	    public int compareTo(Shader other) {
	        return 0;
	    }

	    @Override
	    public boolean canRender(Renderable instance) {
	        return true;
	    }

	    @Override
	    public void begin(Camera camera, RenderContext context) {
	        this.camera = camera;
	        this.context = context;
	        this.context.setDepthTest(GL20.GL_LEQUAL);
	        this.context.setCullFace(GL20.GL_FRONT);
	        this.context.setBlending(false,0,0);
	        program.begin();
	        program.setUniformMatrix("lightSpaceMatrix", camera.combined);
	        program.setUniformf("camera_far", 50);
	    }

	    @Override
	    public void render(Renderable renderable) {
	        program.setUniformMatrix("model",renderable.worldTransform);
	        renderable.meshPart.render(program);
	    }

	    @Override
	    public void end() {
	    }

	    @Override
	    public void dispose() {
	        program.dispose();
	    }
}