package gdxapp.object3d;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;

import dressing.mathutils.MathUtilities;
import gdxapp.assets.AssetsTextures;
import gdxapp.shaders.PbrMaterial;
import geometry.CompoundObject;
import dressing.model.persistence.dpos.PlinthDPO;
import dressing.model.persistence.mappers.Persistable;

@Persistable(persistableForm = PlinthDPO.class)
public class PlinthObject extends GeometryObject {
	
	private float thickness = 0.03f;
	private float height = 0.15f;

	public PlinthObject(CompoundObject geometry) {
		super();
		this.geometry = geometry;
		moveable = false;
		setStaticobject(true);
	}

	public float getThickness() {
		return thickness;
	}

	public void setThickness(float thickness) {
		this.thickness = thickness;
	}

	public float getHeight() {
		return height;
	}

	public void setHeight(float height) {
		this.height = height;
	}

	public void prepareModel() {
		Vector3 zero = new Vector3(0,0,0).mul(geometry.getWorldTransform());
		float scale = new Vector3(1,0,0).mul(geometry.getWorldTransform()).sub(zero).len();
		ArrayList<Vector2> vertexData = MathUtilities.calculateRectangulairLine(geometry.getBorder().getVertices(), thickness/(2 * scale));
		PbrMaterial  material = geometry.getBorder().getMaterial();
		if(!material.isReady())
			material.prepare();
		Model model = PolygonBuilder.create3DPolygonModel(vertexData, geometry.getWorldTransform(), new float[] {this.height, 0}, material);
		BoundingBox boundingBox = new BoundingBox();
		model.calculateBoundingBox(boundingBox);
		Vector3 dimension = new Vector3();
		boundingBox.getDimensions(dimension);
		ObjectModel objectModel = new ObjectModel(model, null);
		setModel(objectModel);
		setRealWorldDimension(dimension);
		Vector3 center = new Vector3();
		boundingBox.getCenter(center);
		setRealWorldPosition(center);
	}
	
	public Vector3 getColor() {
		return geometry.getBorder().getMaterial().getAlbedo();
	}
	public void setColor(Vector3 color) {
		geometry.getBorder().getMaterial().setAlbedo(color);
	}
		
	
	@Override
	public Plinth create2DObject() {
		return new Plinth(this);
	}


	@Override
	public String toString() {
		return "PlinthObject [color=" + geometry.getBorder().getMaterial().getAlbedo() + ", thickness=" + thickness + ", height=" + height
				+ "]";
	}
	
	
	
	

}
