package gdxapp.Commun;

import java.util.ArrayList;

import org.eclipse.swt.widgets.Display;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.Input.Keys;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.utils.Array;

import dressing.handlers.gdx.ToolControlHandler;
import dressing.mathutils.Edge;
import dressing.mathutils.MathUtilities;
import dressing.model.ProjectManager;
import dressing.ui.parts.GdxPart;
import dressing.ui.util.EdgeConfigWindow;
import dressing.ui.util.FlecheEditorWindow;
import dressing.ui.util.MeasureLineWidow;
import dressing.ui.util.MesureWidow;
import gdxapp.Commun.Fleche.Direction;
import gdxapp.Commun.Object2DMover.ActionFocus;
import gdxapp.object3d.Object2D;
import gdxapp.scenes.Scene;
import gdxapp.screens.room.RoomController;
import gdxapp.screens.wall.SurfaceController;
import gdxapp.screens.wall.Wall2D;
import gdxapp.shapes.FlecheSegment;
import gdxapp.shapes.LineSegment;
import geometry.Shape;


public class ArrowTaker extends Actor {
	
	public enum ActionFocus {
		START, END,OFFSET
	}
	private ArrayList<Fleche> measures = new ArrayList<Fleche>();
	private Fleche tmpFleche; 
	private FlecheTakerEventProcessor inputProcessor;
	private ArrayList<Vector2> criticalPoints;
	private static ArrowTaker measurer;
	private Fleche selectedFleche;
	private ActionFocus focus=ActionFocus.START; 
	public static ArrowTaker getInstance() {
	 		synchronized(ArrowTaker.class) {
	 			if (measurer == null) {
	 				 measurer = new ArrowTaker();
	 			}
	 			return measurer;
	 		}
	 }
	private ArrowTaker() {
		super();
		setWidth(Gdx.graphics.getWidth());
		setHeight(Gdx.graphics.getHeight());
		inputProcessor = new FlecheTakerEventProcessor(this);
		addListener(inputProcessor);
	}
	
	public void begin() {
		
		var pref = ProjectManager.getManager().getCurrentScene().getPreferences();
		
		tmpFleche = new Fleche();
		tmpFleche.setScale(pref.getWORLD_WIDTH()/getStage().getWidth());
		tmpFleche.setDirection(Fleche.END);
		if(((AbstractScreen) Scene.game.getScreen()).getController() instanceof SurfaceController) {
			SurfaceController controller=(SurfaceController) ((AbstractScreen) Scene.game.getScreen()).getController();
			tmpFleche.setContext(controller.getSurface());
		}
		calculateCriticalPoints();

	}
	
	public void finish() {	
		tmpFleche = null;
		focus=ActionFocus.START;
		remove();
	}
	public void setkeyboardFocus() {
		if (getStage() != null){
				getStage().setKeyboardFocus(this);
		}
	}
	public Fleche addNewMeasure() {
		Fleche fleche = tmpFleche.copy();
		ProjectManager.instance.getCurrentScene().addFleche(fleche);
		tmpFleche = null;
		focus=ActionFocus.START;
		return fleche;
	}
	public void removeFleche(Fleche fleche) {
		ProjectManager.instance.getCurrentScene().removeFleche(fleche);
	}
	public void clearFleches() {
		ArrayList<Fleche> fleches=getFleches();
		if(fleches != null)
		{
			ArrayList<Fleche> actorsToRemove = new ArrayList<Fleche>();
			for(Fleche actor:fleches) {
				actorsToRemove.add(actor);
			}
			for(Fleche actor: actorsToRemove) {
	    		removeFleche(actor);
	    	}
			fleches.clear();
		}
	}
	
	public void calculateCriticalPoints() {
		if(criticalPoints == null)
			criticalPoints = new ArrayList<Vector2>();
		criticalPoints.clear();
		AbstractScreen screen = (AbstractScreen) Scene.game.getScreen();
		ScreenController controller = screen.getController();
		if(controller instanceof SurfaceController) {
			Array<Object2D>  actors=((SurfaceController) controller).getAttachedActors();
			for(Actor actor:actors) {
				if(actor instanceof Object2D) {
					Object2D object2D = (Object2D) actor;
					criticalPoints.addAll(object2D.calculateAttachmentPosition());
				}
			}
			if(measurer.getTmpFleche()!=null && measurer.getTmpFleche().getLine()!=null && 
					measurer.getTmpFleche().getLine().getStart()!=null) {
				criticalPoints.add(new Vector2(measurer.getTmpFleche().getLine().getStart().x, measurer.getStage().getHeight()));
				criticalPoints.add(new Vector2(measurer.getTmpFleche().getLine().getStart().x, 0));
				criticalPoints.add(new Vector2(measurer.getStage().getWidth(), measurer.getTmpFleche().getLine().getStart().y));
				criticalPoints.add(new Vector2(0,  measurer.getTmpFleche().getLine().getStart().y));

			}
		}else if(controller instanceof RoomController){
			Array<Actor> actors =new Array<Actor>();
			actors.addAll(getStage().getActors());
			for(Actor actor:actors ) {
				if(actor instanceof Object2D) {
					Object2D object2D = (Object2D) actor;
					criticalPoints.addAll(object2D.calculateAttachmentPosition());
				}
				if(actor instanceof Wall2D) {
					Wall2D wall=(Wall2D) actor;
					ArrayList<Shape> edges=wall.getSides();
					for(Shape e:edges) {
						if(e instanceof Edge ) {
							Edge edge=(Edge) e;
							criticalPoints.add(edge.getV0());
							criticalPoints.add(edge.getV1());
							criticalPoints.add(edge.getMiddle());
						}
						
					}
				}
			}
		}
		
	}
	public Vector2 getNearestMeasurePoint(float x, float y) {
		AbstractScreen screen = (AbstractScreen) Scene.game.getScreen();
		ScreenController controller = screen.getController();
		if(controller instanceof SurfaceController &&measurer.getTmpFleche()!=null && measurer.getTmpFleche().getLine()!=null && 
				measurer.getTmpFleche().getLine().getStart()!=null) {
			criticalPoints.add(new Vector2(measurer.getTmpFleche().getLine().getStart().x, measurer.getStage().getHeight()));
			criticalPoints.add(new Vector2(measurer.getTmpFleche().getLine().getStart().x, 0));
			criticalPoints.add(new Vector2(measurer.getStage().getWidth(), measurer.getTmpFleche().getLine().getStart().y));
			criticalPoints.add(new Vector2(0,  measurer.getTmpFleche().getLine().getStart().y));

		}
		Vector2 nearest = null;
		if(criticalPoints != null && criticalPoints.size()>0) {
			Vector2 point = new Vector2(x,y);
			nearest = this.criticalPoints.get(0);
			for(Vector2 measurepoint: this.criticalPoints) {
				if(measurepoint.dst(point) < nearest.dst(point))
					nearest = measurepoint;
			}
		}
		return nearest;
	}
	public Edge getNearestEdge(float x, float y) {
		Edge edge=null;
		float pdistance=1000000.0f;
		AbstractScreen screen = (AbstractScreen) Scene.game.getScreen();
		ScreenController controller = screen.getController();
		Array<Actor>  actors = new Array<Actor>();
		if(controller!=null) {
			if(controller instanceof SurfaceController) {
				if(((SurfaceController) controller).getAttachedActors()!=null && !((SurfaceController) controller).getAttachedActors().isEmpty())
				{
					actors.addAll(((SurfaceController) controller).getAttachedActors());
				}
			}else {
				if(getStage()!=null && getStage().getActors()!=null) {
					actors.addAll(getStage().getActors());
				}	
			}	
		}
		
		for(Actor actor: actors) {
			if(actor instanceof Object2D) {
				Object2D object2D = (Object2D) actor;
				for(Edge e:object2D.getEdges()) {
					float distance=MathUtilities.lineToPointDistance(x, y, e.getV0().x, e.getV0().y, e.getV1().x, e.getV1().y);
					if(distance<pdistance) {
						pdistance=distance;
						edge=e;
					}
				}
				
			}
			if(actor instanceof Wall2D) {
				Wall2D wall=(Wall2D) actor;
				ArrayList<Shape> edges=wall.getSides();
				for(Shape e:edges) {
					if(e instanceof Edge)
					{
						float distance=MathUtilities.lineToPointDistance(x, y, ((Edge) e).getV0().x, ((Edge) e).getV0().y, ((Edge) e).getV1().x, ((Edge) e).getV1().y);
						if(distance<pdistance) {
							pdistance=distance;
							edge=(Edge) e;
						}
					}
					
				}
			}
		}
		return edge;
	}
	public void selectMeasure(float x, float y) {
		ArrayList<Fleche> fleches=getFleches();
		setSelectedFleche(null);
		float distance=1000000.0f;
		Vector2 point=new Vector2(x, y);
		Fleche closest=null;
		for(Fleche fleche: fleches) {
			if(fleche!=null ) {
				Vector2 start=fleche.getLine().getStart();
				Vector2 end=fleche.getFlecheSegment().getEnd();
				if(start!=null && end!=null) {
					float distancetoline=MathUtilities.lineToPointDistance(x, y, start.x, start.y, end.x, end.y);
					if(fleche.getFlecheSegment().contains(point)) {
						if(distancetoline<distance ) {
							closest=fleche;
							distance=distancetoline;
							
						}
						if(start.dst(point )<distance){
							closest=fleche;
							distance=distancetoline;
							
						}
						if(end.dst(point )<distance){
							closest=fleche;
							distance=distancetoline;
							
						}
					}
					
				}
				
			}
		}
		setSelectedFleche(closest);
	}
	
	@Override
	public void draw(Batch batch, float parentAlpha) {
//		this.inputProcessor.handleKeyBoardinput();
		GroupSelection.getInstance().clearSelection();
		if(tmpFleche != null)
		{
			Vector2 end=tmpFleche.getLine().getEnd()!=null? tmpFleche.getLine().getEnd():tmpFleche.getLine().getTmpVertex();
			if(tmpFleche.getLine()!=null && tmpFleche.getLine().getStart()!=null&& end!=null &&end.cpy().sub(tmpFleche.getLine().getStart()).len()>0) {
////			
//			if(tmpMeasure.getLine()!=null && tmpMeasure.getLine().getStart()!=null) {
//				Vector3 end=tmpMeasure.getLine().getEnd()!=null? tmpMeasure.getLine().getEnd():tmpMeasure.getLine().getTmpVertex();
				Edge e=getNearestEdge(end.x, end.y);
				if(e!=null)
				{
					float distance=MathUtilities.lineToPointDistance(end.x, end.y, e.getV0().x, e.getV0().y, e.getV1().x, e.getV1().y);
					if(distance>0.01f) {
						tmpFleche.getLine().setTmpcolor(Color.RED);
					}
				}
				
				tmpFleche.draw(batch, parentAlpha);
				tmpFleche.getLine().setTmpcolor(Color.BLACK);
			}
			

		}
		if( getSelectedFleche()!=null) {
			getSelectedFleche().getLine().setTmpcolor(Color.GREEN);
		}

	}
	
	
	public ArrayList<Fleche> getFleches() {
		AbstractScreen screen = (AbstractScreen) Scene.game.getScreen();
		ScreenController controller = screen.getController();
		if(measures==null) {
			measures = new ArrayList<Fleche>();
		}
		measures.clear();
		for(Fleche fleche:ProjectManager.instance.getCurrentScene().getFleches()) {
			if(fleche!=null)
			{
				if(controller instanceof RoomController ) {
					if(fleche.getContext()==null) {
						measures.add(fleche);
					}
				}
				if(controller instanceof SurfaceController) {
					if(fleche.getContext()!=null && fleche.getContext().equals(((SurfaceController) controller).getSurface())) {
						measures.add(fleche);
					}
				}
			}
		}
		return measures;
	}

	
	public Fleche getTmpFleche() {
		return tmpFleche;
	}

	public void setTmpMeasure(Fleche tmpFleche) {
		this.tmpFleche = tmpFleche;
	}
	
	

	public Fleche getSelectedFleche() {
		return selectedFleche;
	}

	public void setSelectedFleche(Fleche selectedFleche) {
		if(selectedFleche==null && this.selectedFleche!=null) {
			this.selectedFleche.getLine().setTmpcolor(this.selectedFleche.getLine().getColor());;
		}
		this.selectedFleche = selectedFleche;
	}

	public class FlecheTakerEventProcessor extends ActorInputListener{
		
		private final String TAG = FlecheTakerEventProcessor.class.getName();
		
		private ArrowTaker ArrowTaker;
		private long lastClickDate = System.currentTimeMillis();

		public FlecheTakerEventProcessor(ArrowTaker measurer) {
			super();
			this.ArrowTaker = measurer;
		}

		@Override
		public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
//			Gdx.app.debug(TAG, " touch down");
			if(button == Input.Buttons.RIGHT)
			{
				long newClickDate = System.currentTimeMillis();
				ArrowTaker.selectMeasure(x, y);
				if(newClickDate - lastClickDate < 300 && ArrowTaker.getSelectedFleche()!=null) {
					Display.getDefault().asyncExec(new Runnable() {
					    public void run() {
					    	FlecheEditorWindow window = FlecheEditorWindow.getInstance();
							window.setFleche(ArrowTaker.getSelectedFleche(),true);
							window.show();
					    }
					});
				}
				lastClickDate = newClickDate;

				return true;
			}
			if(button ==  Input.Buttons.LEFT) {
				
				if(ArrowTaker.getTmpFleche() == null )
				{
					ArrowTaker.begin();
				}
				Vector2 point = new Vector2(x,y);
				Vector2 nearestPoint=getNearestMeasurePoint(x, y);
				if( nearestPoint != null)
				{
					if(Gdx.input.isKeyPressed(Keys.SHIFT_LEFT)||Gdx.input.isKeyPressed(Keys.SHIFT_RIGHT))
					{
						point = new Vector2(nearestPoint);
					}else if(new Vector2(nearestPoint).cpy().dst(point)/ArrowTaker.getTmpFleche().getFlecheSegment().getScale()<0.03f) {
						point = new Vector2(nearestPoint);
					}
				}
				
				if(!ArrowTaker.focus.equals(ActionFocus.OFFSET)) {
					Edge e=getNearestEdge(point.x, point.y);
					if(e!=null) {
						if(Gdx.input.isKeyPressed(Keys.M)){
							Vector2 point1 =MathUtilities.getclosestPoint(point.x, point.y, e.getV0().x,  e.getV0().y,  e.getV1().x,  e.getV1().y);
							point = new Vector2(point1.x,point1.y);						
						}
						else {
							float distance=MathUtilities.lineToPointDistance(point.x, point.y, e.getV0().x, e.getV0().y, e.getV1().x, e.getV1().y);
							distance/=ArrowTaker.getTmpFleche().getFlecheSegment().getScale();
							if(distance<0.03f ) {
								Vector2 point1 =MathUtilities.getclosestPoint(point.x, point.y, e.getV0().x,  e.getV0().y,  e.getV1().x,  e.getV1().y);
								point = new Vector2(point1.x,point1.y);
							}
						}
					}
				}
				if(ArrowTaker.focus.equals(ActionFocus.START)) {
					ArrowTaker.getTmpFleche().getLine().setStart(point);
					ArrowTaker.getTmpFleche().getLine().setTmpVertex(point);
					ArrowTaker.focus=	ActionFocus.END;

				}else if(ArrowTaker.focus.equals(ActionFocus.END)) {
					float len=point.cpy().sub(tmpFleche.getLine().getStart()).scl(tmpFleche.getFlecheSegment().getScale()).len();
					if(len>0.01f) {
						ArrowTaker.getTmpFleche().getLine().setEnd(point);
						ArrowTaker.focus=	ActionFocus.OFFSET;
					}
					

				}else {
					Fleche fleche =ArrowTaker.addNewMeasure();
					if(fleche!=null) {
						Display.getDefault().asyncExec(new Runnable() {
						    public void run() {
						    	FlecheEditorWindow window = FlecheEditorWindow.getInstance();
								window.setFleche(fleche,true);
								window.show();
						    }
						});
					}
				}
				return true;

			}
			return false;
		}

		@Override
		public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
			
			
		}

		@Override
		public void touchDragged(InputEvent event, float x, float y, int pointer) {
			if(ArrowTaker.getTmpFleche() != null ) {
				Vector2 point = new Vector2(x,y);
				FlecheSegment lineSegment = ArrowTaker.getTmpFleche().getFlecheSegment();
				Vector2 nearestPoint=getNearestMeasurePoint(x, y);
				if( nearestPoint != null)
				{
					if(Gdx.input.isKeyPressed(Keys.SHIFT_LEFT)||Gdx.input.isKeyPressed(Keys.SHIFT_RIGHT))
					{
						point = nearestPoint;
					}else if(nearestPoint.cpy().dst(point)/ArrowTaker.getTmpFleche().getFlecheSegment().getScale()<0.03f) {
						point = nearestPoint;
					}
				}
				if(!ArrowTaker.focus.equals(ActionFocus.OFFSET)) {

					Edge e=getNearestEdge(point.x, point.y);
					if(e!=null) {
						if(Gdx.input.isKeyPressed(Keys.M)){
							point =MathUtilities.getclosestPoint(point.x, point.y, e.getV0().x,  e.getV0().y,  e.getV1().x,  e.getV1().y);
						}else {
							float distance=MathUtilities.lineToPointDistance(point.x, point.y, e.getV0().x, e.getV0().y, e.getV1().x, e.getV1().y);
							distance/=ArrowTaker.getTmpFleche().getFlecheSegment().getScale();
							if(distance<0.03f ) {
								Vector2 point1 =MathUtilities.getclosestPoint(point.x, point.y, e.getV0().x,  e.getV0().y,  e.getV1().x,  e.getV1().y);
								point = new Vector2(point1.x,point1.y);
							}
						}
					}
				}
				if(ArrowTaker.this.focus.equals(ActionFocus.END))
				{
					lineSegment.getLine().setTmpVertex(new Vector2(point));
				}else if(ArrowTaker.this.focus.equals(ActionFocus.OFFSET)) {
					Vector2 start=ArrowTaker.getTmpFleche().getLine().getStart();
					Vector2 end=ArrowTaker.getTmpFleche().getLine().getEnd();
					float offset=MathUtilities.lineToPointDistance(point.x, point.y, start.x, start.y, end.x,  end.y);					
					offset =Math.abs(offset);
					ArrowTaker.getTmpFleche().getLine().setOffset(offset);
				}
			}
		}

		@Override
		public boolean mouseMoved(InputEvent event, float x, float y) {			
			if(ArrowTaker.getTmpFleche() != null ) {
				Vector2 point = new Vector2(x,y);
				FlecheSegment lineSegment = ArrowTaker.getTmpFleche().getFlecheSegment();
				Vector2 nearestPoint=getNearestMeasurePoint(x, y);
				if( nearestPoint != null)
				{
					if(Gdx.input.isKeyPressed(Keys.SHIFT_LEFT)||Gdx.input.isKeyPressed(Keys.SHIFT_RIGHT))
					{
						point = nearestPoint;
					}else if(nearestPoint.cpy().dst(point)/ArrowTaker.getTmpFleche().getFlecheSegment().getScale()<0.03f) {
						point = nearestPoint;
					}
				}
				if(!ArrowTaker.focus.equals(ActionFocus.OFFSET)) {

					Edge e=getNearestEdge(point.x, point.y);
					if(e!=null) {
						if(Gdx.input.isKeyPressed(Keys.M)){
							point =MathUtilities.getclosestPoint(point.x, point.y, e.getV0().x,  e.getV0().y,  e.getV1().x,  e.getV1().y);							
						}else {
							float distance=MathUtilities.lineToPointDistance(point.x, point.y, e.getV0().x, e.getV0().y, e.getV1().x, e.getV1().y);
							distance/=ArrowTaker.getTmpFleche().getFlecheSegment().getScale();
							if(distance<0.03f ) {
								Vector2 point1 =MathUtilities.getclosestPoint(point.x, point.y, e.getV0().x,  e.getV0().y,  e.getV1().x,  e.getV1().y);
								point = new Vector2(point1.x,point1.y);
							}
						}
					}
				}
				if(ArrowTaker.this.focus.equals(ActionFocus.END))
				{
					lineSegment.getLine().setTmpVertex(new Vector2(point));
				}else if(ArrowTaker.this.focus.equals(ActionFocus.OFFSET)) {
					Vector2 start=ArrowTaker.getTmpFleche().getLine().getStart();
					Vector2 end=ArrowTaker.getTmpFleche().getLine().getEnd();
					float offset=MathUtilities.lineToPointDistance(point.x, point.y, start.x, start.y, end.x,  end.y);					
					offset =Math.abs(offset);
					ArrowTaker.getTmpFleche().getLine().setOffset(offset);
				}
			}
			return true;
		}

		@Override
		public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
			super.enter(event, x, y, pointer, fromActor);
		}

		@Override
		public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
			super.exit(event, x, y, pointer, toActor);
		}

		@Override
		public boolean scrolled(InputEvent event, float x, float y, int amount) {
			Gdx.app.debug(TAG, " scrolled");
			return super.scrolled(event, x, y, amount);
		}

		@Override
		public boolean keyDown(InputEvent event, int keycode) {
			Gdx.app.debug(TAG, " key down");
			return super.keyDown(event, keycode);
		}

		@Override
		public boolean keyUp(InputEvent event, int keycode) {
			Gdx.app.debug(TAG, " key up");
			if(keycode == Keys.ESCAPE)
			{
				tmpFleche = null;
				focus=ActionFocus.START;
				ToolControlHandler.getInstance().threadSafeTriggerSelectObject();
				return true;
			}
			if(keycode == Keys.FORWARD_DEL && Gdx.input.isKeyPressed(Keys.SHIFT_RIGHT))
			{
				ArrowTaker.clearFleches();
				return true;
			}
			if(keycode == Keys.FORWARD_DEL) {
				Fleche selected=getSelectedFleche();
				if(selected!=null && selected.getFlecheSegment()!=null)
				{
					this.ArrowTaker.removeFleche(selected);
					setSelectedFleche(null);
				}
				return true;

			}
			return false;
		}
		
	}

}
