package dressing.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;

import com.google.gson.Gson;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;

public class UtilDTO {

	public static <T> T parseRequestBody(HttpServletRequest request, Class<T> clazz) throws IOException {
		final Gson gson = new Gson();
		String json = requestBodyToString(request);
		try {
			JsonParser.parseString(json);
			T object = gson.fromJson(json, clazz);
//			validate(object, clazz);
			return object;
		} catch (JsonSyntaxException  e) {
			throw new IllegalArgumentException("Invalid JSON format in request body", e);
		}

	}

	public static <T> T parseUrlResposne(URL url, Class<T> clazz) throws IOException {
		final String input = urlResponseToString(url);
		return parseString(input, clazz);

	}

	public static <T> T parseString(String json, Class<T> clazz) throws IllegalArgumentException {
		final Gson gson = new Gson();
		try {
			JsonParser.parseString(json);
			T object = gson.fromJson(json, clazz);
//			validate(object, clazz);
			return object;
		} catch (JsonSyntaxException e) {
			throw new IllegalArgumentException("Invalid JSON string provided", e);
		}
	}

	public static String requestBodyToString(HttpServletRequest request) throws IOException {
		String data = "";
		final BufferedReader reader = request.getReader();
		StringBuilder builder = new StringBuilder();
		String line;
		while ((line = reader.readLine()) != null) {
			builder.append(line);
		}
		data = builder.toString();

		if (data.isEmpty()) {
			throw new IllegalArgumentException("Empty request body");
		}
		return data;
	}

	public static String urlResponseToString(URL url) throws IOException {
		URLConnection urlConnection = url.openConnection();

		if (urlConnection instanceof HttpURLConnection) {
			HttpURLConnection httpConnection = (HttpURLConnection) urlConnection;
			int responseCode = httpConnection.getResponseCode();

			if (responseCode != 200) {
				throw new IOException("Failed to connect to URL: " + url + ", Response Code: " + responseCode);
			}
		}

		try (BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()))) {
			return in.lines().collect(Collectors.joining());
		}
	}

	public static String getBody(HttpServletRequest request) {
		try {
			return request.getReader().lines().collect(Collectors.joining());
		} catch (IOException e) {
			return "";
		}
	}

//	private static <T> void validate(T object, Class<T> clazz) throws Exception {
//		for (Field field : clazz.getDeclaredFields()) {
//			if (field.isAnnotationPresent(ApiRequired.class)) {
//				field.setAccessible(true);
//				Object value = field.get(object);
//				if (Objects.isNull(value)) {
//					throw new Exception("Field " + field.getName() + " is null ");
//				} else if (value.toString().isEmpty()) {
//					throw new Exception("Field " + field.getName() + " is  empty");
//
//				}
//			}
//		}
//	}
}
