package dressing.ui.util;

import org.eclipse.swt.widgets.Composite;

import param.MaterialType;
import param.MaterialTypeInstance;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;

import dressing.config.persistence.ResourceManagers;
import dressing.model.ModelProvider;
import dressing.ui.components.TableComboViewerSearch;
import dressing.ui.emf.MechanicdesignLibrary.ModelEMFLabelProvider;
import dressing.ui.engine3d.SceneTexture;
import dressing.ui.engine3d.SceneTexture.CATEGORY;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Control;

public class MaterialTypeInstanceComposite extends Composite {

	private MaterialTypeInstance material;
	boolean dirty=false;
	private Label lblName;
	private TableComboViewerSearch tableComboViewerTexture;
	private TableCombo tcAlbedo;
	private Combo tcMaterial;
	private ComboViewer tableComboViewerMaterialType;
	private Button btnLibre_1;
	private Label lblTexture;
	PropertyChangeListener dirtyListener=new PropertyChangeListener() {
		
		@Override
		public void propertyChange(PropertyChangeEvent evt) {
			// TODO Auto-generated method stub
			dirty=true;
		}
	};
	ISelectionChangedListener dirtySelectionListener = new ISelectionChangedListener() {
		
		@Override
		public void selectionChanged(SelectionChangedEvent event) {
			// TODO Auto-generated method stub
			dirty=true;
		}
	};
	private ColorComposite colorComposite;
	
	
	public MaterialTypeInstanceComposite(Composite parent,MaterialTypeInstance element, int style) {
		this(parent, style);
		setMaterial(element);
	}

	public MaterialTypeInstanceComposite(Composite parent, int style) {
		super(parent, style);
		GridLayout gridLayout = new GridLayout(5, false);
		gridLayout.marginHeight = 0;
		gridLayout.marginWidth = 0;
		gridLayout.verticalSpacing = 0;
		setLayout(gridLayout);
		
		tableComboViewerMaterialType = new ComboViewer(this, SWT.READ_ONLY);
		tcMaterial = tableComboViewerMaterialType.getCombo();
		tcMaterial.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				if(material != null) {
					material.setMaterial((MaterialType) tableComboViewerMaterialType.getStructuredSelection().getFirstElement());
				}
			}
		});
		GridData gd_tcMaterial = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_tcMaterial.minimumWidth = 120;
		tcMaterial.setLayoutData(gd_tcMaterial);
		tableComboViewerMaterialType.setContentProvider(ArrayContentProvider.getInstance());
		tableComboViewerMaterialType.setLabelProvider(ModelEMFLabelProvider.getInstance());
		tableComboViewerMaterialType.setInput(ResourceManagers.getIntance().getMaterialTypesGroup().getMaterialTypes());
		
		lblTexture = new Label(this, SWT.NONE);
		lblTexture.setText("Texture");
		tableComboViewerTexture = new TableComboViewerSearch(this, SWT.READ_ONLY);
		tcAlbedo = tableComboViewerTexture.getTableCombo();
		tcAlbedo.setEditable(true);
		tcAlbedo.defineColumns(new String[] { "texture" });
		GridData gd_tcAlbedo = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_tcAlbedo.minimumWidth = 150;
		tcAlbedo.setLayoutData(gd_tcAlbedo);
		tableComboViewerTexture.setContentProvider(ArrayContentProvider.getInstance());
		tableComboViewerTexture.setLabelProvider(SingleImageItemLabelProvider.getInstance());
		ArrayList<Object> textures =new ArrayList<Object>();
		textures.add(SetCommand.UNSET_VALUE);
		textures.addAll(ModelProvider.getTextures(CATEGORY.ELEMENT));
		tableComboViewerTexture.setInput(textures);
		
		btnLibre_1 = new Button(this, SWT.CHECK);
		btnLibre_1.setText("Couleur");
		btnLibre_1.addSelectionListener(new SelectionAdapter() { 

			@Override
			public void widgetSelected(SelectionEvent e) {
				if(btnLibre_1.getSelection()) {
					colorComposite.setEnabled(true);
					tcAlbedo.setEnabled(false);
				}else {
					colorComposite.setEnabled(false);
					tcAlbedo.setEnabled(true);
				}
				
				btnColorChanged();
			}


			
		});
		colorComposite = new ColorComposite(this, SWT.None);
		GridData gd_colorComposite = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_colorComposite.minimumWidth = 100;
		colorComposite.setLayoutData(gd_colorComposite);
		setTabList(new Control[]{tcAlbedo, tcMaterial, btnLibre_1, colorComposite});


	}

	public Label getLblName() {
		return lblName;
	}
	public void setLblName(Label lblName) {
		this.lblName = lblName;
	}
	public MaterialTypeInstance getMaterial() {
		return material;
	}
	public String getSelectedTexture() {
		StructuredSelection sel =(StructuredSelection) tableComboViewerTexture.getStructuredSelection();
		if(sel!=null) {
			Object o=sel.getFirstElement();
			if(o!=null) {
				if(o instanceof SceneTexture) {
					return ((SceneTexture) o).getName();
				}else if(o instanceof String) {
					return(String) o;
				}
			}
		}
		return null;
	}
	public void setMaterial(MaterialTypeInstance material) {
		if(this.material!=null) {
			this.material.removePropertyChangeListener(dirtyListener);
		}
		tableComboViewerTexture.removeSelectionChangedListener(dirtySelectionListener);
		this.material = EcoreUtil.copy(material);
		
		this.colorComposite.setColor(this.material.getColor());
		ArrayList<Object> textures =new ArrayList<Object>();
		textures.add(SetCommand.UNSET_VALUE);
		textures.addAll(ModelProvider.getTextures(CATEGORY.ELEMENT));
		tableComboViewerTexture.setInput(textures);
		SceneTexture texture = ModelProvider.getMaterialSceneTexture(this.material);
		if(texture!=null) {
			StructuredSelection selection =new StructuredSelection(texture);
			this.tableComboViewerTexture.setSelection(selection);
		}else {
			StructuredSelection selection =new StructuredSelection(SetCommand.UNSET_VALUE);
			this.tableComboViewerTexture.setSelection(selection);
		}
		if(material.isIsColor()) {
			btnLibre_1.setSelection(true);
		}else {
			btnLibre_1.setSelection(false);
		}
		if(this.material.getMaterial()!=null) {
			tableComboViewerMaterialType.setSelection(new StructuredSelection( this.material.getMaterial()), true);
		}
		this.material.addPropertyChangeListener(dirtyListener);
		if(tableComboViewerTexture!=null && tableComboViewerTexture.getControl()!=null 
				&&!tableComboViewerTexture.getControl().isDisposed()) {
			tableComboViewerTexture.addSelectionChangedListener(dirtySelectionListener);
		}
		dirty=false;	
	}

	public boolean isDirty() {
		return dirty||colorComposite.isDirty();
	}

	public void setDirty(boolean dirty) {
		this.dirty = dirty;
	}

	public ColorComposite getColorComposite() {
		return colorComposite;
	}
	public void setColorComposite(ColorComposite colorComposite) {
		this.colorComposite = colorComposite;
	}
	
	public TableComboViewer getTableComboViewerTexture() {
		return tableComboViewerTexture;
	}
	public void setTableComboViewerTexture(TableComboViewerSearch tableComboViewerTexture) {
		this.tableComboViewerTexture = tableComboViewerTexture;
	}
	public ComboViewer getTableComboViewerMaterialType() {
		return tableComboViewerMaterialType;
	}
	public void setTableComboViewerMaterialType(ComboViewer tableComboViewerMaterialType) {
		this.tableComboViewerMaterialType = tableComboViewerMaterialType;
	}
	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}

	
	private void btnColorChanged() {
		this.material.setIsColor(btnLibre_1.getSelection());
	}
	@Override
	public void setEnabled(boolean enabled) {
		// TODO Auto-generated method stub
		super.setEnabled(enabled);
		btnLibre_1.setEnabled(enabled);
		tcAlbedo.setEnabled(enabled);
		tcMaterial.setEnabled(enabled);
	}
}
