package dressing.ui.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

import dressing.controller.ProjectCreator;
import dressing.model.DesignException;
import dressing.model.Kitchen;

public class CreateKitchenPage extends WizardPage{

	CreateKitchenComposite compos;
	Kitchen kitchen;
	private ProjectCreator creator;
	PropertyChangeListener pcl;
	boolean errorfound = false;
	
	public CreateKitchenPage(ProjectCreator creator) {
		super("Ajouter une Cuisine");
		setTitle("Configuration de Cuisine");
		setDescription("Spécifier les dimensions , les matériaux et les préférences");
		this.creator = creator;
		pcl= new PropertyChangeListener() {
			@Override
			public void propertyChange(PropertyChangeEvent evt) {
				// TODO Auto-generated method stub
				if(isCurrentPage())
				{
					if (CreateKitchenPage.this != null) {
						
						if (getWizard().getContainer() != null)
							getWizard().getContainer().updateButtons();
					}
				}
			}
		};
		this.creator.addPropertyChangeListener(pcl);
	}

	@Override
	public void createControl(Composite parent) {
		compos = new CreateKitchenComposite(parent, SWT.NONE,this.creator);
		setControl(compos);
		getWizard().getContainer().updateButtons();
	}

	@Override
	public void setVisible(boolean visible) {
		// TODO Auto-generated method stub
		super.setVisible(visible);
		compos.redraw();
		compos.requestLayout();
	}

	@Override
	public boolean isPageComplete() {
		
		if(compos == null || !compos.isReady())
			return false;
		
		try {

			creator.checkKitchen();
			setErrorMessage(null);
			setMessage("Vous pouvez remplir les informations du cuisine", WizardPage.INFORMATION);
			
			errorfound = false;

		} catch (DesignException e) {
			setErrorMessage(e.getMessage());
			errorfound = true;
		}
		return !errorfound;		
	}
	
	public void clearlistners() {
		creator.removePropertyChangeListener(pcl);
		compos.clearlistners();
	}
	
	@Override
	public Point getMinimumPageSize() {
		// TODO Auto-generated method stub
		return new Point(1080, 720);
	}
}
