package dressing.ui.palette;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;

public class ParentHandler extends ControlAdapter implements DisposeListener, Runnable {
	private final Composite control;

	private final Composite parent;

	private boolean dispatched;

	public ParentHandler(Composite control) {
		this.control = control;
		this.parent = control.getParent();
		control.addDisposeListener(this);
		parent.addControlListener(this);
	}

	public void run() {
		if (!parent.isDisposed() && dispatched) {
			dispatched = false;
			parent.setRedraw(true);
		}
	}

	@Override
	public void controlResized(ControlEvent e) {
		if (!dispatched) {
			parent.setRedraw(false);
			dispatched = true;
			parent.getDisplay().asyncExec(this);
		}
	}

	public void widgetDisposed(DisposeEvent e) {
		parent.removeControlListener(this);
	}

	public void dispose() {
		run();
		dispatched = false;
		control.removeDisposeListener(this);
		parent.removeControlListener(this);
	}
}