package dressing.ui.palette;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.eclipse.swt.widgets.Display;

import dressing.config.ReportingPreferences;
import dressing.config.WorkspaceConfiguration;
import dressing.config.persistence.ResourceManagers;
import dressing.events.Event;
import dressing.events.EventDriver;
import dressing.model.ModelProvider;
import dressing.profiling.TimeProfiler;
import dressing.ui.util.ImageLoaderCache;
import gdxapp.object3d.ModeledObject;
import gdxapp.scenes.SceneEvent;
import param.Catalog;
import param.DesignClassGroup;
import param.DesignClasse;
import param.DesignInstance;
import param.MechanicDesign;
import param.MechanicDesignGroup;
import param.MechanicPublicParam;
import param.ModelRoot;
import param.Option;

public class PaletteProvider implements dressing.events.EventHandler{

	protected  PaletteProject palette;
	private static PaletteProvider instance;
	 // Constants for default images
    public static final String DEFAULT_MODEL_ICON = "cube-64.png";
    public static final String DEFAULT_FOLDER_ICON = "icons8-folder-100.png";
    public static final boolean isLibrary=true;
	private PaletteGroup model3dGroup;


    /**
     * Thread-safe singleton accessor (double-checked locking).
     */
    public static PaletteProvider getInstance() {
		synchronized (PaletteProvider.class) {
			if (instance == null) {
				instance = new PaletteProvider();
			}
			return instance;
		}
		
    }
	protected PaletteProvider() {
		EventDriver.getDriver().registerSubscription(SceneEvent.UPDATE_DATAMODEL.name(), this);
    }

	public PaletteProject getPaletteRoot() {
		if(this.palette==null) {
			this.palette = createPaletteProject();

		}
		return this.palette;
	}
	
	public PaletteProject createPaletteProject() {
		long debut =new Date().getTime();
		if(palette!=null) {
			palette.clear();
		}
		palette = new PaletteProject();

		List<ModelRoot> roots = ResourceManagers.getIntance().getModelroots();
		for(ModelRoot root:roots) {
			DesignClassGroup classes = root.getClasses();
			if (classes != null && classes.getDesignClasse() != null && classes.getDesignClasse().size() > 0) {
				for (DesignClasse classe : classes.getDesignClasse()) {
					PaletteGroup grp2 = new PaletteGroup(classe.getName()+" ("+root.getName()+")");
					grp2.setData(classe);
					grp2.setModifiable(false);
					grp2.setDeletable(false);
					if (classe.getCategorie() != null && classe.getCategorie().size() > 0) {
						for (MechanicDesignGroup famille : classe.getCategorie()) {
							if (famille != null && famille.getMechanicdesign() != null && famille.isPublic()) {
								createDesignFamilyPaletteGroup(grp2, famille,PaletteProvider.isLibrary);
							}
						}
					}
					fixPaletteGroupPreviewPath(grp2, classe.getPerviewPath());

					palette.addPaletteGroup(grp2);
				}
	
			}
		}
		for (Catalog cat : ResourceManagers.getIntance().getCatalogs()) {
			PaletteGroup grp2 = new PaletteGroup(cat.getName() + " (" + cat.getOwner() + ")");
			grp2.setData(cat);
			grp2.setModifiable(true);
			grp2.setDeletable(true);
			if (cat.getCategorie() != null && !cat.getCategorie().isEmpty()) {
				for (MechanicDesignGroup famille : cat.getCategorie()) {
					if (famille != null && famille.getMechanicdesign() != null) {
						createDesignFamilyPaletteGroup(grp2, famille,!PaletteProvider.isLibrary);

					}
				}
			}

			fixPaletteGroupPreviewPath(grp2, cat.getPerviewPath());
			palette.addPaletteGroup(grp2);
		}
		updateModels3DPalette();
		DesignPreviewGenerator.getInstance().start();
		System.err.println("end palette \t" +(new Date().getTime()-debut));
		return palette;
	}
	/**
	 * 
	 */
	public void updateModels3DPalette() {
		if(model3dGroup!=null) {
			model3dGroup.clear();
			palette.addPaletteGroup(model3dGroup);
		}else {
			model3dGroup = new PaletteGroup("Modèles 3D");
			model3dGroup.setData("Model3D");
			model3dGroup.setModifiable(false);
			model3dGroup.setDeletable(false);
			model3dGroup.setImage(WorkspaceConfiguration.getIconsPath() + File.separator + DEFAULT_FOLDER_ICON);
			palette.addPaletteGroup(model3dGroup);
		}
		
		List<ModeledObject> designObjects = new ArrayList<ModeledObject>();
		designObjects.addAll(ModelProvider.getDesignObjects());
		List<String> model3DCategories = ModelProvider.getDesignObjectsCategories();
		model3DCategories.remove("Model3D");
		for(String categorie:model3DCategories) {
			PaletteGroup group3 = new PaletteGroup(categorie);
			group3.setData(categorie);
			group3.setModifiable(false);
			group3.setDeletable(false);
			List<ModeledObject> categorieDesigns=ModelProvider.getDesignObjectsByCategory(categorie);
			for(ModeledObject object:categorieDesigns) {
				createObject3DPaletteItem(group3, object);
			}
			designObjects.removeAll(categorieDesigns);
			group3.setImage(WorkspaceConfiguration.getIconsPath() + File.separator + DEFAULT_FOLDER_ICON);
			model3dGroup.addPaletteGroup(group3);
		}
		
		for(ModeledObject object:designObjects) {
			createObject3DPaletteItem(model3dGroup, object);
		}
		
	}
	
	/**
	 * @param parentGroup
	 * @param object3d
	 */
	public void createObject3DPaletteItem(PaletteGroup parentGroup, ModeledObject object3d) {
		PaletteItem item = new PaletteItem(object3d.getName());
		item.setData(object3d);
		parentGroup.addPaletteItem(item);
		
		item.setModifiable(false);
		item.setDeletable(false);
		item.setExportcopy(false);
		String preview=object3d.getProperties().getProperty("preview");
		if(preview==null || preview.isEmpty())
		{
			preview=object3d.getProperties().getProperty("front-texture");
		}
		if(preview!=null && ImageLoaderCache.isValidImagePath(preview)) {
			
			item.setImage(preview);
		}else {
			item.setImage(WorkspaceConfiguration.getIconsPath() + File.separator + DEFAULT_MODEL_ICON);
		}
	}
	/**
	 * @param parentGroup
	 * @param famille
	 */
	public void createDesignFamilyPaletteGroup(PaletteGroup parentGroup, MechanicDesignGroup famille,boolean isLibrary) {
		PaletteGroup group = new PaletteGroup(famille.getName());
		group.setData(famille);
		group.setModifiable(!isLibrary);
		group.setDeletable(!isLibrary);
		for (MechanicDesign design : famille.getMechanicdesign()) {
			if (design != null && design.isPublic()) {
				if(design.getOptions()!=null &&!design.getOptions().getOptions().isEmpty() ) {
					PaletteGroup designGroup = new PaletteGroup(design.getName());
					designGroup.setData(design);
					designGroup.setModifiable(!isLibrary);
					designGroup.setDeletable(!isLibrary);
					fixPaletteGroupPreviewPath(designGroup, design.getPreviewImagePath());
					//
					group.addPaletteGroup(designGroup);
					
					for(Option option:design.getOptions().getOptions()) {
						createDesignOptionPaletteItem(designGroup, option, isLibrary);
					}
				}else {
					createDesignPaletteItem(group, design,isLibrary);
				}
			}
		}
		for (DesignInstance design : famille.getDesignsintances()) {
			if (design != null && design.isPublic()) {
				createDesignInstancePaletteItem(group, design, isLibrary);
			}
		}
		createDesignGroupImage(famille, group);
		parentGroup.addPaletteGroup(group);
	}
	/**
	 * @param isdev
	 * @param parentGroup
	 * @param design
	 */
	public void createDesignPaletteItem( PaletteGroup parentGroup, MechanicDesign design ,boolean isLibrary) {
		boolean isdev = ReportingPreferences.getInstance().getProperty("user.dev", false);
		PaletteItem item = new PaletteItem(design.getName());
		item.setData(design);
		parentGroup.addPaletteItem(item);
		
		item.setModifiable(isLibrary?isdev:design.isChangeable());
		item.setDeletable(isLibrary?isdev:design.isDeleteable());
		item.setExportcopy(true);
		createDesignImage(design, item);

	}
	
	/**
	 * @param isdev
	 * @param grp3
	 * @param design
	 */
	public void createDesignInstancePaletteItem( PaletteGroup grp3, DesignInstance design ,boolean isLibrary) {
		boolean isdev = ReportingPreferences.getInstance().getProperty("user.dev", false);
		PaletteItem item = new PaletteItem(design.getName());
		item.setData(design);
		grp3.addPaletteItem(item);
		
		item.setModifiable(isLibrary?isdev:design.isChangeable());
		item.setDeletable(isLibrary?isdev:true);
		item.setExportcopy(!isLibrary);
		createDesignInstanceImage(design, item);
		MechanicDesign designCopy=MechanicDesignFactory.createCopy(design);
		addMechanicDesignattributeTags(item, designCopy);
		addMechanicDesignTags(item, designCopy);
	}
	/**
	 * @param isdev
	 * @param grp3
	 * @param option
	 */
	public void createDesignOptionPaletteItem( PaletteGroup grp3, Option option ,boolean isLibrary) {
		PaletteItem item = new PaletteItem(option.getLabel());
		item.setData(option);
		grp3.addPaletteItem(item);
		
		item.setModifiable(true);
		item.setDeletable(true);
		item.setExportcopy(true);
		createDesignOptionImage(option, item);
		MechanicDesign designCopy=MechanicDesignFactory.createCopy(option);
		addMechanicDesignattributeTags(item, designCopy);
		addMechanicDesignTags(item, designCopy);
	}
	/**
	 * @param item
	 * @param design
	 */
	public void addMechanicDesignattributeTags(PaletteItem item, MechanicDesign design) {
		try {
			MechanicPublicParam portType = design.getPublicParam("PORT_TYPE");
			MechanicPublicParam porteDirection = design.getPublicParam("PORTE_DIRECTION");
			MechanicPublicParam POIGNEE_TYPE = design.getPublicParam("POIGNEE_TYPE");
			MechanicPublicParam gola_Type = design.getPublicParam("gola_Type");

			if(portType!=null && portType.getTypedefelement()!=null) {
				String key = portType.getTypedefelement().getKey();

				if (key != null && !key.isEmpty()) {
					item.addAttribute(portType.getTypedef().getKey(), key);
					if ("FRANCAISE".equals(key)) {
						if (porteDirection != null && porteDirection.getTypedefelement() != null) {
							String direction = porteDirection.getTypedefelement().getKey();
							if (direction != null && !direction.isEmpty()) {
//							item.addTag(direction);
								item.addAttribute(porteDirection.getTypedef().getKey(), direction);
							}
						}
					}
				}			
			}
			if(POIGNEE_TYPE!=null && POIGNEE_TYPE.getTypedefelement()!=null) {
				String key = POIGNEE_TYPE.getTypedefelement().getKey();

				if(key!=null && !key.isEmpty()) {
					item.addAttribute(POIGNEE_TYPE.getTypedef().getKey(), key);
					if("SANS_POIGNEE".contentEquals(key)) {
						if(gola_Type!=null && gola_Type.getTypedefelement()!=null) {
							String golaKey = gola_Type.getTypedefelement().getKey();
							item.addAttribute(gola_Type.getTypedef().getKey(), golaKey);
						}
					}
				}
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	/**
	 * @param item
	 * @param design
	 */
	public void addMechanicDesignTags(PaletteItem item, MechanicDesign design) {
		try {
			MechanicPublicParam souPlaque = design.getPublicParam("Plaque_exist");
			if(souPlaque!=null && souPlaque.getTypedefelement()!=null) {
				String key = souPlaque.getTypedefelement().getKey();
				if(key!=null && !key.isEmpty()) {
					boolean isplaque=Boolean.valueOf(key);
					if(isplaque) {
						item.addTag("Sous plaque");
					}
				}
						
			}
			MechanicPublicParam anglaise = design.getPublicParam("is_anglai");
			if(anglaise!=null && anglaise.getTypedefelement()!=null) {
				String key = anglaise.getTypedefelement().getKey();
				if(key!=null && !key.isEmpty()) {
					boolean isplaque=Boolean.valueOf(key);
					if(isplaque) {
						item.addTag("A l'anglaise");
					}
				}
						
			}
			MechanicPublicParam portType = design.getPublicParam("NB_TIROIR");
			if(portType!=null && portType.getDefaultvalue()!=null && !portType.getDefaultvalue().isEmpty()) {

				Integer isplaque = Integer.valueOf(portType.getDefaultvalue());
				item.addTag(isplaque + " Tiroir");

			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}
	/**
	 * @param design
	 * @param item
	 */
	public void createDesignGroupImage(MechanicDesignGroup group, PaletteGroup item) {
		String path=group.getPerviewPath();
		fixPaletteGroupPreviewPath(item, path);
	}
	/**
	 * @param group
	 * @param path
	 */
	public void fixPaletteGroupPreviewPath(PaletteGroup group, String path) {
		boolean isvalidImage=false;
		if (path != null && !path.isEmpty()) {

			if (!ImageLoaderCache.isValidImagePath(path)) {
				path = WorkspaceConfiguration.getIconsPath() + File.separator + path;
			}
			group.setImage(path);
			isvalidImage=ImageLoaderCache.isValidImagePath(path);
		}
		
		if(!isvalidImage){
			group.setImage(WorkspaceConfiguration.getIconsPath() + File.separator + DEFAULT_FOLDER_ICON);
			if(group.getData()!=null && group.getData() instanceof MechanicDesign design) {
				design.setPreviewImagePath(null);
				DesignPreviewGenerator.getInstance().addItemToUpdate(group.getData());
			}
		}
	}
	
	/**
	 * @param design
	 * @param item
	 */
	public void createDesignImage(MechanicDesign design, PaletteItem item) {
		String path=design.getPreviewImagePath();
		fixItemPreviewPath(item, path);
	}
	/**
	 * @param design
	 * @param item
	 */
	public void createDesignInstanceImage(DesignInstance design, PaletteItem item) {
		String path=design.getPerviewPath();
		fixItemPreviewPath(item, path);
	}
	/**
	 * @param design
	 * @param item
	 */
	public void createDesignOptionImage(Option option, PaletteItem item) {
		String path=option.getPreviewImagePath();
		fixItemPreviewPath(item, path);
	}
	/**
	 * @param item
	 * @param path
	 */
	public void fixItemPreviewPath(PaletteItem item, String path) {
		boolean isvalidImage=false;
		if (path != null && !path.isEmpty()) {

			if (!ImageLoaderCache.isValidImagePath(path)) {
				path = WorkspaceConfiguration.getIconsPath() + File.separator + path;
			}
			item.setImage(path);
			isvalidImage=ImageLoaderCache.isValidImagePath(path);
		} 
		if(!isvalidImage){
			item.setImage(WorkspaceConfiguration.getIconsPath() + File.separator + DEFAULT_MODEL_ICON);

			DesignPreviewGenerator.getInstance().addItemToUpdate(item.getData());
		}
	}
	

	public void dispose() {
		DesignPreviewGenerator.getInstance().dispose();
	}
	@Override
	public void handle(Event event) {
		Display.getDefault().asyncExec(new Runnable() {

			@Override
			public void run() {
				TimeProfiler.getInstance().start("3DPalette");
				updateModels3DPalette();
				TimeProfiler.getInstance().stop("3DPalette");
			}
		});
		
	}
}
