package dressing.ui.palette;

import java.util.ArrayList;
import java.util.List;

public class PaletteGroup extends PaletteItem{
	private final ArrayList<PaletteItem> items = new ArrayList<PaletteItem>();
	private final List<PaletteGroup> palettegroupes = new ArrayList<PaletteGroup>();

	public PaletteGroup() {
		// TODO Auto-generated constructor stub
	}

	public PaletteGroup(String name) {
		super(name);
	}

	public ArrayList<PaletteItem> getItems() {
		return items;
	}

	public List<PaletteGroup> getPalettegroupes() {
		return palettegroupes;
	}
	
	public List<Object> getPaletteItems(){
		List<Object> items=new ArrayList<Object>();
		items.addAll(getPalettegroupes());
		items.addAll(getItems());
		return items;
	}
	
	public void addPaletteGroup(PaletteGroup group) {
		if(group.getParent()!=null) {
			group.getParent().removePaletteGroup(group);	
		}
		getPalettegroupes().add(group);
		group.setParent(this);
	}
	
	public void removePaletteGroup(PaletteGroup group) {
		getPalettegroupes().remove(group);
		group.clear();
		group.setParent(null);
		
	}
	public void clear() {
		List<PaletteGroup> childGroups=new ArrayList<PaletteGroup>();
		childGroups.addAll(getPalettegroupes());
		for(PaletteGroup childGroup:childGroups) {
			removePaletteGroup(childGroup);
		}
		List<PaletteItem> childItems=new ArrayList<PaletteItem>();
		childItems.addAll(getItems());
		for(PaletteItem childItem:childItems) {
			removePaletteItem(childItem);
		}
	}
	public void addPaletteItem(PaletteItem item) {
		getItems().add(item);
		item.setParent(this);
	}
	public void removePaletteItem(PaletteItem item) {
		getItems().remove(item);
		item.setParent(null);
	}
	
}
