package dressing.ui.palette;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.SWTResourceManager;

import dressing.profiling.TimeProfiler;

public final class ImageToolTipManager {

    private static final String KEY =
            ImageToolTipManager.class.getName();

    public static ImageToolTipManager get(Display display) {
        ImageToolTipManager manager =
                (ImageToolTipManager) display.getData(KEY);

        if (manager == null) {
            manager = new ImageToolTipManager(display);
            display.setData(KEY, manager);

            display.disposeExec(manager::dispose);
        }

        return manager;
    }
    public static ImageToolTipManager createImageToolTipManager(Display display) {
    	ImageToolTipManager manager = new ImageToolTipManager(display);
    	display.disposeExec(manager::dispose);
    	return manager;
    }
    // --------------------------------------------------------------------

    private final Shell tooltipShell;
    private final Label imageLabel;

    private Image currentImage;
	private Label lblText;

    private ImageToolTipManager(Display display) {
        tooltipShell = new Shell(display, SWT.ON_TOP | SWT.NO_FOCUS | SWT.TOOL);
        tooltipShell.setLayout(new GridLayout(1,true));

        imageLabel = new Label(tooltipShell, SWT.NONE);
        lblText = new Label(tooltipShell, SWT.WRAP | SWT.CENTER);
        GridData lbltxtData= new GridData(SWT.FILL, SWT.BOTTOM, true, false);
        lbltxtData.widthHint=750;
        lblText.setLayoutData(lbltxtData);
        lblText.setFont(SWTResourceManager.getFont("Times New Roman (Titres CS)", 18, SWT.BOLD) );
        lblText.setText("");

    }

    public void show(Button anchor, Image image,String labelText) {
        if (tooltipShell.isDisposed()) {
            return;
        }

        if (imageLabel.getImage() != image) {
//        	if(imageLabel!=null && !imageLabel.isDisposed() && imageLabel.getImage()!=null && !imageLabel.getImage().isDisposed()) {
//            	imageLabel.getImage().dispose();
//            }
            imageLabel.setImage(image);
          
        }
        lblText.setText(labelText == null ? "" : labelText);
        currentImage = image;
        positionAndShow(anchor);

    }
    // --------------------------------------------------------------------
    // Integrated positioning logic (from your original method)
    // --------------------------------------------------------------------

    private void positionAndShow(Button anchor) {
        Display display = anchor.getDisplay();
        Shell parentShell = anchor.getShell();

        // Cursor position (display coordinates)
        Point cursor = display.getCursorLocation();

        // Preferred offset from cursor
        int x = cursor.x + 12;
        int y = cursor.y + 12;

        // Compute tooltip size
        tooltipShell.pack();
        Rectangle tipBounds = tooltipShell.getBounds();

        // Parent shell client area (display coordinates)
        Rectangle clientArea = parentShell.getClientArea();
        Point shellOrigin =
                parentShell.toDisplay(clientArea.x, clientArea.y);

        Rectangle shellBounds = new Rectangle(
                shellOrigin.x,
                shellOrigin.y,
                clientArea.width,
                clientArea.height
        );

        // Clamp X
        if (x + tipBounds.width > shellBounds.x + shellBounds.width) {
            x = cursor.x - tipBounds.width - 12;
        }
        if (x < shellBounds.x) {
            x = shellBounds.x;
        }

        // Clamp Y
        if (y + tipBounds.height > shellBounds.y + shellBounds.height) {
            y = shellBounds.y + shellBounds.height - tipBounds.height - 15;
        }
        if (y < shellBounds.y) {
            y = shellBounds.y;
        }

        tooltipShell.setLocation(x, y);
        tooltipShell.setVisible(true);
        tooltipShell.forceActive();
    }
	
    public void hide() {

        if (!tooltipShell.isDisposed()) {
            tooltipShell.setVisible(false);
        }
//        if(currentImage!=null && !currentImage.isDisposed())
//        {
//        	currentImage.dispose();
//        }

    }

    private void dispose() {
        if (!tooltipShell.isDisposed()) {
            tooltipShell.dispose();
            if(currentImage!=null && !currentImage.isDisposed())
            {
            	currentImage.dispose();
            }
            if(imageLabel!=null && !imageLabel.isDisposed() && imageLabel.getImage()!=null && !imageLabel.getImage().isDisposed()) {
            	imageLabel.getImage().dispose();
            }
            
        }
    }
}
