package dressing.ui.palette;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

import dressing.ui.util.ImageLoaderCache;
import param.DesignInstance;
import param.MechanicDesign;

public class DesignApplicationPaletteComposite extends PaletteComposite {
    private final List<DesignApplicationSelectionListener> selectionListeners = new ArrayList<DesignApplicationSelectionListener>();

	/**
	 * Create the composite.
	 * @param parent
	 * @param style
	 */
	public DesignApplicationPaletteComposite(Composite parent, int style,
            IEventBroker eventBroker,
            ESelectionService selectionService,PaletteProvider paletteProvider) {
		super(parent, style, eventBroker, selectionService, paletteProvider);

	}

	protected void hookSelection(Button button, Object selectionData) {
		if (selectionData == null) {
			return;
		}
		button.addListener(SWT.MouseDoubleClick, new Listener() {

			@Override
			public void handleEvent(Event event) {
				MechanicDesign design=null;
				if (selectionData instanceof MechanicDesign) {
					design = (MechanicDesign) selectionData;
				}
				if (selectionData instanceof DesignInstance) {
					design = ((DesignInstance) selectionData).getDesign();
				}
				if(design!=null)
				{
					fireGroupSelectedApply(design);
				}

			}
		});
		;
		button.addListener(SWT.MouseDown, new Listener() {

			@Override
			public void handleEvent(Event event) {
				MechanicDesign design=null;
				if (selectionData instanceof MechanicDesign) {
					design = (MechanicDesign) selectionData;
				}
				if (selectionData instanceof DesignInstance) {
					design = ((DesignInstance) selectionData).getDesign();
				}
				if(design!=null)
				{
					fireGroupSelected(design);
				}
			}
		});
	}
	/**
     * Attach the shared Image tooltip for this display.
     */
	@Override
    protected void attachToolTip(Button button, PaletteItem item) {
		
    }
	 /**
     * Ajoute un listener de sélection de groupe.
     */
    public void addDesignApplicationSelectionListener(DesignApplicationSelectionListener listener) {
        if (listener != null && !selectionListeners.contains(listener)) {
            selectionListeners.add(listener);
        }
    }
    
    /**
     * Notifie les listeners d’un changement de groupe.
     */
    private void fireGroupSelected(MechanicDesign design) {
        for (DesignApplicationSelectionListener listener : selectionListeners) {
            listener.designSelected(design);
        }
    }
    /**
     * Notifie les listeners d’un changement de groupe.
     */
    private void fireGroupSelectedApply(MechanicDesign design) {
        for (DesignApplicationSelectionListener listener : selectionListeners) {
            listener.designSelectedApply(design);
        }
    }
    
	@Override
	protected void hookModelRefresh() {
		

	}
	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}

}
