package dressing.ui.emf.MechanicdesignLibrary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.IStructuredContentProvider;

import dressing.model.ModelProvider;
import gdxapp.object3d.WorldObject;
import param.DesignClasse;
import param.MechanicDesign;
import param.MechanicDesignGroup;
import param.Option;

public class ModelEMFContentProvider implements IStructuredContentProvider{
	
	private static ModelEMFContentProvider instance ;
	public static ModelEMFContentProvider getInstance() {
		synchronized(ModelEMFContentProvider.class) {
			if (instance == null) {
				instance = new ModelEMFContentProvider();
			}
			return instance;
		}
	}
	
	@Override
	public Object[] getElements(Object inputElement) {
		List<Object> contents=new ArrayList<Object>();
		if(inputElement instanceof List) {
			if(inputElement!=null && ((List)inputElement).size()>0) {
				List elements=(List)	inputElement;
				for(Object object:elements) {
					if(object instanceof WorldObject) {
						contents.add(object);
					}
					if(object instanceof MechanicDesign) {
						addMechanicDesignOption((MechanicDesign) object, contents);
					}
					if(object instanceof MechanicDesignGroup) {
						addMechanicDesignGroupOption((MechanicDesignGroup) object, contents);
					}
					if(object instanceof DesignClasse) {
						addMechanicDesignClassOption((DesignClasse) object, contents);
						
					}
					if(object instanceof String) {
						contents.addAll(ModelProvider.getDesignObjectsByCategory((String) object));
					}
					if(object instanceof Option) {
						contents.add(object);
					}
					
				}

			}
		}else {
			if(inputElement instanceof MechanicDesign) {
				addMechanicDesignOption((MechanicDesign) inputElement, contents);
			}
			if(inputElement instanceof MechanicDesignGroup) {
				addMechanicDesignGroupOption((MechanicDesignGroup) inputElement, contents);
			}
			if(inputElement instanceof DesignClasse) {
				addMechanicDesignClassOption((DesignClasse) inputElement, contents);
			}
			if(inputElement instanceof String) {
				contents.addAll(ModelProvider.getDesignObjectsByCategory((String) inputElement));
			}
		}
		
		
		return contents.toArray();
		
	}
	
	public void addMechanicDesignOption(MechanicDesign design,List<Object> contents){
		EList<Option> o=	design.getOptions().getOptions();
		contents.addAll((Collection<? extends Option>) o.stream().filter(o1 ->o1.isPublic()).toList());
		
		
	}
	
	public void addMechanicDesignGroupOption(MechanicDesignGroup designGroup,List<Object> contents){
		if(designGroup != null ) {
			if(designGroup.getMechanicdesign()!=null && !designGroup.getMechanicdesign().isEmpty()) {
				for(MechanicDesign design : designGroup.getMechanicdesign()) {
					if(design.isPublic())
					{
						addMechanicDesignOption(design, contents);
					}
				}
			}
		}
		
	}
	
	public void addMechanicDesignClassOption(DesignClasse designClass,List<Object> contents){
		if(designClass != null ) {
			if(designClass.getCategorie()!=null && !designClass.getCategorie().isEmpty()) {
				for(MechanicDesignGroup design : designClass.getCategorie()) {
					if(design.isPublic())
					{
						addMechanicDesignGroupOption(design, contents);
					}
				}
			}
			contents.addAll(ModelProvider.getDesignObjects(designClass.getName()));
		}
		
	}
	
}
