package dressing.ui.editorWindows;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import dressing.config.persistence.ResourceManagers;
import dressing.model.ModelProvider;
import dressing.ui.DoubleTextFieldFactory;
import dressing.ui.MecahnicDesignAccesoireComposite;
import dressing.ui.PublicParamEditorComposite;
import dressing.ui.util.DoubleToStringConvertor;
import dressing.ui.util.EditorWindow;
import param.MechanicDesign;
import param.MechanicPublicParam;
import param.Option;
import param.ParamFamily;
import param.ParamFamilyGroup;
import param.PublicParamGroup;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.widgets.Button;
import org.eclipse.wb.swt.SWTResourceManager;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import dressing.ui.util.NumericConvertor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;

public class designOptionEditorWindow extends EditorWindow {
	
	private DataBindingContext m_bindingContext;

	private ScrolledComposite container;
	private Composite root;

	private Text txtName;
	private Text txtCode;
	private Text txtPrice;
	private MechanicDesign design;

	private Option option;
	private Option optionOrigin;
	private Label lblLabel;
	private Text txtLabel;
	private Label lblPublic;
	private Button btnPublic;
	private CTabFolder tabFolder;
	private CTabItem tbtmGnral;
	private Composite composite;
	private CTabItem tbtmParamtres;
	private CTabItem tbtmArticles;
	
	private ScrolledComposite general_scrolledComposite;
	private Composite composite_general;
	private Map<MechanicPublicParam,PublicParamEditorComposite> dirtyParams=new HashMap<MechanicPublicParam,PublicParamEditorComposite>();
	private Map<MechanicPublicParam,PublicParamEditorComposite> ParamsCompositeMap=new HashMap<MechanicPublicParam,PublicParamEditorComposite>();

	private Text txtRemise;

	private Text txtMaxRemise;

	private Text txtTva;

	public designOptionEditorWindow(Shell parentShell,int update,Option article) {
		super(parentShell,update);
		this.option = article;
		this.optionOrigin=EcoreUtil.copy(article);
		this.design=this.option.getDesign();
	}

	@Override
	protected Composite createClientArea(Composite parent) {
		parent.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		
		container = new ScrolledComposite(parent, SWT.V_SCROLL);
		container.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		container.setExpandHorizontal(true);
		container.setExpandVertical(true);
		
		root = new Composite(container, SWT.NONE);
		root.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		root.setLayout(new GridLayout(1, false));
		
		tabFolder = new CTabFolder(root, SWT.BORDER);
		tabFolder.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		tabFolder.setSimple(false);
		tabFolder.setMinimizeVisible(true);
		tabFolder.setMaximized(true);
		tabFolder.setMaximizeVisible(true);
		tabFolder.marginHeight = 5;
		tabFolder.marginWidth = 5;
		tabFolder.setFont(SWTResourceManager.getFont("Times New Roman", 12, SWT.NORMAL));
		tabFolder.setMRUVisible(true);
		tabFolder.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		tabFolder.setSelectionBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_BACKGROUND));
		
		tbtmGnral = new CTabItem(tabFolder, SWT.NONE);
		tbtmGnral.setText("Général");
		tbtmGnral.setFont(SWTResourceManager.getFont("Times New Roman (Titres CS)", 14, SWT.BOLD));

		composite = new Composite(tabFolder, SWT.NONE);
		composite.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		tbtmGnral.setControl(composite);
		composite.setLayout(new GridLayout(2, false));
		
		Label lblNom = new Label(composite, SWT.NONE);
		lblNom.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		lblNom.setText("Désignation");
		
		txtName = new Text(composite, SWT.BORDER);
		txtName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		lblLabel = new Label(composite, SWT.NONE);
		lblLabel.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		lblLabel.setText("Label");
		lblLabel.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));

		txtLabel = new Text(composite, SWT.BORDER);
		txtLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblCode = new Label(composite, SWT.NONE);
		lblCode.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		lblCode.setText("Référence");
		lblCode.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));

		txtCode = new Text(composite, SWT.BORDER);
		txtCode.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblPrice = new Label(composite, SWT.NONE);
		lblPrice.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		lblPrice.setText("Prix");
		lblPrice.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));

		txtPrice = DoubleTextFieldFactory.createDoubleTextField(composite, SWT.BORDER);
		txtPrice.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		//
		Label lblRemise = new Label(composite, SWT.NONE);
		lblRemise.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		lblRemise.setText("Remise");
		lblRemise.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));

		txtRemise = DoubleTextFieldFactory.createDoubleTextField(composite, SWT.BORDER);
		txtRemise.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		//
		//
		Label lblMaxRemise = new Label(composite, SWT.NONE);
		lblMaxRemise.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		lblMaxRemise.setText("Max Remise");
		lblMaxRemise.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));

		txtMaxRemise = DoubleTextFieldFactory.createDoubleTextField(composite, SWT.BORDER);
		txtMaxRemise.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		//
		//
		Label lblTva = new Label(composite, SWT.NONE);
		lblTva.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		lblTva.setText("TVA");
		lblTva.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));

		txtTva = DoubleTextFieldFactory.createDoubleTextField(composite, SWT.BORDER);
		txtTva.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		//
		lblPublic = new Label(composite, SWT.NONE);
		lblPublic.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		lblPublic.setText("Public");
		lblPublic.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));

		btnPublic = new Button(composite, SWT.CHECK);
		btnPublic.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		btnPublic.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		createGeneralTab();
		
		createArticlesTab();

		container.setContent(root);
		String titleWindow = "d'Option Elément";


		this.shell.setText("Editeur " + titleWindow+": "+option.getName());
		shell.redraw();
		parent.requestLayout();

		m_bindingContext = initDataBindings();

		addControl(); 
		return container;
	}
	
	protected Composite createGeneralTab() {
		tbtmParamtres = new CTabItem(tabFolder, SWT.NONE);
		tbtmParamtres.setFont(SWTResourceManager.getFont("Times New Roman (Titres CS)", 14, SWT.BOLD));
		tbtmParamtres.setText("Paramètres");
		//
		general_scrolledComposite = new ScrolledComposite(tabFolder, SWT.H_SCROLL | SWT.V_SCROLL);
		general_scrolledComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		general_scrolledComposite.setExpandHorizontal(true);
		general_scrolledComposite.setExpandVertical(true);
		composite_general = new Composite(general_scrolledComposite, SWT.FILL);
		composite_general.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		GridData gd_composite_1 = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		gd_composite_1.heightHint = 558;
		composite_general.setLayoutData(gd_composite_1);
		composite_general.setLayout(new GridLayout(2, false));
		if(design!=null && design.getPublicparamgroup()!=null) {
			List<MechanicPublicParam> params=new ArrayList<MechanicPublicParam>();
			params.addAll(design.getPublicparamgroup().getMechanicpublicparam());
			createFamiliesGroup(composite_general, params, design.getPublicparamgroup());
			List<MechanicPublicParam> remainingParams=new ArrayList<MechanicPublicParam>();

			//filter
			for(MechanicPublicParam param:params) {
				if(param!=null&&param.isChangeable()) {
//					if(param.getKey().contentEquals("SEPRATEUR_TRANSVERSANT")&& this.update==MechanicDesignCreator.update && !ismodel){
//					}else {
						remainingParams.add(param);
//					}
				 }
			}
			if(!remainingParams.isEmpty()) {
				
				Group gr=new Group(composite_general, SWT.BORDER | SWT.SHADOW_ETCHED_IN);
				gr.setLayout(new GridLayout(3, false));
				gr.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 1, 1));
				gr.setText("Autre");
				gr.setBackground(composite_general.getBackground());
				for(MechanicPublicParam param:remainingParams) {
					if(param.getDefaultvalue()!=null && !param.getDefaultvalue().isEmpty() && param.getDefaultvalue().contains("@")) {
						continue;
					}
					PublicParamEditorComposite paramEditor=new PublicParamEditorComposite(gr, SWT.NONE, param,dirtyParams,PublicParamEditorComposite.SHOW_LABEL,PublicParamEditorComposite.SHOW_BUTTON_CHANGEABLE); 
					ParamsCompositeMap.put(param, paramEditor);
				}
				gr.setSize(gr.computeSize(SWT.DEFAULT, SWT.DEFAULT));

			}
			
		}
		

		general_scrolledComposite.setContent(composite_general);
		general_scrolledComposite.setSize(composite_general.computeSize(SWT.MIN, SWT.MIN));
		general_scrolledComposite.setMinSize(composite_general.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		tbtmParamtres.setControl(general_scrolledComposite);
		composite_general.pack();
		updateOptionParams();
		return composite_general;
	}
	protected void updateOptionParams() {
		for(MechanicPublicParam param : option.getInjectedPublicParam().getMechanicpublicparam()) {
			try {
				MechanicPublicParam publicParam = design.getPublicParam(param.getKey());
				if(publicParam!=null) {
					PublicParamEditorComposite publicParamComposite =ParamsCompositeMap.get(publicParam);
					if(publicParamComposite!=null)
					{
						publicParamComposite.setValues(param, false);
					}else {
						System.err.println("design "+design.getName()+" option"+option.getName()+ "design ParamsCompositeMap don't have param"+param.getKey());
					}
				}else {
					System.err.println("design don't have param"+param.getKey());
				}
				
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
	}
	public void updateParamValues() {
		for(MechanicPublicParam designParam : dirtyParams.keySet()) {
			MechanicPublicParam optionParam = option.getInjectedPublicParam().getParam(designParam.getKey());
			if(optionParam==null) {
				optionParam = EcoreUtil.copy(designParam);
				option.getInjectedPublicParam().getMechanicpublicparam().add(optionParam);
			}
			dirtyParams.get(designParam).updateValues(optionParam);

		}
	}
	protected void createFamiliesGroup(Composite parent ,List<MechanicPublicParam> params,PublicParamGroup paramGroup) {
		Map<ParamFamily,List<Object>> famParams=new HashMap<ParamFamily, List<Object>>();
		ParamFamilyGroup famGroup=ModelProvider.getModelroot().getParametersFamilies();
		if(famGroup!=null && !famGroup.getFamilies().isEmpty()) {
			for(ParamFamily fam:famGroup.getFamilies()) {
				List<Object> famchilds =collectFamilyGroup(fam, params, paramGroup);
				if(famchilds!=null && !famchilds.isEmpty()) {
					famParams.put(fam, famchilds);
				}
			}
			createFamilyGroup(famParams,famGroup.getFamilies(),parent);
		}
	}
	
	private void createFamilyGroup(Map<ParamFamily, List<Object>> famchilds, EList<ParamFamily> families, Composite parent) {
		if(!famchilds.isEmpty()) {
			for(ParamFamily family:families) {
				if(famchilds.containsKey(family)) {
					Group gr=new Group(parent, SWT.BORDER | SWT.SHADOW_ETCHED_IN);
					gr.setLayout(new GridLayout(3, false));
					gr.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 1, famchilds.get(family).size()/2));
					gr.setText(family.getLabel());
					gr.setBackground(parent.getBackground());
					for(Object child:famchilds.get(family)) {
						if(child instanceof MechanicPublicParam) {
							MechanicPublicParam param=(MechanicPublicParam) child;
							if(param.getDefaultvalue()!=null && !param.getDefaultvalue().isEmpty() && param.getDefaultvalue().contains("@")) {
								continue;
							}
							PublicParamEditorComposite paramEditor = new PublicParamEditorComposite(gr, SWT.NONE, param,dirtyParams,PublicParamEditorComposite.SHOW_LABEL,PublicParamEditorComposite.SHOW_BUTTON_CHANGEABLE);
							ParamsCompositeMap.put(param, paramEditor);
						}else if(child instanceof Map) {
							createFamilyGroup((Map<ParamFamily, List<Object>>) child,family.getSubFamilies(), gr);
						}
					}
					gr.setSize(gr.computeSize(SWT.DEFAULT, SWT.DEFAULT));
				}
				
			}
		}
		
	}
	protected List<Object> collectFamilyGroup(ParamFamily family,List<MechanicPublicParam> params,PublicParamGroup paramGroup) {
		List<Object> childs=new ArrayList<Object>();
		if(!family.getKeys().isEmpty()) {
			List<MechanicPublicParam> familyparams=new ArrayList<MechanicPublicParam>();
			for(String key:family.getKeys()) {
				try {
					MechanicPublicParam param=	paramGroup.getParam(key);
					if(param!=null && params.contains(param)&& param.isChangeable()) {
						familyparams.add(param);
						params.remove(param);
					}
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			if(!familyparams.isEmpty()) {
				childs.addAll(familyparams);
			}
			

		}
		if(family.getSubFamilies()!=null && !family.getSubFamilies().isEmpty()) {
			Map<ParamFamily,Object> famParams=new HashMap<ParamFamily, Object>();
			for(ParamFamily fam:family.getSubFamilies()) {
				List<Object> famchilds=collectFamilyGroup(fam, params, paramGroup);
				if(famchilds!=null) {
					famParams.put(fam,famchilds);
				}
			}
			if(!famParams.isEmpty()) {
				childs.add(famParams);
			}
		}
		if(childs.isEmpty()) {
			return null;
		}
		 
		return childs;
	}
	protected CTabItem createArticlesTab() {
		tbtmArticles = new CTabItem(tabFolder, SWT.NONE);
		tbtmArticles.setFont(SWTResourceManager.getFont("Times New Roman (Titres CS)", 14, SWT.BOLD));
		String tabName="Accessoires et Quincaillerie";
		
		tbtmArticles.setText(tabName);
		//

		MecahnicDesignAccesoireComposite composite_Articles = new MecahnicDesignAccesoireComposite(tabFolder,this.option.getQuincailleries(),this.option.getAccessoires(), SWT.FILL);
		
		GridData gd_composite_1 = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		composite_Articles.setLayoutData(gd_composite_1);
		composite_Articles.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));

		tbtmArticles.setControl(composite_Articles);
		composite_Articles.pack();
		return tbtmArticles;
	}
	public void addControl() {

	}
	@Override
	public boolean terminer() {
		if(!super.terminer()) {
			return false;
		}
		updateParamValues();
		ResourceManagers.getIntance().saveLibraryResource();

		finish();
		return true;
	}
	
	@Override
	public boolean check() {
		errorExist=false;
		errorMessage="";
		String name =txtName.getText().trim();
		if(name==null || name.isEmpty()) {
			errorExist=true;
			errorMessage="Le nom est obligatoire";
		}
		String priceS=txtPrice.getText();
		try {
			Double priceD =Double.valueOf(priceS);
//			if(priceD<=0) {
//				errorExist=true;
//				errorMessage="Le prix doit être supérieur à 0";
//			}
		} catch (Exception e) {
			errorExist=true;
			errorMessage="Le prix est obligatoire";
		}
		
		return !errorExist;
	}
	public ScrolledComposite getContainer() {
		return container;
	}

	public void setContainer(ScrolledComposite container) {
		this.container = container;
	}

	public Composite getRoot() {
		return root;
	}

	public void setRoot(Composite root) {
		this.root = root;
	}
	
	@Override
	protected void cancel() {

		
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeTextTxtNameObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtName);
		IObservableValue nameAccessoireObserveValue = BeanProperties.value("name").observe(option);
		bindingContext.bindValue(observeTextTxtNameObserveWidget, nameAccessoireObserveValue, null, null);
		//
		IObservableValue observeTextTxtCodeObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtCode);
		IObservableValue codeAccessoireObserveValue = BeanProperties.value("code").observe(option);
		bindingContext.bindValue(observeTextTxtCodeObserveWidget, codeAccessoireObserveValue, null, null);
		//
		IObservableValue observeTextTxtPriceObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtPrice);
		IObservableValue prixAccessoireObserveValue = BeanProperties.value("price").observe(option);
		UpdateValueStrategy strategy = new UpdateValueStrategy();
		strategy.setConverter(new DoubleToStringConvertor());
		UpdateValueStrategy strategy_1 = new UpdateValueStrategy();
		strategy_1.setConverter(new NumericConvertor());
		bindingContext.bindValue(observeTextTxtPriceObserveWidget, prixAccessoireObserveValue, strategy, strategy_1);
		//
		IObservableValue observeTextTxtRemiseObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtRemise);
		IObservableValue remiseOptionObserveValue = BeanProperties.value("remise").observe(option);
		bindingContext.bindValue(observeTextTxtRemiseObserveWidget, remiseOptionObserveValue, strategy, strategy_1);
		//
		IObservableValue observeTextTxtMaxRemiseeObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtMaxRemise);
		IObservableValue maxRemiseOptionObserveValue = BeanProperties.value("maxRemise").observe(option);
		bindingContext.bindValue(observeTextTxtMaxRemiseeObserveWidget, maxRemiseOptionObserveValue, strategy, strategy_1);
		//
		IObservableValue observeTextTxtTvaObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtTva);
		IObservableValue tvaOptionObserveValue = BeanProperties.value("tva").observe(option);
		bindingContext.bindValue(observeTextTxtTvaObserveWidget, tvaOptionObserveValue, strategy, strategy_1);
		//
		IObservableValue observeTextTxtLabelObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtLabel);
		IObservableValue labelOptionObserveValue = BeanProperties.value("label").observe(option);
		bindingContext.bindValue(observeTextTxtLabelObserveWidget, labelOptionObserveValue, null, null);
		//
		//
		IObservableValue observeSelectionBtnPublicObserveWidget = WidgetProperties.buttonSelection().observe(btnPublic);
		IObservableValue publicOptionObserveValue = org.eclipse.core.databinding.beans.typed.BeanProperties.value("public").observe(option);
		bindingContext.bindValue(observeSelectionBtnPublicObserveWidget, publicOptionObserveValue, null, null);
		//

		return bindingContext;
	}
}
