package dressing.ui;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import dressing.model.ProjectManager;


public class ProgressBarMonitor {
	
	private static ProgressBarComposite  bar;
	private static boolean constructed = false;
	
	
	
	@PostConstruct
	void createControl(Composite parent, MToolControl control) {
		bar = new ProgressBarComposite(parent, SWT.NONE);
		constructed = true;
	}

	public static void setTasks(int tasks) {
		if(constructed)
			bar.setTasksCount(tasks);
	}
	
	public static void advance(int steps) {
		if(constructed)
			bar.advance(steps);
	}
	
	public static void labelTask(String taskName) {
		if(constructed)
			bar.setTask(taskName);
	}
	
	@PreDestroy
	public void dispose() {
		ProjectManager.getManager().dispose();
	}
}


