package dressing.ui.Control;

import javax.annotation.PostConstruct;

import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

import dressing.config.ReportingPreferences;
import dressing.events.Event;
import dressing.events.EventHandler;
import dressing.model.DesignObject3D;
import dressing.model.MechanicDesignCreator;
import dressing.model.Piece2D;
import dressing.model.Space3D;
import dressing.ui.MechaincDesignEditorWindow;
import dressing.ui.caisson.ElementFacadeConfigWindow;
import dressing.ui.parts.GdxPart;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.GeometricObjectConfigWindow;
import dressing.ui.util.MesureWidow;
import dressing.ui.util.ModelInstanceEditorWindow;
import dressing.ui.util.PlinthCreationWindow;
import dressing.ui.util.WallSettingWindow;
import gdxapp.object3d.GeometryObject;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.PlinthObject;
import gdxapp.object3d.Wall;
import gdxapp.object3d.WorldObject;
import gdxapp.object3d.WorldObject.ObjectType;
import gdxapp.scenes.SceneEvent;
import param.DirectionDelimiterMap;
import param.MechanicDesign;

@Creatable
public class ConfigWindowsInvoker implements EventHandler {
	
	
	public ConfigWindowsInvoker() {}
	
	@PostConstruct
	void init() {
		subscribe(SceneEvent.MODIFY_OBJECT.name(), SceneEvent.EDIT_OBJECT.name());
	}

	@Override
	public void handle(Event event) {
		String topic = event.getTopic();
		try {
			WorldObject object = (WorldObject) event.getData();
			openConfigWindow(object, topic);
		}catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	
	public void openConfigWindow(WorldObject object, String topic) {
		Display.getDefault().asyncExec(() -> {
				if(object instanceof Wall) {
						invokeWallSettingWindow((Wall) object);
				}else if(object instanceof PlinthObject){
					invokePlinthCreationWindow((PlinthObject) object);
				}else if(object instanceof GeometryObject) {
					invokeGeometryObjectConfigWindow((GeometryObject) object);
				}else if(object instanceof KitchenElement) {
					if(topic.equals(SceneEvent.MODIFY_OBJECT.name())) {
						invokeMeasureWindow((KitchenElement) object);
					}else {
						invokeElementFacadeConfigWindow((KitchenElement) object);
					}
				}else if(object.getType() == ObjectType.MODELED) {
					invokeModelInstanceEditorWindow(object);
				}
		});
	}
	
	public void invokeMeasureWindow(KitchenElement element) {
		boolean useMechanicDesignWindow = ReportingPreferences.getInstance().getProperty("ui.useMechanicDesignWindow", false);
		if(useMechanicDesignWindow) {
			DesignObject3D DesignObject = (DesignObject3D) element.getDesignObject();
			if (DesignObject != null ) {

				try {
					MechanicDesign design= DesignObject.getMechanicDesignDefinition();
					design.setFacadeMaterialFree(true);
					design.setPrincipalMaterialFree(true);
					design.setSecondMaterialFree(true);
					design.setChantFacadeFree(true);
					design.setChantElementFree(true);
			    	if(design.isChangeable()) {

						if(DesignObject instanceof Piece2D && !design.getType().equals(param.PieceType.PIECE2D)) {
							DesignObject=DesignObject.getParentdesign();
						}
						DesignObject3D space=DesignObject.getParentdesign();
						boolean isdirectParent=true;
						DirectionDelimiterMap spacedelimeters=null;
						if(space!=null && space.getRootModule()!=null)
						{
							spacedelimeters = ((Space3D) space.getRootModule()).getDependenceController().getChainModel().getDesignsReferences().get(design);
	    					DesignObject3D spaceParent = ((Space3D) space.getRootModule()).getDependenceController().createConstraintSpace(spacedelimeters, space,false);
	    					//make temporary space directPArent for test  purposes
	    					if(spaceParent!=null) {
	    						isdirectParent=false;
	    						space=spaceParent;
	    					}
						}
						
						
						MechaincDesignEditorWindow mechanicDesignWindow=new MechaincDesignEditorWindow(GdxPart.parentShell,design,false,null, space,DesignObject, spacedelimeters,isdirectParent, MechanicDesignCreator.update);
						mechanicDesignWindow.create();
						mechanicDesignWindow.open();
			    	}else {
			    		MessageDialog.openWarning(GdxPart.parentShell, "Imposissible de modifier", "Imposissible de modifier le modele séléctionner");
			    	}
				} catch (Exception e) {
					MessageDialog.openError(GdxPart.parentShell, "Erreur lors du modification du model",
							"Erreur lors du modification du model" + DesignObject.getName());
					e.printStackTrace();
				}
			}
		}else {
			MesureWidow mesureWidow = MesureWidow.getInstance();
			mesureWidow.setKitchenElemtn(element);
			mesureWidow.show();
		
		}

	}
	
	public void invokeWallSettingWindow(Wall wall) {
		Shell shell = new Shell(Display.getDefault());
		WallSettingWindow window = new WallSettingWindow(shell, wall);
		window.open();
	}
	
	public void invokePlinthCreationWindow(PlinthObject plinthObject) {
		PlinthCreationWindow window = new PlinthCreationWindow(GdxPart.parentShell, plinthObject);
		window.open();
	}
	
	
	public void invokeGeometryObjectConfigWindow(GeometryObject geometry) {
		Shell shell = new Shell(Display.getDefault());
		GeometricObjectConfigWindow window = new GeometricObjectConfigWindow(shell, geometry);
		window.open();
	}
	
	public void invokeEdgeMesureWindow() {
		
	}
	
	public void invokeElementFacadeConfigWindow(KitchenElement element) {
		ElementFacadeConfigWindow facadeConfigWindow = new ElementFacadeConfigWindow(element);
		facadeConfigWindow.open();
	}
	
	public void invokeModelInstanceEditorWindow(WorldObject object) {
		ModelInstanceEditorWindow mechanicDesignWindow = new ModelInstanceEditorWindow(Display.getDefault().getActiveShell(), object, EditorWindow.update);
		mechanicDesignWindow.create();
		mechanicDesignWindow.open();
	}

}
