package dressing.ui;

import java.util.ArrayList;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

import dressing.config.persistence.ResourceManagers;
import dressing.model.elementsViewProviders.ElementProviderImp;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.GestionLabelProvider;
import dressing.ui.util.ListEditorWindow;
import param.Chant;
import param.Country;
import param.Finition;
import param.ParamFactory;

public class ChantComboSelect extends ElementComboSelect {

	public ChantComboSelect(Composite parent, int style) {
		super(parent, style);
		// TODO Auto-generated constructor stub
	}

	@Override
	public IContentProvider getContentProvider() {
		return ArrayContentProvider.getInstance();
	}

	@Override
	public IBaseLabelProvider getLabelProvider() {
		return GestionLabelProvider.getInstance();

	}

	@Override
	public Object getinput() {
		ArrayList<Object> input=new ArrayList<Object>();
		input.add(new Object());
		input.addAll(ResourceManagers.getIntance().getChants().getChant());
		return input;
	}

	@Override
	public void addElement() {
		Chant chant=ParamFactory.eINSTANCE.createChant();
		chant.setName("");
		chant.setEpaisseur(0);
		ChantEditorWindow mechanicDesignWindow = new ChantEditorWindow(getShell(),chant,EditorWindow.create);
		mechanicDesignWindow.create();
		int ret=mechanicDesignWindow.open();
		if(ret==Window.OK) {
			getComboViewer().setInput(getinput());
			getComboViewer().refresh();
			
			getComboViewer().setSelection(new StructuredSelection(chant), true);
		}
	}

	@Override
	public void Modify() {
		Object selection=getComboViewer().getStructuredSelection().getFirstElement();
		if(selection!=null   && selection instanceof Chant) {
			ChantEditorWindow mechanicDesignWindow = new ChantEditorWindow(getShell(),(Chant) selection,EditorWindow.update);
			mechanicDesignWindow.create();
			int ret=mechanicDesignWindow.open();
			if(ret==Window.OK) {
				getComboViewer().refresh();
			}
		}
		
	}
	@Override
	public ListEditorWindow getListEditorWindow() {
		// TODO Auto-generated method stub
		return new ChantListWindow(getShell(),null);
	}
}
