package dressing.ui.Assemblage;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import param.AssemblyContainer;
import param.AssemblyContainerGroup;
import param.AssemblySystem;
import param.AssemblySystemCalculMethod;
import param.Equation;
import param.ParamFactory;
import param.Vertex;

public class AssemblySystemController {

	public static AssemblyContainer createContainer(int groupIndex, int containerIndex, String name) {
		AssemblyContainer container = ParamFactory.eINSTANCE.createAssemblyContainer();
		container.setName(name);

		Vertex vertex = ParamFactory.eINSTANCE.createVertex();

		Equation x = ParamFactory.eINSTANCE.createEquation();
		x.setKey("this.x");
		x.setExpression(String.valueOf(groupIndex));

		Equation y = ParamFactory.eINSTANCE.createEquation();
		y.setKey("this.y");
		y.setExpression("@Parent.h@/2");

		Equation z = ParamFactory.eINSTANCE.createEquation();
		z.setKey("this.z");
		z.setExpression("0");

		vertex.setX(x);
		vertex.setY(y);
		vertex.setZ(z);
		container.setPosition(vertex);

		return container;
	}

	/**
	 * @param groupCount
	 * @param assembliesPerGroup
	 * @param assemblySystem
	 */
	public static void updateAssemblyContainerGroups(int groupCount, int assembliesPerGroup,
			AssemblySystem assemblySystem) {
		if (groupCount > assemblySystem.getGroups().size()) {
			int start = assemblySystem.getGroups().size() + 1;
			for (int g = start; g <= groupCount; g++) {
				AssemblyContainerGroup group = ParamFactory.eINSTANCE.createAssemblyContainerGroup();
				group.setName("G" + g);
//				for (int a = 1; a <= assembliesPerGroup; a++) {
//					String name = "G" + g + "-A" + a;
//
//					AssemblyContainer container = AssemblySystemController.createContainer(g, a, name);
//					if (assembliesPerGroup < 3 && a == 1 || assembliesPerGroup >= 3 && a == 2) {
//						if (assemblySystem.getMainAssembly() != null) {
//							container.setAssembly(assemblySystem.getMainAssembly());
//						}
//					} else {
//						if (assemblySystem.getSecondaryAssembly() != null) {
//							container.setAssembly(assemblySystem.getSecondaryAssembly());
//						}
//					}
//					if (container.getAssembly() != null) {
//						container.getPosition().getY().setExpression(container.getAssembly().getDefaultPosY());
//					}
//					assemblySystem.getAssemblies().add(container);
//					group.getAssemblies().add(container);
//				}
				assemblySystem.getGroups().add(group);
			}
		} else if (groupCount < assemblySystem.getGroups().size()) {
			while (groupCount < assemblySystem.getGroups().size()) {
				AssemblyContainerGroup group = assemblySystem.getGroups().get(assemblySystem.getGroups().size() - 1);
				assemblySystem.getAssemblies().removeAll(group.getAssemblies());
				assemblySystem.getGroups().remove(group);
			}
		}
	}

	/**
	 * @param assembliesPerGroup
	 */
	public static void updateAssembliesContainers(int assembliesPerGroup, AssemblySystem assemblySystem) {
		for (AssemblyContainerGroup group : assemblySystem.getGroups()) {
			if (assembliesPerGroup > group.getAssemblies().size()) {
				int start = group.getAssemblies().size() + 1;
				for (int a = start; a <= assembliesPerGroup; a++) {
					int indexOfGroup = assemblySystem.getGroups().indexOf(group) + 1;
					String name = "G" + indexOfGroup + "-A" + a;

					AssemblyContainer container = AssemblySystemController.createContainer(indexOfGroup, a, name);
					if (assembliesPerGroup < 3 && a == 1 || assembliesPerGroup >= 3 && a == 2) {
						if (assemblySystem.getMainAssembly() != null) {
							container.setAssembly(assemblySystem.getMainAssembly());
						}
					} else {
						if (assemblySystem.getSecondaryAssembly() != null) {
							container.setAssembly(assemblySystem.getSecondaryAssembly());
						}
					}
					if (container.getAssembly() != null) {
						container.getPosition().getY().setExpression(container.getAssembly().getDefaultPosY());
					}
					assemblySystem.getAssemblies().add(container);
					group.getAssemblies().add(container);

				}
			} else if (assembliesPerGroup < group.getAssemblies().size()) {
				while (assembliesPerGroup < group.getAssemblies().size()) {
					AssemblyContainer assemblyContainer = group.getAssemblies().get(group.getAssemblies().size() - 1);
					assemblySystem.getAssemblies().remove(assemblyContainer);
					group.getAssemblies().remove(assemblyContainer);
				}
			}
		}
		// reglage ordre containers
		assemblySystem.getAssemblies().clear();
		for (AssemblyContainerGroup containerGroup : assemblySystem.getGroups()) {
			assemblySystem.getAssemblies().addAll(containerGroup.getAssemblies());
		}
	}
	
    public static void calculateAssembliesContainersPositions(AssemblySystem assemblySystem) {
    	double entraxe = assemblySystem.getEntraxe();
		double multiplier = assemblySystem.getMultiplier();
		boolean isMultiple32 = assemblySystem.getCalculMethod().equals(AssemblySystemCalculMethod.MULTIPLE32);
		String distansBetweenGroups = computeDistanceBetweenGroups(assemblySystem, multiplier, isMultiple32);
		for (int g = 0; g < assemblySystem.getGroups().size(); g++) {
			AssemblyContainerGroup group = assemblySystem.getGroups().get(g);

			String groupPosition = computeGroupPosition(assemblySystem, multiplier, isMultiple32, distansBetweenGroups,
					g);
			for (int a = 0; a < group.getAssemblies().size(); a++) {
				AssemblyContainer container = group.getAssemblies().get(a);
				String containerPositionX = computeContainerPosition(assemblySystem, entraxe, g, groupPosition, a);
				container.getPosition().getX().setExpression(containerPositionX);
			}
		}
    }

	/**
	 * @param assemblySystem
	 * @param entraxe
	 * @param groupIndex
	 * @param groupPosition
	 * @param containerIndex
	 * @return
	 */
	public static String computeContainerPosition(AssemblySystem assemblySystem, double entraxe, int groupIndex,
			String groupPosition, int containerIndex) {
		String containerPositionX = "";
		int indexmain = assemblySystem.getAssembliesPerGroup() < 3 ? 0 : 1;
		if (containerIndex < indexmain) {
			containerPositionX = groupIndex == 0 ? (assemblySystem.getRetrait1() - ((indexmain - containerIndex) * entraxe) + "")
					: groupPosition + " - " + ((indexmain - containerIndex) * entraxe);
		} else if (containerIndex > indexmain) {
			containerPositionX = groupIndex == 0 ? (assemblySystem.getRetrait1() + ((containerIndex - indexmain) * entraxe) + "")
					: groupPosition + " + " + ((containerIndex - indexmain) * entraxe);
		} else {
			containerPositionX = groupPosition;
		}
		return containerPositionX;
	}

	/**
	 * @param assemblySystem
	 * @param multiplier
	 * @param isMultiple32
	 * @param distansBetweenGroups
	 * @param groupIndex
	 * @return
	 */
	public static String computeGroupPosition(AssemblySystem assemblySystem, double multiplier, boolean isMultiple32,
			String distansBetweenGroups, int groupIndex) {
		String groupPosition = "" + assemblySystem.getRetrait1();
		if (groupIndex > 0) {
			List<AssemblyContainerGroup> previousGroups = assemblySystem.getGroups().subList(0, groupIndex + 1);
			List<AssemblyContainerGroup> previousFreeGroupsStream=previousGroups.stream().filter(gr -> !gr.isDistanceAuto()).collect(Collectors.toList());
			double sumOfpreviousFreeGroups = previousFreeGroupsStream.stream()
					.mapToDouble(gr -> {
						if (isMultiple32) {
							return gr.getDistance() * multiplier;
						} else {
							return gr.getDistance();
						}
					}).sum();

			long numberOfPreviousGroups = previousGroups.stream().filter(gr -> gr.isDistanceAuto()).count() - 1;
			if (sumOfpreviousFreeGroups > 0) {
				groupPosition = (assemblySystem.getRetrait1() + sumOfpreviousFreeGroups)+"";
			}
			if (numberOfPreviousGroups > 1) {
				groupPosition += " + (" + (numberOfPreviousGroups) + "*" + distansBetweenGroups + ")";
			}else if (numberOfPreviousGroups == 1) {
				groupPosition += " + (" + distansBetweenGroups + ")";
			}
		}
		return groupPosition;
	}

	/**
	 * @param assemblySystem
	 * @param multiplier
	 * @param isMultiple32
	 * @return
	 */
	public static String computeDistanceBetweenGroups(AssemblySystem assemblySystem, double multiplier,
			boolean isMultiple32) {
		List<AssemblyContainerGroup> freeGroups=assemblySystem.getGroups().stream().filter(gr -> !gr.isDistanceAuto()).collect(Collectors.toList());
		long numberOfFreeGroups = freeGroups.stream().count();
		double sumOfFreeGroups = freeGroups.stream()
				.mapToDouble(gr -> {
					if (isMultiple32) {
						return gr.getDistance() * multiplier;
					} else {
						return gr.getDistance();
					}
				}).sum();
		long autoCount = assemblySystem.getNumberOfGroups() - 1 - numberOfFreeGroups;
		double freeSpace=assemblySystem.getRetrait1() + assemblySystem.getRetrait2() + sumOfFreeGroups;
		String distansBetweenGroups ="";
		if(autoCount==1) {
			distansBetweenGroups = String.format("(@Parent.l@ - %s)", freeSpace);
		}else if(autoCount>1){
			distansBetweenGroups = String.format("(@Parent.l@ - %s)/%d", freeSpace, autoCount);
		}
		if (isMultiple32) {
			distansBetweenGroups = String.format(
		            "Math.floor((%s)/%s)*%s",
		            distansBetweenGroups, multiplier, multiplier
		        );
		}
		return distansBetweenGroups;
	}
    /**
	 * @param container
	 * @return
	 */
	public static String getContainerPositionLabel(AssemblyContainer container) {
		return String.format("(%s, %s, %s)", container.getPosition().getX().getExpression(),
				container.getPosition().getY().getExpression(),
				container.getPosition().getZ().getExpression());
	}
}
