package dressing.ui;

import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

import dressing.config.WorkspaceConfiguration;
import dressing.config.persistence.ResourceManagers;
import dressing.model.DesignObject3D;
import dressing.model.MechanicDesignAssemblyManager;
import dressing.model.MechanicDesignCreator;
import dressing.model.MechanicDesignMaterialsHelper;
import dressing.model.Space3D;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.ImageLoaderCache;
import param.Catalog;
import param.DesignClassGroup;
import param.DesignClasse;
import param.DesignInstance;
import param.MechanicDesign;
import param.MechanicDesignGroup;
import param.ModelRoot;
import param.PieceType;

import java.io.File;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;

import dressing.ui.palette.DesignApplicationPaletteComposite;
import dressing.ui.palette.DesignApplicationPaletteProvider;
import dressing.ui.palette.DesignApplicationSelectionListener;
import dressing.ui.palette.PaletteComposite;
import dressing.ui.palette.PaletteGroup;
import dressing.ui.palette.PaletteItem;
import dressing.ui.palette.PaletteProject;
import dressing.ui.palette.PaletteProvider;
import dressing.ui.palette.ParentHandler;

import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.custom.ScrolledComposite;

public class ApplicationEditorWindow extends EditorWindow {
	//services
    private final IEventBroker eventBroker;
    private final ESelectionService selectionService;
    
	private DesignObject3D parent;

	Composite parentComposite;
	private DesignApplicationPaletteComposite clientArea;

	private MechanicDesign design;
	private PaletteProject palette;
	 private PaletteProvider paletteProvider;
	public ApplicationEditorWindow(Shell parentShell, DesignObject3D parent, IEventBroker eventBroker,
            ESelectionService selectionService) {
		super(parentShell, EditorWindow.executeAction);
		this.parent = parent;
		paletteProvider=new DesignApplicationPaletteProvider(parent);
		palette = paletteProvider.getPaletteRoot();
		this.eventBroker = eventBroker;
	    this.selectionService = selectionService;
	}
	@Override
	public int open() {
		if(palette.getPaletteItems().isEmpty()) {
			finish();
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					MessageDialog.openError(getParentShell(),"Aucun Applicable", "Il n'y a aucun composant applicable à :"+parent.getName());
				}
			});
			return CANCEL;
		}else {
			return super.open();
		}
		
	}
	@Override
	protected Composite createClientArea(Composite parent) {
		parentComposite = parent;
		clientArea = new DesignApplicationPaletteComposite(parent, SWT.FILL,eventBroker,selectionService,paletteProvider);
		clientArea.addDesignApplicationSelectionListener(new DesignApplicationSelectionListener() {
			
			@Override
			public void designSelectedApply(MechanicDesign design) {
				ApplicationEditorWindow.this.design=design;
				terminer();
			}
			
			@Override
			public void designSelected(MechanicDesign design) {
				ApplicationEditorWindow.this.design=design;
				
			}
		}); 
		clientArea.pack();

		return clientArea;
	}

	@Override
	public boolean terminer() {
		if (!super.terminer()) {
			return false;
		}

		try {
			if (design != null && parent!=null) {
				Display.getDefault().asyncExec(new Runnable() {

					@Override
					public void run() {
						// TODO Auto-generated method stub
						MechanicDesign copy = EcoreUtil.copy(design);
						try {
							MechanicDesignCreator.getInstance().syncParamsFromParentDesign(copy, parent);
						} catch (Exception e) {
							SuperCadMessageDialog.openMessage(MessageDialog.ERROR, getShell(), "Une erreur dans la synchronisation avec Parent", e.getMessage());
							e.printStackTrace();
						}
						MechaincDesignEditorWindow mechanicDesignWindow = new MechaincDesignEditorWindow(
								ApplicationEditorWindow.this.getParentShell(), copy, false, null, parent, null, null,
								true, MechanicDesignCreator.create);
						mechanicDesignWindow.create();
						mechanicDesignWindow.open();
					}
				});

			}

		} catch (Exception e) {
			e.printStackTrace();
		}
		finish();
		return true;
	}

	@Override
	protected void cancel() {

	}

	@Override
	public boolean check() {
		errorExist = false;
		errorMessage = "";
		return !errorExist;
	}

	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		return bindingContext;
	}

	@Override
	protected Point getInitialSize() {
		return new Point(900, 720);
	}
	
	@Override
	protected boolean isMaximized() {
		return false;
	}

}
