package dressing.model.debitage;

import java.util.ArrayList;
import java.util.List;
import javax.script.ScriptContext;
import javax.script.ScriptException;

import org.frs.debitage.engine.core.evalutor.Equation;
import org.frs.debitage.engine.core.evalutor.GeomtericEngine;

import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.FaceModel;
import param.MechanicPrivateParam;
import param.MechanicPublicParam;

public class FaceAssemblyDebitageFormila extends GenericDebitageFormula {

	public FaceAssemblyDebitageFormila() {
		super();
		// TODO Auto-generated constructor stub
	}

	public static void filldebitagesequations(DesignObject3D parent, FaceModel face, param.Face node,List<MechanicPrivateParam> privateparams,
			List<MechanicPublicParam> publicparams, ArrayList<Equation> equations) throws DesignException {
		if (face == null)
			throw new DesignException("Formule de debitage : child null");
		GeomtericEngine.getLogicalEngine().getContext().getBindings(ScriptContext.GLOBAL_SCOPE).clear();
		GeomtericEngine.getLogicalEngine().getContext().getBindings(ScriptContext.ENGINE_SCOPE).clear();
		if (parent != null) {
			GeomtericEngine.getLogicalEngine().put("PARENT", parent);
			GeomtericEngine.getLogicalEngine().put("CHILD", face);
			GeomtericEngine.getEngine().put("PARENT", parent);
			GeomtericEngine.getEngine().put("CHILD", face);
			
		}

		// check exist logic
		try {

			fillequationsfromprivateparam(equations, privateparams);
			fillequationsfrompublicparam(equations, publicparams);
			fillequationsfromparent(parent, equations);
			boolean res = true;
			// evaluer seulement si il ya exist expression
			if(node.getExistExpression()!=null && !node.getExistExpression().isEmpty())
			res = (boolean) GeomtericEngine.getLogicalEngine().eval(node.getExistExpression().toString());
			

			if (!res) {
				face.put("EXIST", false);
			} else {
				face.put("EXIST", true);
				

			}

		} catch (ScriptException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			face.put("EXIST", false);
			throw new DesignException(
					" L'expression d'existence ne peut pas être évaluée. " + node.getExistExpression());
		} finally {
			GeomtericEngine.getLogicalEngine().getContext().getBindings(ScriptContext.GLOBAL_SCOPE).clear();
			GeomtericEngine.getLogicalEngine().getContext().getBindings(ScriptContext.ENGINE_SCOPE).clear();
		}

	}
}
