package dressing.model;

import org.jogamp.vecmath.AxisAngle4d;
import org.jogamp.vecmath.Vector3d;

public class VecmathTransformManager implements TransformManager<AxisAngle4d, Vector3d> {

	protected Solide3D owner;
	protected transient Vector3d deviate = new Vector3d(0,0,0);
    public AxisAngle4d rotation=new AxisAngle4d(new Vector3d(0, 0, 0), 0);
    
    public VecmathTransformManager(Solide3D owner) {
		super();
		this.owner = owner;
	}


	@Override
	public AxisAngle4d getRotation() {
		AxisAngle4d rotation=new AxisAngle4d(0, 1, 0, 0);
		if(this.rotation.getAngle()!=0) {
			rotation.set(this.rotation);
		} else {
			if(owner.getParent()!=null &&!owner.getParent().hasMember(owner)) {
				return rotation;
			}
			if(owner.getParent()!=null)
			{
				rotation.set((AxisAngle4d)owner.getParent().getTransformManager().getRotation());
			}
		}
		return rotation;
	}


	public Vector3d getDeviate() {
		float x=0;
		float y=0;
		float z=0;
		Vector3d deviate = new Vector3d(x, y, z);
		if (owner.getParent() != null) {
			if(owner.getParent().getTransformManager()==null) {
				TransformManagerFactory.assign(owner.getParent());
			}
			deviate.add((Vector3d)owner.getParent().getTransformManager().getDeviate());
		}
		return deviate;
	}

    @Override
    public void openFacade( boolean open) {
        for (Solide3D child : owner.getChildren()) {
        	if(child.getTransformManager()==null) {
				TransformManagerFactory.assign(child);
			}
			TransformManager<Object, Object> tm3D =child.getTransformManager();
			tm3D.openFacade( open);
        }
    }


	public Solide3D getOwner() {
		return owner;
	}


	public void setOwner(Solide3D owner) {
		this.owner = owner;
	}
    
}