package dressing.model;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

import com.badlogic.gdx.math.Vector3;

import dressing.model.types.Orientation;

public interface Solide3D
{
	double getXSize();
	double getYSize();
	double getZSize();
	double getXPosition();
	double getYPosition();
	double getZPosition();
	double getXPosABS();
	double getYPosABS();
	double getZPosABS();
	List<Solide3D> getChildren();
	Solide3D getParent();
	BufferedImage getImage();
	boolean isdrawable();
	Boolean isSelected();
	boolean isVisible();
	abstract void setSelected(Boolean selected) ;
	default Boolean isHighlighted() {
		return isSelected();
		
	}
	default double getVolume() {
		return getXSize()*getYSize()* getZSize();
		
	}

	default  double gettransparency()
	{
		return  1;
	}
	default boolean  hasMember(Solide3D sld) {
		if(sld==null)
			return false;
		if(this.equals(sld))
			return true;
		for(Solide3D child : getChildren())
		{
			if(child.hasMember(sld))
			{
				return true;
			}
		}
		return false;
	}
	default boolean  isDirectlyDelatable()
	{
			return true;
	}
	/**
	 * Si cette piece est verticale lorsque la plus faible cote est dans le X
	 * Comme les cote et les seprateurs verticlae
	 */
	public default boolean isVerticallPiece()
	{
		return this.getXSize()<this.getYSize() && this.getXSize()<this.getZSize();
	}
	/**
	 * Si cette piece est verticale lorsque la plus faible cote est dans le Y
	 * Comme les les etageres
	 */
	public default boolean isHorizontalePiece()
	{
		return this.getYSize()<this.getXSize() && this.getYSize()<this.getZSize();
	}
	/**
	 * Si cette piece est verticale lorsque la plus faible cote est dans le Z
	 * Comme le dos
	 */
	public default boolean isProfondPiece()
	{
		return this.getZSize()<this.getXSize() && this.getZSize()<this.getYSize();
	}
	
	public default Orientation getPieceOrientation() {
		if (isHorizontalePiece()) {
			return Orientation.HORIZONTAL;
		} else if (isProfondPiece()) {
			return Orientation.PROUFOUND;
		} else {
			return Orientation.VERTICAL;
		}
	}
	
	public default Vector3 getSize() {
		return new Vector3((float) getXSize(), (float) getYSize(), (float) getZSize());
	}
	
	public default Vector3 getPosition() {
		return new Vector3((float) getXPosition(), (float) getYPosition(), (float) getZPosition());
	}
	
	default public <T extends Solide3D> void  getChildrenByType( Class<T> clazz, ArrayList<T> out) {
		for(Solide3D solid: getChildren()) {
			if(clazz.isInstance(solid))
				out.add((T) solid);
			solid.getChildrenByType(clazz, out);
		}
	}

	<V, R> TransformManager<V, R> getTransformManager();

	<V, R> void setTransformManager(TransformManager<V, R> manager);
	
}
