package dressing.model;

import java.util.ArrayList;

import org.frs.debitage.engine.core.evalutor.GeometricEngineException;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;

import dressing.cam.model.Direction;
import dressing.cam.model.PlanUsinage;
import dressing.cam.model.Util;
import dressing.mathutils.MathUtilities;

public class PieceRotater {

	Vector3 center;
	Matrix4 transform;
	Vector3 origin;

	// must be optimized in a way to make the usinage rotated after selection of
	// axis was already done
	public Piece2D rotateForLargestSurface(Piece2D piece, boolean firstRot) {
		ArrayList<Piece2D> images = new ArrayList<Piece2D>();
		images.add(rotatePiece(piece, Vector3.X, 1));
		images.add(rotatePiece(piece, Vector3.Y, 1));
		images.add(rotatePiece(piece, Vector3.Z, 1));
		Piece2D largestImage = images.get(0);
		for (int i = 0; i < images.size(); i++) {
			if (getSurface(PlanUsinage.FRONT,images.get(i)) > getSurface(PlanUsinage.FRONT,largestImage))
				largestImage = images.get(i);
		}
		if (firstRot) {
			return rotateForLargestSurface(largestImage, false);
		} else {
			Piece2D flipped = rotatePiece(piece, Vector3.X, 2);
			largestImage =  largestImage.getusinage().size()>flipped.getusinage().size()?largestImage:flipped;
			double width=(float) Util.getPieceL(largestImage, PlanUsinage.FRONT);
			double height=(float) Util.getPieceH(largestImage, PlanUsinage.FRONT);
			if(width < height)
				largestImage = rotatePiece(largestImage, Vector3.Z, 1);
			return largestImage;
		}
	}

	// rotate the piece by 90 degrees n times
	public Piece2D rotatePiece(Piece2D piece, Vector3 axis, int times) {
		float width = (float) piece.getLongeurext();
		float height = (float) piece.getHauteurext();
		float depth = (float) piece.getProfondeurext();
		center = new Vector3(width, height, depth).scl(0.5f);
		transform = new Matrix4(Vector3.Zero, new Quaternion(axis, 90 * times), new Vector3(1, 1, 1));
		ArrayList<Vector3> corners = piece.getCornersList();
		ArrayList<Vector3> rotatedCorners = new ArrayList<Vector3>();
		for (Vector3 corner : corners) {
			rotatedCorners.add(corner.cpy().sub(center).mul(transform));
		}
		Vector3[] bounds = MathUtilities.getBoundaries(rotatedCorners);
		origin = bounds[0];
		for (Vector3 corner : rotatedCorners) {
			corner.sub(origin);
			MathUtilities.round(corner, 0);
		}
		Vector3 rdims = bounds[1].cpy().sub(bounds[0]);
		MathUtilities.round(rdims, 0);
		Piece2D rotatedPiece = new Piece2D();
		rotatedPiece.setLongeurext(rdims.dot(Vector3.X));
		rotatedPiece.setHauteurext(rdims.dot(Vector3.Y));
		rotatedPiece.setProfondeurext(rdims.dot(Vector3.Z));
		rotatedPiece.setName(piece.getName());
		try {
			for (Usinage usinage : piece.getusinage()) {
				if (usinage instanceof Trou) {
					Trou rotatedTrou = rotateTrou((Trou) usinage);
					rotatedTrou.setParentdesign(rotatedPiece);
					rotatedPiece.addElement(rotatedTrou);

				} else if (usinage instanceof Cavity || usinage instanceof Rainure) {
					Usinage rotatedusinage = rotateUsinage(usinage);
					rotatedusinage.setParentdesign(rotatedPiece);
					rotatedPiece.addElement(rotatedusinage);
				}
			}
		} catch (DesignException | GeometricEngineException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return rotatedPiece;

	}

	public Trou rotateTrou(Trou trou) {
		Vector3 dir = trou.getDirection().toVector();
		Vector3 center = trou.getStart().sub(this.center).mul(transform).sub(origin);
		Trou rotatedTrou = new Trou();
		Vector3 v = dir.cpy().mul(transform);// sub(new Vector3().mul(transform));
		Direction rotatedDir = Direction.fromVector(v);
		rotatedTrou.setDirection(rotatedDir);
		rotatedTrou.setDiameter(trou.getDiameter());
		rotatedTrou.setDepth(trou.getDepth());
		rotatedTrou.setXpos(center.x);
		rotatedTrou.setYpos(center.y);
		rotatedTrou.setZpos(center.z);
		return rotatedTrou;
	}

	public Usinage rotateUsinage(Usinage usinage) {
		ArrayList<Vector3> corners = usinage.getCorners();
		for (Vector3 corner : corners) {
			MathUtilities.round(corner.sub(center).mul(transform).sub(origin), 0);
		}
		Vector3[] bounds = MathUtilities.getBoundaries(corners);
		Usinage rotatedUsinage;
		if (usinage instanceof Rainure) {
			rotatedUsinage = new Rainure();
		} else {
			rotatedUsinage = new Cavity();
		}
		rotatedUsinage.setPosition(bounds[0]);
		rotatedUsinage.setSize(bounds[1].cpy().sub(bounds[0]));
		return rotatedUsinage;
	}
	
	public float getSurface(PlanUsinage face, Piece2D piece) {
		return (float) (Util.getPieceL(piece,face) * Util.getPieceH(piece, face));
	}
	
	public static void main(String[] args) {
		float length = 564;
		float height = 18;
		float depth = 535;

		Vector3 center = new Vector3(length, height, depth).scl(0.5f);
		Matrix4 transform = new Matrix4(Vector3.Zero, new Quaternion(Vector3.Z, 90), new Vector3(1, 1, 1));

		Vector3 l = new Vector3(1, 0, 0).add(center).mul(transform);
		Vector3 h = new Vector3(0, 1, 0).add(center).mul(transform);
		Vector3 d = new Vector3(0, 0, 1).add(center).mul(transform);
		Vector3 centerX = center.cpy().add(center).mul(transform);
		Vector3 originX = Vector3.Zero;// center.cpy().mul(transform);

		System.out.println(l.sub(originX));
		System.out.println(h.sub(originX));
		System.out.println(d.sub(originX));
		System.out.println(centerX);
		System.out.println(originX);

	}
}
