package dressing.model;


import org.jogamp.vecmath.Vector3d;

import dressing.model.types.PieceType;

public class Piece2DVecmathTransformManager extends VecmathTransformManager{

	
	public Piece2DVecmathTransformManager(Solide3D owner) {
		super(owner);
		// TODO Auto-generated constructor stub
	}

	@Override
	public Vector3d getDeviate() {
		Vector3d deviate=new Vector3d(0, 0, 0);
		deviate.add(this.deviate);
		if(owner.getParent()!=null)
		{
			deviate.add((Vector3d) owner.getParent().getTransformManager().getDeviate());
		}
		if(!owner.getParent().hasMember(owner)) {
			deviate.set(0, 0, 0);
		}
		return deviate;
	}

	public void openFacade(boolean open) {
		if (open) {
			if (((Piece2D) owner).getPiecetype().equals(PieceType.PORTE_GAUCHE)) {
				deviate.set(-(float) (owner.getXSize()) + owner.getZSize(), 0,
						(float) (((Piece2D) owner).getXSize()) - owner.getZSize());
				rotation.set(new Vector3d(0, 1, 0), -Math.PI / 2);

			} else if (((Piece2D) owner).getPiecetype().equals(PieceType.PORTE_DROITE)) {
				deviate.set((float) (owner.getXSize()) - owner.getZSize(), 0,
						(float) (owner.getXSize()) - owner.getZSize());
				rotation.set(new Vector3d(0, 1, 0), Math.PI / 2);
			} else {
				deviate.set(0, 0, 0);
				rotation.set(0, 1, 0, 0);
			}
		} else {
			deviate.set(0, 0, 0);
			rotation.set(0, 1, 0, 0);
		}

	}
	
}
