package dressing.model;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.imageio.ImageIO;
import com.badlogic.gdx.math.Vector3;

import org.frs.debitage.engine.core.evalutor.Couple;
import org.frs.debitage.engine.core.evalutor.Equation;
import org.frs.debitage.engine.core.evalutor.GeometricEngineException;
import org.frs.debitage.engine.core.evalutor.GeomtericEngine;

import dressing.cam.model.PlanUsinage;
import dressing.cam.model.Util;
import dressing.config.ReportingPreferences;
import dressing.config.WorkspaceConfiguration;
import dressing.model.debitage.GenericDebitage;
import dressing.model.types.IntersectionType;
import dressing.model.types.Orientation;
import dressing.model.types.PieceType;
import dressing.model.ui.util.Pair;
import param.Material;
import param.MaterialTypeInstance;
import param.MechanicDesignElment;
import param.UsinageNode;

public class Piece2D extends DesignObject3D {

	private PieceType piecetype;
	private Material material;
	//Pour les pieces 2D
	private double epaisseur;
	private double pieceL;
	private double pieceH;

	private String chants="";
	private MechanicDesignElment mechanicDesignElementDefinition;
	private MaterialTypeInstance materialType;
	private MaterialTypeInstance vitreMaterialType;
	private int fichedebitNumber=1;
	private boolean solid=true;

	private transient PieceSplitManager partsManager;
	private transient ArrayList<FaceModel> faces=new ArrayList<FaceModel>();
	public String getChants() {
		if(chants==null || chants.isEmpty()) {
			convertwritablechants();	
		}
		return chants;
	}
	
	public MechanicDesignElment getMechanicDesignElementDefinition() {
		return mechanicDesignElementDefinition;
	}
	public void setMechanicDesignElementDefinition(MechanicDesignElment mechanicDesignElementDefinition) {
		Object old=this.mechanicDesignElementDefinition;				
		this.mechanicDesignElementDefinition = mechanicDesignElementDefinition;
		firePropertyChange("mechanicDesignElementDefinition", old, mechanicDesignElementDefinition);
	}
	
	public MaterialTypeInstance getMaterialType() {
		return materialType;
	}
	public void setMaterialType(MaterialTypeInstance materialType) {
		Object old=this.materialType;				
		this.materialType = materialType;
		firePropertyChange("materialType", old, materialType);
	}
	
	public MaterialTypeInstance getVitreMaterialType() {
		return vitreMaterialType;
	}
	public void setVitreMaterialType(MaterialTypeInstance vitreMaterialType) {
		Object old=this.vitreMaterialType;				
		this.vitreMaterialType = vitreMaterialType;
		firePropertyChange("vitreMaterialType", old, vitreMaterialType);
	}

	public void setPieceH(double pieceH) {

		double oldValue = this.pieceH;
		this.pieceH = pieceH;
		firePropertyChange("pieceH", oldValue, pieceH);
	}
	public double getPieceL() {
		pieceL=Math.max(getLongeurext(), Math.max(getHauteurext(), getProfondeurext()));
		return pieceL;
	}
	public void setPieceL(double pieceL) {

		double oldValue = this.pieceL;
		this.pieceL = pieceL;
		firePropertyChange("pieceL", oldValue, pieceL);
	}
	public double getPieceH() {
		this.pieceH=(getLongeurext()+getHauteurext()+getProfondeurext())-getPieceL()-(Math.min(getLongeurext(), Math.min(getHauteurext(), getProfondeurext())));
		return pieceH;
	}
	public void setMaterial(Material material) {

		Material oldValue = this.material;
		this.material = material;
		firePropertyChange("material", oldValue, material);
	}
	public Material getMaterial() {
		return material;
	}

	public void setEpaisseur(double epaisseur) {

		double oldValue = this.epaisseur;
		this.epaisseur = epaisseur;
		firePropertyChange("epaisseur", oldValue, epaisseur);
	}
	public double getEpaisseur() {
		return epaisseur;
	}
	
	public boolean isSolid() {
		return solid;
	}
	public void setSolid(boolean solid) {
		this.solid = solid;
	}
	public void setPiecetype(PieceType droiteCuisson) {

		PieceType oldValue = this.piecetype;
		this.piecetype = droiteCuisson;
		firePropertyChange("piecetype", oldValue, droiteCuisson);
	}
	public PieceType getPiecetype() {
		return piecetype;
	}
	@Override
	public boolean canHold(DesignObject3D child) {
		// TODO Auto-generated method stub
		if(child instanceof Accessoire || child instanceof Usinage || child instanceof Piece2D ||child instanceof Space3D )
		{
			return true;
		}
		return false;
	}
	
	public String printDescription()
	{		
		String s="";
		s+=" 		Piece "  + getName() +"\n";
		s+=" 		Type "  + getPiecetype() +"\n";
		/*
		s+=" 		Longeur extenre "  + getLongeurext() +" mm \n";
		s+=" 		Hauteur extenre "  + getHauteurext() +" mm \n";
		s+=" 		Profondeur extenre "  + getProfondeurext() +" mm \n";
		
		s+=" 		Longeur interne "  + getLongeurint() +" mm \n";
		s+=" 		Hauteur interne "  + getHauteurint() +" mm \n";
		s+=" 		Profondeur interne "  + getProfondeurint() +" mm \n";
		*/
		s+=" 		L "  + getPieceL() +"  \n";
		s+=" 		H "  + getPieceH() +"  \n";
		s+=" 		Epaisseur"  + getEpaisseur() +"  \n";
		s+=" 		Matreieaux "  + getMaterial().getName() +"  \n\n";
		s+="		------Les sous elements ------\n";
		System.out.println(s);
		for(DesignObject3D child : getChilds())
		{
			s+=child.printDescription();
		}
		
		return s;
	}
	public Piece2DCoupe createPieceCoupe()
	{
		Piece2DCoupe p = new Piece2DCoupe();
		p.setPieceH(getPieceH());
		p.setPieceL(getPieceL());
		p.setMaterial(getMaterial().getName());
		p.setChants(getChants());
		p.setQty(1);
		
		p.setPiecename(getName());
		
		if (getParentdesign() != null && getParentdesign() instanceof Space3DFree && getParentdesign().getMechanicDesignDefinition()!=null) {
			p.setParentname(getParentdesign().getName());
			p.setCaissonname(getParentdesign().getName());
		}
			
		
		return p;
	}

	/*
	 * this method is used to apply texture to Piece2D in the java3D in case the default method of getting texture failed
	 * @see dressing.model.DesignObject3D#getImage()
	 */
	@Override
	public BufferedImage getImage() {
		// TODO Auto-generated method stub
		
			String filename = "";
			if(getMaterial().getImage()!=null) {
				filename="pictures/"+getMaterial().getImage();
			}else {
				//in the case of material image is null 
				if (getPiecetype() == PieceType.DOS_INTERIEUR || getPiecetype() == PieceType.DOS_EXTERIRUR
						|| getPiecetype() == PieceType.BAS_TIROIR) {
					filename = "pictures/back.jpg";
				}
				else {
					filename = "pictures/texture1.png";
				}
			}
		FileInputStream fis = null;
		BufferedImage bufferedImage = null;

		try {
			bufferedImage = ModelProvider.getBufferedImagesHashMap().get(filename);
			if (bufferedImage == null) {
				File im = WorkspaceConfiguration.getimage(filename, true);
				if (im == null || !im.exists()) {
					filename = "pictures/royale-blanc-hanstone-slab.jpg";
					bufferedImage = ModelProvider.getBufferedImagesHashMap().get(filename);
					if (bufferedImage != null) {
						return bufferedImage;
					}
					im = WorkspaceConfiguration.getimage(filename, true);
				}
				fis = new FileInputStream(im);
				bufferedImage = ImageIO.read(fis);
				ModelProvider.getBufferedImagesHashMap().putIfAbsent(filename, bufferedImage);
				fis.close();
			}

		} catch (IOException e) {
			e.printStackTrace();
		}

		return bufferedImage;
	}
	@Override
	public boolean isdrawable() {
			return isSolid();		
	}

	@Override
	public boolean isDirectlyDelatable() {
		if(getMechanicDesignDefinition()!=null&& !getMechanicDesignDefinition().isDeleteable()) {
			return false;
		}
		return super.isDirectlyDelatable();
	}
	
	@Override
	public double gettransparency() {
		return 0;
	}

	@Override
	protected void updateproperties(ArrayList<Equation> equations) throws GeometricEngineException {
		
		// TODO Auto-generated method stub
		super.updateproperties(equations);
		setNotificationon(false);
		Equation eq=null;
		try {
			if(equations!=null)
			{
				eq  = Equation.FIND_EQUATION("@this.pieceL@", equations);
				if(eq!=null)
				{
					GeomtericEngine.getInstance().resolveEquation(eq);
					setPieceL(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException("@this.pieceL@ not found to update");
				}
				eq  = Equation.FIND_EQUATION("@this.pieceH@", equations);
				if(eq!=null)
				{
					GeomtericEngine.getInstance().resolveEquation(eq);
					setPieceH(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException("@this.pieceH@ not found to update");
				}
				eq  = Equation.FIND_EQUATION("@this.e@", equations);
				if(eq!=null)
				{
					GeomtericEngine.getInstance().resolveEquation(eq);
					setEpaisseur(eq.getEvaluation(null));
				}
				else
				{
					setEpaisseur(Math.min(Math.min(getLongeurext(), getHauteurext()),getProfondeurext()));
				}
				chants=null;
				
			}
		} catch (GeometricEngineException e) {
			// TODO: handle exception
			e.printStackTrace();
			throw e;
		}
		finally {
			setNotificationon(true);
		}
		if(partsManager!=null)
			partsManager.clearParts();
		clearFaces();
	}
	
	public void convertwritablechants()
	{
		boolean isSenseFil = ReportingPreferences.getInstance().getProperty("superoupe.SenseFil", true);
		boolean ispredebitchant = ReportingPreferences.getInstance().getProperty("superoupe.predebitchant", true);
		boolean isSenseFilInverse = ReportingPreferences.getInstance().getProperty("superoupe.SenseFilInverse", false);
		Vector3 dim = Util.getMaterialDependentDimention(this, isSenseFil, ispredebitchant,isSenseFilInverse);
		BigDecimal l=new BigDecimal(dim.x, Util.context);
		BigDecimal h=new BigDecimal(dim.y, Util.context);

		Map<PlanUsinage, param.Chant> chantsMap = Util.getChants(this,
				l.compareTo(new BigDecimal(Util.getPieceL(this, getPrimaryPrespective()), Util.context)) != 0);
		param.Chant chantLeft = chantsMap.get(PlanUsinage.LEFT);
		param.Chant chantRight = chantsMap.get(PlanUsinage.RIGHT);
		param.Chant chantTop = chantsMap.get(PlanUsinage.TOP);
		param.Chant chantBottom = chantsMap.get(PlanUsinage.DOWN);

		// List of edge + direction
		List<Pair<param.Chant, String>> chantList = Arrays.asList(
			    new Pair<>(chantLeft, "L"),
			    new Pair<>(chantRight, "L"),
			    new Pair<>(chantTop, "H"),
			    new Pair<>(chantBottom, "H")
			);
		
	    Map<String, Integer> chantCountMap = new LinkedHashMap<>();

	    for (Pair<param.Chant, String> pair : chantList) {
	        param.Chant chant = pair.getFirst();
	        String dir = pair.getSecond();

	        if (chant != null && chant.getName() != null && !chant.getName().isEmpty()) {
	            String key = dir + " " + chant.getName().trim();
	            chantCountMap.put(key, chantCountMap.getOrDefault(key, 0) + 1);
	        }
	    }

	    // Build final string
	    StringBuilder description = new StringBuilder();
	    for (Map.Entry<String, Integer> entry : chantCountMap.entrySet()) {
	        if (description.length() > 0) description.append(" + ");
	        description.append(entry.getValue()).append(entry.getKey());

	        // Optional: add dimension comment
	        if (entry.getKey().startsWith("L")) {
	            description.append("(Longueur=").append(l.doubleValue()).append(")");
	        } else if (entry.getKey().startsWith("H")) {
	            description.append("(Hauteur=").append(h.doubleValue()).append(")");
	        }
	    }
		chants=description.toString();
	}
	/***
	 * Cette methode retourne le point par rapport au repore 2D
	 * @return
	 */
	public Point3D getConvertedPointIn2D(PlanUsinage persp)
	{
		Point3D p = new Point3D();
		switch (persp) {
		case FRONT:
			p.x = this.getXPosABS();
			p.y = - this.getYPosABS() - this.getHauteurext();
			p.z=0;
			break;

		default:
			
			break;
		}
		return p; 
		
		
	}
	
	@Override
	public void createUsinage(List<Usinage> usins, boolean cavityOnly) throws GeometricEngineException, DesignException {
		boolean isdev = ReportingPreferences.getInstance().getProperty("user.dev", false);
		MechanicDesignObstaclesManager.checkPieceIntersectionWithObstacles(getRoot(), this);
		if( getMechanicDesignDefinition()!=null&& getMechanicDesignElementDefinition()!=null) {
			
			if(getMechanicDesignElementDefinition().getUsinagenode()!=null) {
		
				for(UsinageNode node:getMechanicDesignElementDefinition().getUsinagenode()) {
					boolean nodeexist=true;
					dressing.model.UsinageNode designNode=new dressing.model.UsinageNode(node);
					if(isdev) {
			    		addElement(designNode);
					}
					if(node.getExistexpression()!=null && !node.getExistexpression().isEmpty()) {
						ArrayList<Equation> equations = new ArrayList<Equation>();
						
						GenericDebitage.createupdateDebitage(this,designNode,getMechanicDesignDefinition().getPrivateparamgroup().getMechanicprivateparam(),getMechanicDesignDefinition().getPublicparamgroup().getMechanicpublicparam(),node,equations);
						nodeexist=(Boolean) designNode.get("EXIST");
					}
					if (nodeexist) {
						MechanicDesignUsinageManager.buildUsinageNode(this, node,usins,cavityOnly);
					}
				}
			}
			//créer usinage depuis systeme d'assemlage dynamic
			MechanicDesignAssemblyManager.createDynamicAssemblySystem(this,usins, cavityOnly);
		}
		super.createUsinage(usins,cavityOnly);
		if(partsManager!=null)
			partsManager.clearParts();
	}

	
	@Override
	public void deleteUsinage() throws Exception {
		List<DesignObject3D>childstobeDeleted =new ArrayList<DesignObject3D>();		
		//collecter les usinage qui référence sur cette piece comme parent 	
		for(DesignObject3D design:getChilds()) {
			
			if((design instanceof Usinage)|| (design instanceof Accessoire)) {
				childstobeDeleted.add(design);
			}
		}
				
		//supprimer tout les usinage qui référence sur cette piece comme parent 	
		for(DesignObject3D design:childstobeDeleted) {	
			
			deletechild(design,true);
		}
		clearFaces();
		
		super.deleteUsinage();
	}

	public List<Piece2D> gettangentedPieces(Piece2D piece,DesignObject3D frere) {
		 List<Piece2D> tangentedPiece=new ArrayList<Piece2D>();
		for(DesignObject3D child:frere.getChilds()) {
			if(child instanceof Space3D ) {
				tangentedPiece.addAll(gettangentedPieces(piece, child)) ;
			}
			if(child instanceof Piece2D) {
				if(piece.isIntersect(child).equals(IntersectionType.TANGENT)) {
					tangentedPiece.add((Piece2D) child);
				}
			}
		}
		return tangentedPiece;
		
	}
	
	public static List<Piece2D> getIntersectedPieces(DesignObject3D piece,DesignObject3D frere) {
		 List<Piece2D> intesectedPiece=new ArrayList<Piece2D>();
		for(DesignObject3D child:frere.getChilds()) {
			if(child instanceof Space3D) {
				intesectedPiece.addAll(Piece2D.getIntersectedPieces(piece, child)) ;
			}
			if(child instanceof Piece2D && !piece.equals(child)) {
				if(piece.isIntersect(child).equals(IntersectionType.INTERSECTION)) {
					intesectedPiece.add((Piece2D) child);
				}
			}
		}
		return intesectedPiece;
		
	}
	public boolean isintersect() {
		if(getRoot()==null) {
			return false;
		}
		List<Piece2D> intesectedPiece = Piece2D.getIntersectedPieces(this, getRoot());
		if(intesectedPiece!=null && intesectedPiece.size()>0) {
			for( Piece2D piece2:intesectedPiece) {
				if(piece2.getMechanicDesignDefinition().getType().equals(param.PieceType.OBSTACLE) ||getMechanicDesignDefinition().getType().equals(param.PieceType.OBSTACLE)) {
					continue;
				}
				if(piece2.getMechanicDesignDefinition().getType().equals(param.PieceType.ACCESOIRE) ||getMechanicDesignDefinition().getType().equals(param.PieceType.ACCESOIRE)) {
					continue;
				}
				if(piece2.getMechanicDesignElementDefinition().getType().equals(param.PieceType.ACCESOIRE) ||getMechanicDesignElementDefinition().getType().equals(param.PieceType.ACCESOIRE)) {
					continue;
				}
				if(piece2.hasMember(this) || hasMember(piece2) || piece2.getParent().equals(this)|| this.getParent().equals(piece2)) {
					continue;
				}
				if (! piece2.getPiecetype().equals(PieceType.DOS_INTERIEUR)
						||( piece2.getPiecetype().equals(PieceType.DOS_INTERIEUR) && getPiecetype().equals(PieceType.DOS_INTERIEUR) )) {
					if(( !piece2.getPiecetype().equals(PieceType.DOS_INTERIEUR) && getPiecetype().equals(PieceType.DOS_INTERIEUR) )) {
						continue;
					}else if( piece2.getPiecetype().equals(PieceType.DOS_INTERIEUR) && getPiecetype().equals(PieceType.DOS_INTERIEUR)){
						System.err.println(getName()+" intesected with s "+piece2.getParentdesign().getName()+"."+piece2.getName());
						return true;
					}else
					{
						System.err.println(getName()+" intesected with"+piece2.getParentdesign().getName()+"."+piece2.getName());
						return true;
					}
				}

			}
		}
			
			
			
		return false;	
	}
	
	/**
	 * Tester si cette piece est parellle de point de vue X
	 * c est a dire qui il sont tous les deux verticlae entre eux
	 * @param sld2 la deuxieme pièce
	 * @return
	 */
	public boolean isParallelAccordingtoX(Piece2D sld2) {
		// TODO Auto-generated method stub
		if(this.isVerticallPiece() && sld2.isVerticallPiece())
		{
			//deux pieces horizontales on teste si les y se chauvecheement
			return this.isIntersect(sld2).equals(IntersectionType.NOT_RELATED);
			
		}
		return false;
	}
	/**
	 * Tester si deux piece verticale on des y paratgé
	 * @param sld2
	 * @return
	 */
	public boolean isShareAccordingtoY(Piece2D sld2) {
		if(this.isVerticallPiece() && sld2.isVerticallPiece())
		{
			Plan3D plan1=new Plan3D(this);
			Plan3D plan2=new Plan3D(sld2);
			Plan3D intersection=plan1.getIntersection(plan2);
			if(intersection.getYinter()!=null && !intersection.getYinter().isPoint())
			{
				return true;
			}
		}
		return false;
	}
	
	public ArrayList<Vector3> getCornersList(){
		ArrayList<Vector3> corners = new ArrayList<Vector3>();
		Vector3 origin000 = new Vector3(0,0,0);
		Vector3 origin001 = new Vector3(0,0,(float) getProfondeurext());
		Vector3 origin010 = new Vector3(0,(float) getHauteurext(),0);
		Vector3 origin011 = new Vector3(0,(float) getHauteurext(),(float) getProfondeurext());
		Vector3 origin100 = new Vector3((float) getLongeurext(),0,0);
		Vector3 origin101 = new Vector3((float) getLongeurext(),0,(float) getProfondeurext());
		Vector3 origin110 = new Vector3((float) getLongeurext(),(float) getHauteurext(),0);
		Vector3 origin111 = new Vector3((float) getLongeurext(),(float) getHauteurext(),(float) getProfondeurext());
		corners.add(origin000);
		corners.add(origin001);
		corners.add(origin010);
		corners.add(origin011);
		corners.add(origin100);
		corners.add(origin101);
		corners.add(origin110);
		corners.add(origin111);
		return corners;
	}
	
	/**
	 * Tester si cette piece est parellle de point de vue y
	 * c est a dire qui il sont tous les deux horizontale entre eux
	 * @param sld2 la deuxieme pièce
	 * @return
	 */
	public boolean isParallelAccordingtoY(Piece2D sld2) {
		// TODO Auto-generated method stub
		if(this.isHorizontalePiece() && sld2.isHorizontalePiece())
		{
			//deux pieces horizontales on teste si les y se chauvecheement
			return this.isIntersect(sld2).equals(IntersectionType.NOT_RELATED);
			
		}
		return false;
	}
	public boolean isShareAccordingtoX(Piece2D sld2) {
		// TODO Auto-generated method stub
		if(this.isHorizontalePiece() && sld2.isHorizontalePiece())
		{
			Plan3D plan1=new Plan3D(this);
			Plan3D plan2=new Plan3D(sld2);
			Plan3D intersection=plan1.getIntersection(plan2);
			if(intersection.getXinter()!=null && !intersection.getXinter().isPoint())
			{
				return true;
			}
		}
		return false;
	}

	public PlanUsinage getPrimaryPrespective() {
		Orientation orient = getPieceOrientation();
		switch (orient) {
		case HORIZONTAL:
			return PlanUsinage.TOP;
		case PROUFOUND:
			return PlanUsinage.FRONT;
			
		case VERTICAL:
			return PlanUsinage.RIGHT;
			
		default:
			return PlanUsinage.FRONT;
		}
	}
	public PlanUsinage getSecondaryPrespective() {
		Orientation orient = getPieceOrientation();
		switch (orient) {
		case HORIZONTAL:
			
			return PlanUsinage.DOWN;
			
		case PROUFOUND:
			
			return PlanUsinage.BACK;
		case VERTICAL:
			return PlanUsinage.LEFT;

		default:
			return PlanUsinage.BACK;
		}
	}
	@Override
	public String toString() {
		// TODO Auto-generated method stub
		return "Piece  "+getName()+"[posx=" + xpos + ", posy=" + ypos + ", posz=" + zpos + ", longeur=" + getLongeurext()
				+ ", hauteur=" + getHauteurext() + ", profondeur=" + getProfondeurext()  + "]";
	}
	
	@Override
	public ArrayList<Couple> getSystemEquationAsParent() {

		ArrayList<Couple> systemesequationsasparent=new ArrayList<Couple>();
		systemesequationsasparent.add(new Couple(EngineKeys.parentLongeurExt, ""+getLongeurext()));
		systemesequationsasparent.add(new Couple(EngineKeys.parentProfondeurExt, ""+getProfondeurext()));
		systemesequationsasparent.add(new Couple(EngineKeys.parentHauteureExt, ""+getHauteurext()));
		
		systemesequationsasparent.add(new Couple(EngineKeys.parentLongeurint, ""+getLongeurext()));
		systemesequationsasparent.add(new Couple(EngineKeys.parentProfondeurint, ""+getProfondeurext()));
		systemesequationsasparent.add(new Couple(EngineKeys.parentHauteureint, ""+getHauteurext()));
		
		systemesequationsasparent.add(new Couple(EngineKeys.parentEpaisseurSecondaire, ""+getMaterial().getEpaisseur()));
		systemesequationsasparent.add(new Couple(EngineKeys.parentEpaisseurPrincipale, ""+getMaterial().getEpaisseur()));

		systemesequationsasparent.add(new Couple(EngineKeys.parentposx, ""+getXpos()));
		systemesequationsasparent.add(new Couple(EngineKeys.parentposy, ""+getYpos()));
		systemesequationsasparent.add(new Couple(EngineKeys.parentposz, ""+getZpos()));
		

		return systemesequationsasparent;
 	}
	@Override
	public List<Couple> getSystemEquation(Object emf) {
		List<Couple> systemesequations=new ArrayList<Couple>();
		if( emf != null && emf instanceof MechanicDesignElment )
		{					
			MechanicDesignElment utr = (MechanicDesignElment)emf;
			if(utr.getMaterial()!=null)
			{
				systemesequations.add(new Couple(EngineKeys.MATERIAL_Epaisseur, utr.getMaterial().getEpaisseur()+""));
			}
			return systemesequations;
		}
		return super.getSystemEquation(emf);
	}
	public int getFichedebitNumber() {
		return fichedebitNumber;
	}
	public void setFichedebitNumber(int fichedebitNumber) {
		this.fichedebitNumber = fichedebitNumber;
	}
	public List<Usinage> getusinage(){
		List<Usinage> usins=new ArrayList<Usinage>();
		for(DesignObject3D design:getChilds()) {
			if(design instanceof Usinage && !(design instanceof UsinageNode)) {
				usins.add((Usinage) design);
			}
		}
		return usins;
	}
	public List<Trou> getTrous(){
		List<Trou> trous = new ArrayList<Trou>();
		for(DesignObject3D design:getChilds()) {
			if(design instanceof Trou) {
				trous.add((Trou) design);
			}
		}
		return trous;
	}
	
	public List<Usinage> getCavities(){
		List<Usinage> rainures = new ArrayList<Usinage>();
		for(DesignObject3D design:getChilds()) {
			if((design instanceof Rainure) || (design instanceof Cavity)) {
				rainures.add((Usinage) design);
			}
		}
		return rainures;
	}
	public List<Cavity> getPiecesCavities(){
		List<Cavity> rainures = new ArrayList<Cavity>();
		for(DesignObject3D design:getChilds()) {
			if(design instanceof Cavity) {
				rainures.add((Cavity) design);
			}
		}
		return rainures;
	}
	public List<Rainure> getPiecesRainures(){
		List<Rainure> rainures = new ArrayList<Rainure>();
		for(DesignObject3D design:getChilds()) {
			if(design instanceof Rainure) {
				rainures.add((Rainure) design);
			}
		}
		return rainures;
	}
	
	@Override
	public void dispose() {
		// TODO Auto-generated method stub
		super.dispose();
		piecetype = null;
		material = null;
		if (mechanicDesignElementDefinition != null)
			mechanicDesignElementDefinition.dispose();

		if (materialType != null)
			materialType.dispose();
		
		if (vitreMaterialType != null)
			materialType.dispose();
		
		mechanicDesignElementDefinition=null;
		materialType = null;
		vitreMaterialType = null;
	}

		public Vector3 getCenter() {
			Vector3 halfSize = getSize().scl(0.5f);
			return getPosition().add(halfSize);
		}
		
	public boolean isMaterialTypeProduction() {
		if(getMechanicDesignElementDefinition().getMaterialType()!=null 
				&& getMechanicDesignElementDefinition().getMaterialType().getMaterial()!=null 
				&& getMechanicDesignElementDefinition().getMaterialType().getMaterial().isProduction()) {
			return true;
		}
		
		return false;
	}
	
	// in meters
	public Vector3 getPosition() {
		return new Vector3((float)getXPosABS(), (float)getYPosABS(), (float)getZPosABS());//.scl(0.001f);
	}
	
		@Override
		public void clearautomatique(boolean isuser) throws Exception {
			super.clearautomatique(isuser);
			if(partsManager!=null)
				partsManager.clearParts();
		}
		public void clearFaces() {
			faces.stream().forEach(e->
			{
			try {
				e.getAssemblies().forEach(a->{
					try {
						a.clearautomatique(true);
						a.setFace(null);
					} catch (Exception e1) {
						// TODO Auto-generated catch block
						e1.printStackTrace();
					}
				});
				e.getAssemblies().clear();
				e.clearautomatique(true);
				e.setParentdesign(null);
			} catch (Exception e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}});
			faces.clear();
			faces.trimToSize();
		}

		public ArrayList<FaceModel> getFaces() {
			return faces;
		}
		public void setFaces(ArrayList<FaceModel> faces) {
			this.faces = faces;
		}
		public PieceSplitManager getPartsManager() {
			return partsManager;
		}
		public void setPartsManager(PieceSplitManager partsManager) {
			this.partsManager = partsManager;
		}
}
