package dressing.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

import org.frs.debitage.engine.core.evalutor.GeometricEngineException;

import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;

import dressing.cam.model.Direction;
import dressing.model.types.IntersectionType;
import dressing.model.types.Orientation;
import param.AssemblyContainer;
import param.AssemblySystem;
import param.AssemblySystemsPreference;
import param.AssemblySystemsPreferenceGroup;
import param.Axe;
import param.MechanicDesign;
import param.MechanicPrivateParam;
import param.MechanicPublicParam;
import param.UsinageNode;
import param.cam.MachineSides;

public class MechanicDesignAssemblyManager {
	
	/**
	 * @param usins
	 * @param cavityOnly
	 * @throws DesignException
	 * @throws GeometricEngineException
	 */
	public static void createDynamicAssemblySystem(Piece2D piece ,List<Usinage> usins, boolean cavityOnly)
			throws DesignException, GeometricEngineException {
		if(piece.getMechanicDesignDefinition()!=null
				&& piece.getMechanicDesignElementDefinition()!=null 
				&& piece.getMechanicDesignElementDefinition().getAssemblySystemsfaces()!=null && piece.getMechanicDesignElementDefinition().getAssemblySystemsfaces().size()>0) {
			MechanicDesign design =piece.getMechanicDesignDefinition();
			List<MechanicPublicParam> publicparams=new ArrayList<MechanicPublicParam>();
			if(design!=null &&design.getPublicparamgroup()!=null &&design.getPublicparamgroup().getMechanicpublicparam()!=null)
			{
				publicparams.addAll(design.getPublicparamgroup().getMechanicpublicparam());
			}
			
			List<MechanicPrivateParam> privateparams=new ArrayList<MechanicPrivateParam>();
			if(design!=null &&design.getPrivateparamgroup()!=null &&design.getPrivateparamgroup().getMechanicprivateparam()!=null)

			{
				privateparams =design.getPrivateparamgroup().getMechanicprivateparam();
			}
			for(param.Face node:piece.getMechanicDesignElementDefinition().getAssemblySystemsfaces()) {
				FaceModel face=new FaceModel(node,piece);
				
				face.constructGenericDebitage(privateparams, publicparams, node, piece);

				if (node.isImportMethod() || node.getAssemblySystem() == null) {
					AssemblySystemsPreference assemblySystemsPreference = AssemblySystemsPreferenceResolver
							.resolvePreference(design, node.getSide());
					if (assemblySystemsPreference == null) {
						continue;
					}
					node.setAssemblySystem(assemblySystemsPreference.getAssemblySystem());
				}
				piece.getFaces().add(face);
				if ((Boolean) face.get("EXIST")) {	
					Axe faceAXE = getFaceAxe(face);
					for(AssemblySystem system:node.getAssemblySystem().getAssemblySystems()) {
						if(face.getLongeurext() >=system.getMinRange() && face.getLongeurext()< system.getMaxRange()) {
						
							for(AssemblyContainer container: system.getAssemblies()) {
								if (container.getAssembly() == null) {
									continue;
								}
								AssemblyContainerModel model = new AssemblyContainerModel(container, face);
								model.constructGenericDebitage(null,
										system.getPublicparamgroup().getMechanicpublicparam(), container, face);
								face.getAssemblies().add(model);
								
								List<Piece2D> intesectedPiece = Piece2D.getIntersectedPieces(model, piece.getRoot());
								if (intesectedPiece.size()<=1|| intesectedPiece.isEmpty() || intesectedPiece.stream().filter(p->!p.equals(piece)).findAny()==null) {
									continue;
								}
								
								MechanicDesignAssemblyManager.checkAssemblyIntersectionWithPieces(piece, face, faceAXE,model, intesectedPiece);
//								System.err.println(model.getName()+" >" +intersected);
								face.addElement(model);
//								Date deb = new Date();
								if(model.getNode().getAssembly().getUsinage()!=null){
									MechanicDesignAssemblyManager.createContainerUsianges(usins, cavityOnly, face, model);
								}
//								System.err.println("calcul usin assembly containrer took"+(new Date().getTime()-deb.getTime()));

							}
						}
					}
				}
				
				
			}
		}
	}
	
	/**
	 * @param usins
	 * @param cavityOnly
	 * @param plane
	 * @param transform
	 * @param rotationMatrix
	 * @param container
	 * @param containerPos
	 * @throws DesignException
	 * @throws GeometricEngineException
	 */
	public static void createContainerUsianges(List<Usinage> usins, boolean cavityOnly, FaceModel plane,
			AssemblyContainerModel container) throws DesignException, GeometricEngineException {
		Matrix4 transform = plane.getTransformMatrix();
		Matrix3 rotationMatrix = plane.getRotationMatrix();
		Vector3 containerPos = container.getPosition();
		UsinageNode usinageNode = container.getNode().getAssembly().getUsinage();
		List<Usinage> usinsnode = new ArrayList<Usinage>();
		MechanicDesignUsinageManager.buildUsinageNode(plane, usinageNode, usinsnode, cavityOnly);
		for (Usinage usin : usinsnode) {
			if (usin instanceof Trou) {
				Trou tr = (Trou) usin;
				MechanicDesignAssemblyManager.transormTrouToPiece(plane.getPiece(), transform, rotationMatrix, container.getNode(), containerPos, tr);
			}
			container.addUsinage(usin);
		}
		
		usins.addAll(usinsnode);
	}
	

	/**
	 * @param transform
	 * @param rotationMatrix
	 * @param container
	 * @param containerPos
	 * @param tr
	 * @throws DesignException
	 * @throws GeometricEngineException
	 */
	public static void transormTrouToPiece(Piece2D parent, Matrix4 transform, Matrix3 rotationMatrix, AssemblyContainer container,
			Vector3 containerPos, Trou tr) throws DesignException, GeometricEngineException {
		Vector3 trPos=new Vector3((float)(tr.getXpos()+containerPos.x), (float)(tr.getYpos()+containerPos.y), (float)(tr.getZpos()+containerPos.z));
		Vector3 images = trPos.cpy().mul(transform);
		tr.setXpos(images.x);
		tr.setYpos(images.y);
		tr.setZpos(images.z);
		Vector3 VoriginDirection =tr.getDirection().toVector();
		Vector3 VRotatedDirection = VoriginDirection.cpy().mul(rotationMatrix);
		//transform the new direction back to ENUM for later use
		tr.setDirection(dressing.cam.model.Direction.fromVector(VRotatedDirection));
		tr.setName(tr.getName()+ " " + container.getName()+" "+tr.getParentdesign().getName());
		tr.setMother(parent);
		parent.addElement(tr);
	}
	


	/**
	 * @param faceDirection
	 * @return
	 */
	public static Axe getFaceAxe(FaceModel face) {
		Direction faceDirection = face.getDirX();
		Axe faceAXE=Axe.X;
		switch (faceDirection) {
		case XMINUS:
		case XPLUS:
			faceAXE=Axe.X;
			break;
		case YMINUS:
		case YPLUS:
			faceAXE=Axe.Y;
			break;
		case ZMINUS:
		case ZPLUS:
			faceAXE=Axe.Z;
		default:
			break;
		}
		return faceAXE;
	}

	/**
	 * @param piece
	 * @param face
	 * @param faceAXE
	 * @param model
	 * @param intesectedPiece
	 * @param mother
	 * @return
	 */
	public static void checkAssemblyIntersectionWithPieces(Piece2D piece, FaceModel face, Axe faceAXE,
			AssemblyContainerModel model, List<Piece2D> intesectedPiece) {
		Piece2D mother=null;
		List<Piece2D> intersected=intesectedPiece.stream().filter(p->!p.equals(piece)).collect(Collectors.toList());
		for(Piece2D intersect: intersected) {
			switch (faceAXE) {
			case X:
				if(intersect.getPieceOrientation().equals(Orientation.VERTICAL)) {
					intersect.setErrorexist(true);
					intersect.setErrormsg(intersect.getErrormsg()+"\n"+ "Pièce "+intersect.getName() +" est en intersection avec Assemblage "+model.getNode().getAssembly().getName()+" de " +piece.getName()+">"+face.getName()+">"+model.getName());
					System.err.println("Pièce 2"+intersect.getName() +" est en intersection avec Assemblage "+piece.getName()+">"+face.getName()+">"+model.getName());
					continue;
				}
				break;
			case Y:
				if(intersect.getPieceOrientation().equals(Orientation.HORIZONTAL)) {
					intersect.setErrorexist(true);
					intersect.setErrormsg(intersect.getErrormsg()+"\n"+ "Pièce "+intersect.getName() +" est en intersection avec Assemblage "+model.getNode().getAssembly().getName()+" de " +piece.getName()+">"+face.getName()+">"+model.getName());
					System.err.println("Pièce 3"+intersect.getName() +" est en intersection avec Assemblage "+piece.getName()+">"+face.getName()+">"+model.getName());
					continue;
				}
				break;
			case Z:
				if(intersect.getPieceOrientation().equals(Orientation.PROUFOUND)) {
					intersect.setErrorexist(true);
					intersect.setErrormsg(intersect.getErrormsg()+"\n"+ "Pièce "+intersect.getName() +" est en intersection avec Assemblage "+model.getNode().getAssembly().getName()+" de " +piece.getName()+">"+face.getName()+">"+model.getName());
					System.err.println("Pièce 4"+intersect.getName() +" est en intersection avec Assemblage "+piece.getName()+">"+face.getName()+">"+model.getName());
					continue;
				}
				break;
			default:
				break;
			}
			
			if(piece.isIntersect(intersect).equals(IntersectionType.TANGENT)) {
				model.setMotherPiece(mother);
			}else {
				intersect.setErrorexist(true);
				intersect.setErrormsg(intersect.getErrormsg()+"\n"+ "Pièce "+intersect.getName() +" est en intersection avec Assemblage "+piece.getName()+">"+face.getName()+">"+model.getName());
				System.err.println("Pièce "+intersect.getName() +" est en intersection avec Assemblage "+piece.getName()+">"+face.getName()+">"+model.getName());

			}
			
		}
	}

	public static double getDimentionFromDirection(Direction dir,DesignObject3D box){
		switch (dir) {
		case XMINUS:
		case XPLUS:
			return box.getLongeurext();
		case YMINUS:
		case YPLUS:
			return box.getHauteurext();
		case ZMINUS:
		case ZPLUS:
			return box.getProfondeurext();
		default:
			return box.getLongeurext();
		}
		
		
	}
	
	public static double getPositionFromDirection(Direction dir,DesignObject3D box, double decalage){
		switch (dir) {
		case XMINUS:
			return box.getLongeurext()-decalage;
		case XPLUS:
			return decalage;
		case YMINUS:
			return box.getHauteurext()-decalage;
		case YPLUS:
			return decalage;
		case ZMINUS:
			return box.getProfondeurext()-decalage;
		case ZPLUS:
			return decalage;
		default:
			return decalage;
		}
		
		
	}
	
	public static Vector3 getVector(Direction dir) {
		switch (dir) {
		case XMINUS:
		case XPLUS:
			return new Vector3(1, 0, 0);
		case YMINUS:
		case YPLUS:
			return new Vector3(0, 1, 0);
		case ZMINUS:
		case ZPLUS:
			return new Vector3(0, 0, 1);
		default:
			return new Vector3(1, 0, 0);
		}
	}
	

//	/**
//	 * @param usins
//	 * @param cavityOnly
//	 * @param plane
//	 * @param transform
//	 * @param rotationMatrix
//	 * @param system
//	 * @param container
//	 * @throws DesignException
//	 * @throws GeometricEngineException
//	 */
//	private void evaluateAssemblyContainer(List<Usinage> usins, boolean cavityOnly, Piece2D plane, Matrix4 transform,
//			Matrix3 rotationMatrix, AssemblySystem system, AssemblyContainerModel container)
//			throws DesignException, GeometricEngineException {
//		Vector3 containerPos=new Vector3();
//		param.Vertex vertex	=container.getPosition();
//		GeomtericEngine engine= GeomtericEngineManager.getInstance().getGeomtericEngine();
//		GenericDebitageFormula.fillequationsfromparent(plane, engine.getEquations());
//		GenericDebitageFormula.fillequationsfrompublicparam(engine.getEquations(), system.getPublicparamgroup().getMechanicpublicparam());
//		engine.getEquations().add(new Equation(vertex.getX().getKey(), vertex.getX().getExpression(), Equation.CALCULATION_MANUAL));
//		engine.getEquations().add(new Equation(vertex.getY().getKey(), vertex.getY().getExpression(), Equation.CALCULATION_MANUAL));
//		engine.getEquations().add(new Equation(vertex.getZ().getKey(), vertex.getZ().getExpression(), Equation.CALCULATION_MANUAL));
//		engine.reset();
//		Equation x=Equation.FIND_EQUATION(vertex.getX().getKey(), engine.getEquations());
//		Equation y=Equation.FIND_EQUATION(vertex.getY().getKey(), engine.getEquations());
//		Equation z=Equation.FIND_EQUATION(vertex.getZ().getKey(), engine.getEquations());
//		try {
//			engine.resolveEquation(x);
//			engine.resolveEquation(y);
//			engine.resolveEquation(z);
//			containerPos.set((float)(x.getEvaluation(GeomtericEngine.getEngine())+0.0f), (float)(y.getEvaluation(GeomtericEngine.getEngine())+0.0f), (float)(z.getEvaluation(GeomtericEngine.getEngine())+0.0f));
//
//		} catch (GeometricEngineException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		}
//		createContainerUsianges(usins, cavityOnly, plane, transform, rotationMatrix, container, containerPos);
//	}
	public void ubdateChildsAssemblyPreferences(MechanicDesign mechanicdesign) {
		if(mechanicdesign!=null && mechanicdesign.getMechanicdesign()!=null && !mechanicdesign.getMechanicdesign().isEmpty()) {
			for(MechanicDesign child :mechanicdesign.getMechanicdesign())
			{
				updateAssemblyPreferencesFromParentDesign(mechanicdesign, child);
			}
		}
		
	}
	public static void updateAssemblyPreferencesFromParentDesign(MechanicDesign parentDesign, MechanicDesign mechanicDesign) {
	    AssemblySystemsPreferenceGroup parentPreferences = parentDesign.getAssemblySystemsPreferences();
	    List<AssemblySystemsPreference> parentImportedPreferences = parentDesign.getInportedAssemblySystemsPreferences();

	    AssemblySystemsPreferenceGroup preferences = mechanicDesign.getAssemblySystemsPreferences();
	    List<AssemblySystemsPreference> importedPreferencesFromParent = new ArrayList<>();

	    if (parentPreferences != null && !parentPreferences.getPreferences().isEmpty()) {
	        for (AssemblySystemsPreference parentPref : parentPreferences.getPreferences()) {
	            if (preferences == null || preferences.getPreferences().isEmpty() 
	                || !checkPreferenceExist(preferences.getPreferences(), parentPref)) {
	                importedPreferencesFromParent.add(parentPref);
	            }
	        }
	    }

	    if (parentImportedPreferences != null && !parentImportedPreferences.isEmpty()) {
	        for (AssemblySystemsPreference parentPref : parentImportedPreferences) {
	            boolean alreadyInPreferences = preferences != null && !preferences.getPreferences().isEmpty() 
	                                            && checkPreferenceExist(preferences.getPreferences(), parentPref);
	            boolean alreadyImported = checkPreferenceExist(importedPreferencesFromParent, parentPref);
	            if (!alreadyInPreferences && !alreadyImported) {
	                importedPreferencesFromParent.add(parentPref);
	            }
	        }
	    }
	    mechanicDesign.getInportedAssemblySystemsPreferences().clear();
	    mechanicDesign.getInportedAssemblySystemsPreferences().addAll(importedPreferencesFromParent);
	   
	}


	/**
	 * @param preferences
	 * @param parentPref
	 * @return
	 */
	public static boolean checkPreferenceExist(List<AssemblySystemsPreference> preferences,
			AssemblySystemsPreference parentPref) {
		 return preferences.stream()
			        .anyMatch(pref ->  ( pref.getFaceSide().equals(parentPref.getFaceSide()) && !pref.isAllSides() && !parentPref.isAllSides()) || (pref.isAllSides() && parentPref.isAllSides()));
	}
	
	public static AssemblySystemsPreference resolveAssemblyPreference(MechanicDesign design, MachineSides faceSide) {
	    // 1. Check local design preferences
	    AssemblySystemsPreferenceGroup localPreferences = design.getAssemblySystemsPreferences();
	    if (localPreferences != null && !localPreferences.getPreferences().isEmpty()) {
	        Optional<AssemblySystemsPreference> localPref = localPreferences.getPreferences().stream()
	            .filter(pref -> pref.getFaceSide().equals(faceSide) && !pref.isAllSides())
	            .findFirst();
	        if (localPref.isPresent()) {
	            return localPref.get();
	        }
	        // If not found, check for an 'allSides' preference
	        Optional<AssemblySystemsPreference> localAllSidesPref = localPreferences.getPreferences().stream()
	            .filter(pref -> pref.isAllSides())
	            .findFirst();
	        if (localAllSidesPref.isPresent()) {
	            return localAllSidesPref.get();
	        }
	    }

	    // 2. Check imported (parent) preferences
	    List<AssemblySystemsPreference> importedPreferences = design.getInportedAssemblySystemsPreferences();
	    if (importedPreferences != null && !importedPreferences.isEmpty()) {
	        Optional<AssemblySystemsPreference> importedPref = importedPreferences.stream()
	            .filter(pref -> pref.getFaceSide().equals(faceSide) && !pref.isAllSides())
	            .findFirst();
	        if (importedPref.isPresent()) {
	            return importedPref.get();
	        }
	        // Check 'allSides' in imported preferences
	        Optional<AssemblySystemsPreference> importedAllSidesPref = importedPreferences.stream()
	            .filter(pref -> pref.isAllSides())
	            .findFirst();
	        if (importedAllSidesPref.isPresent()) {
	            return importedAllSidesPref.get();
	        }
	    }

	    // 3. Default
//	    return AssemblySystemsPreference.defaultPreference();
	    return null;
	}
}
